/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.jboss.qa.jcontainer.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client<T extends Configuration>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    protected T configuration;

    public Client(T configuration) {
        this.configuration = configuration;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public abstract boolean isConnected();

    protected abstract void connectInternal() throws Exception;

    public void connect() throws Exception {
        if (!this.isConnected()) {
            this.connectInternal();
        }
        log.info("Client was connected");
    }

    protected abstract void executeInternal(String var1) throws Exception;

    protected abstract void executeInternal(List<String> var1) throws Exception;

    public void execute(String command) throws Exception {
        log.info("Execute command: {}", (Object)command);
        if (!this.isConnected()) {
            this.connect();
        }
        this.executeInternal(command);
    }

    public void execute(List<String> commands) throws Exception {
        log.info("Execute commands:");
        int i = 1;
        for (String cmd : commands) {
            log.info("#{}\t{}", (Object)i++, (Object)cmd);
        }
        if (!this.isConnected()) {
            this.connect();
        }
        this.executeInternal(commands);
    }

    protected abstract void closeInternal() throws IOException;

    @Override
    public void close() throws IOException {
        if (this.isConnected()) {
            this.closeInternal();
        }
        log.info("Client was disconnected");
    }
}

