/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.jboss;

import java.io.File;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jboss.qa.jcontainer.Container;
import org.jboss.qa.jcontainer.User;
import org.jboss.qa.jcontainer.jboss.JBossClient;
import org.jboss.qa.jcontainer.jboss.JBossConfiguration;
import org.jboss.qa.jcontainer.jboss.JBossUser;

public class JBossContainer<T extends JBossConfiguration, U extends JBossClient<T>, V extends JBossUser>
extends Container<T, U, V> {
    public JBossContainer(T configuration) {
        super(configuration);
    }

    @Override
    public void addUser(V user) throws Exception {
        File rolesFile;
        File usersFile;
        if (((JBossUser)user).getRealm() == null) {
            ((JBossUser)user).setRealm(JBossUser.Realm.MANAGEMENT_REALM);
        }
        this.checkMandatoryProperty("username", ((User)user).getUsername());
        this.checkMandatoryProperty("password", ((User)user).getUsername());
        if (((JBossUser)user).getRealm().equals((Object)JBossUser.Realm.APPLICATION_REALM)) {
            usersFile = new File(((JBossConfiguration)this.configuration).getConfigurationFolder(), "application-users.properties");
            rolesFile = new File(((JBossConfiguration)this.configuration).getConfigurationFolder(), "application-roles.properties");
        } else {
            usersFile = new File(((JBossConfiguration)this.configuration).getConfigurationFolder(), "mgmt-users.properties");
            rolesFile = new File(((JBossConfiguration)this.configuration).getConfigurationFolder(), "mgmt-groups.properties");
        }
        PropertiesConfiguration propConfUsers = new PropertiesConfiguration(usersFile);
        propConfUsers.setProperty(((User)user).getUsername(), (Object)DigestUtils.md5Hex((String)String.format("%s:%s:%s", ((User)user).getUsername(), ((JBossUser)user).getRealm().getValue(), ((User)user).getPassword())));
        propConfUsers.save();
        PropertiesConfiguration propConfRoles = new PropertiesConfiguration(rolesFile);
        propConfRoles.setProperty(((User)user).getUsername(), (Object)StringUtils.join(((User)user).getRoles(), (String)","));
        propConfRoles.save();
    }
}

