/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.phase.download;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.jboss.qa.jenkins.test.executor.JenkinsTestExecutor;
import org.jboss.qa.jenkins.test.executor.beans.Destination;
import org.jboss.qa.jenkins.test.executor.phase.download.Download;
import org.jboss.qa.jenkins.test.executor.utils.AntEr;
import org.jboss.qa.jenkins.test.executor.utils.unpack.UnPacker;
import org.jboss.qa.jenkins.test.executor.utils.unpack.UnPackerRegistry;
import org.jboss.qa.phaser.InstanceRegistry;
import org.jboss.qa.phaser.PhaseDefinitionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadPhaseProcessor
extends PhaseDefinitionProcessor {
    private static final Logger log = LoggerFactory.getLogger(DownloadPhaseProcessor.class);
    private Download download;

    private static void registerDestination(String id, File destination) {
        if (!id.isEmpty()) {
            InstanceRegistry.insert((String)id, (Object)new Destination(destination));
        }
    }

    public void execute() {
        log.debug("@{} - {}", (Object)Download.class.getName(), (Object)this.download.id());
        File downloaded = this.download();
        DownloadPhaseProcessor.registerDestination(this.download.destination().id(), downloaded);
        if (this.download.unpack().unpack()) {
            File unpacked = this.unpack(downloaded);
            DownloadPhaseProcessor.registerDestination(this.download.unpack().destination().id(), unpacked);
        }
    }

    private File download() {
        File destination = new File(JenkinsTestExecutor.WORKSPACE, this.download.destination().destination());
        destination.mkdirs();
        log.info("Download resource \"{}\"", (Object)this.download.id());
        AntEr.build().param("src", this.download.url()).param("dest", destination.getAbsolutePath()).param("verbose", this.download.verbose() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()).invoke("get");
        return destination;
    }

    private File unpack(File downloaded) {
        File unpacked = downloaded;
        if (!this.download.unpack().destination().destination().isEmpty()) {
            unpacked = new File(JenkinsTestExecutor.WORKSPACE, this.download.unpack().destination().destination());
        }
        File archive = new File(downloaded, this.download.url().substring(this.download.url().lastIndexOf("/")));
        log.info("Unpack resource {}", (Object)this.download.id());
        try {
            UnPacker unPacker = UnPackerRegistry.get(FilenameUtils.getExtension((String)this.download.url()));
            if (unPacker == null) {
                throw new RuntimeException("No existing UnPacker for " + this.download.url());
            }
            unPacker.setPathSegmentsToTrim(this.download.unpack().pathSegmentsToTrim());
            unPacker.setIgnoreRootFolders(this.download.unpack().ignoreRootFolders());
            unPacker.unpack(archive, unpacked);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return unpacked;
    }

    @ConstructorProperties(value={"download"})
    public DownloadPhaseProcessor(Download download) {
        this.download = download;
    }
}

