/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jboss.qa.jenkins.test.executor.utils.OSDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenCli {
    private static final Logger log = LoggerFactory.getLogger(MavenCli.class);
    protected final File mavenHome;
    protected final File javaHome;
    protected final String xms;
    protected final String xmx;
    protected final String maxPermSize;
    protected final File pom;
    protected final boolean alsoMake;
    protected final boolean failAtEnd;
    protected final List<String> goals;
    protected final List<String> profiles;
    protected final List<String> projects;
    protected final List<String> mavenOpts;
    protected final Map<String, String> sysProps;
    protected final List<String> params;

    private MavenCli(Builder builder) {
        this.mavenHome = builder.mavenHome;
        this.checkMandatoryProperty("mavenHome", this.mavenHome);
        this.javaHome = builder.javaHome;
        this.checkMandatoryProperty("javaHome", this.javaHome);
        this.pom = builder.pom;
        this.checkMandatoryProperty("pom", this.pom);
        this.goals = builder.goals;
        this.checkMandatoryProperty("goals", this.goals);
        this.xms = builder.xms;
        this.xmx = builder.xmx;
        this.maxPermSize = builder.maxPermSize;
        this.mavenOpts = builder.mavenOpts;
        this.sysProps = builder.sysProps;
        this.profiles = builder.profiles;
        this.projects = builder.projects;
        this.params = builder.params;
        this.alsoMake = builder.alsoMake;
        this.failAtEnd = builder.failAtEnd;
    }

    protected void checkMandatoryProperty(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Property '%s' is mandatory", name));
        }
    }

    public String getXms() {
        return this.xms;
    }

    public String getXmx() {
        return this.xmx;
    }

    public String getMaxPermSize() {
        return this.maxPermSize;
    }

    public List<String> getParams() {
        return this.params;
    }

    public File getMavenHome() {
        return this.mavenHome;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public File getPom() {
        return this.pom;
    }

    public boolean isAlsoMake() {
        return this.alsoMake;
    }

    public boolean isFailAtEnd() {
        return this.failAtEnd;
    }

    public List<String> getMavenOpts() {
        return this.mavenOpts;
    }

    public Map<String, String> getSysProps() {
        return this.sysProps;
    }

    public List<String> getGoals() {
        return this.goals;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public List<String> getProjects() {
        return this.projects;
    }

    public void run() throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        if (OSDetector.isWindows()) {
            cmd.add("cmd");
            cmd.add("/c");
            cmd.add(this.mavenHome + "/bin/mvn.bat");
        } else {
            cmd.add("/bin/bash");
            cmd.add(this.mavenHome + "/bin/mvn");
        }
        if (this.xms != null) {
            this.mavenOpts.add("-Xms" + this.xms);
        }
        if (this.xmx != null) {
            this.mavenOpts.add("-Xmx" + this.xmx);
        }
        if (this.maxPermSize != null) {
            this.mavenOpts.add("-XX:MaxPermSize=" + this.maxPermSize);
        }
        cmd.add("-f");
        cmd.add(this.pom.getAbsolutePath());
        cmd.addAll(this.goals);
        if (!this.profiles.isEmpty()) {
            cmd.add("-P" + StringUtils.join(this.profiles, (String)","));
        }
        if (!this.projects.isEmpty()) {
            cmd.add("-pl");
            cmd.add(StringUtils.join(this.projects, (String)","));
        }
        if (this.alsoMake) {
            cmd.add("-am");
        }
        if (this.failAtEnd) {
            cmd.add("-fae");
        }
        for (Map.Entry<String, String> entry : this.sysProps.entrySet()) {
            cmd.add(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
        }
        if (this.params != null) {
            cmd.addAll(this.params);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        processBuilder.environment().put("JAVA_HOME", this.javaHome.getAbsolutePath());
        processBuilder.environment().put("M2_HOME", this.mavenHome.getAbsolutePath());
        processBuilder.environment().put("MAVEN_OTPS", StringUtils.join(this.mavenOpts, (String)" "));
        log.debug("===========");
        log.debug("Process arguments: " + ((Object)cmd).toString());
        log.debug("JAVA_HOME={}", (Object)processBuilder.environment().get("JAVA_HOME"));
        log.debug("M2_HOME={}", (Object)processBuilder.environment().get("M2_HOME"));
        log.debug("MAVEN_OTPS={}", (Object)processBuilder.environment().get("MAVEN_OTPS"));
        Process process = processBuilder.start();
        process.waitFor();
        if (process.exitValue() != 0) {
            log.error("Maven execution failed with exit code: " + process.exitValue());
        }
    }

    public static class Builder {
        private File mavenHome;
        private File javaHome;
        private String xms = "64m";
        private String xmx = "256m";
        private String maxPermSize = "512m";
        private File pom;
        private boolean alsoMake = false;
        private boolean failAtEnd = false;
        private List<String> goals = new ArrayList<String>();
        private List<String> profiles = new ArrayList<String>();
        private List<String> projects = new ArrayList<String>();
        private List<String> mavenOpts = new ArrayList<String>();
        private Map<String, String> sysProps = new HashMap<String, String>();
        private List<String> params = new ArrayList<String>();

        public Builder mavenHome(File mavenHome) {
            this.mavenHome = mavenHome;
            return this;
        }

        public Builder javaHome(File javaHome) {
            this.javaHome = javaHome;
            return this;
        }

        public Builder xms(String xms) {
            this.xms = xms;
            return this;
        }

        public Builder xmx(String xmx) {
            this.xmx = xmx;
            return this;
        }

        public Builder maxPermSize(String maxPermSize) {
            this.maxPermSize = maxPermSize;
            return this;
        }

        public Builder alsoMake(boolean alsoMake) {
            this.alsoMake = alsoMake;
            return this;
        }

        public Builder failAtEnd(boolean failAtEnd) {
            this.failAtEnd = failAtEnd;
            return this;
        }

        public Builder pom(File pom) {
            this.pom = pom;
            return this;
        }

        public Builder pom(String pom) {
            this.pom = new File(pom);
            return this;
        }

        public Builder goals(String ... goals) {
            this.goals.addAll(Arrays.asList(goals));
            return this;
        }

        public Builder profiles(String ... profiles) {
            this.profiles.addAll(Arrays.asList(profiles));
            return this;
        }

        public Builder projects(String ... projects) {
            this.projects.addAll(Arrays.asList(projects));
            return this;
        }

        public Builder mavenOpts(String ... mavenOpts) {
            this.mavenOpts.addAll(Arrays.asList(mavenOpts));
            return this;
        }

        public Builder sysProp(String key, String value) {
            this.sysProps.put(key, value);
            return this;
        }

        public Builder params(String ... params) {
            this.params.addAll(Arrays.asList(params));
            return this;
        }

        public MavenCli build() {
            return new MavenCli(this);
        }
    }
}

