/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.utils.unpack;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.jboss.qa.jenkins.test.executor.utils.unpack.UnPacker;

public class UnZipper
extends UnPacker {
    private static final String TYPE = "zip";

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void unpack(File archive, File destination) throws IOException {
        try (ZipFile zip = new ZipFile(archive);){
            HashSet entries = new HashSet(Collections.list(zip.getEntries()));
            if (this.ignoreRootFolders) {
                this.pathSegmentsToTrim = UnZipper.countRootFolders(entries);
            }
            for (ZipArchiveEntry entry : entries) {
                if (entry.isDirectory()) continue;
                String zipPath = UnZipper.trimPathSegments(entry.getName(), this.pathSegmentsToTrim);
                File file = new File(destination, zipPath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try (InputStream is = zip.getInputStream(entry);
                     FileOutputStream fos = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                    if ((entry.getUnixMode() & 0x40) != 0) {
                        file.setExecutable(true);
                    }
                }
                file.setLastModified(entry.getTime());
            }
        }
    }
}

