/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor;

import java.io.File;
import org.jboss.qa.jenkins.test.executor.beans.Workspace;
import org.jboss.qa.jenkins.test.executor.phase.cleanup.CleanUpPhase;
import org.jboss.qa.jenkins.test.executor.phase.download.DownloadPhase;
import org.jboss.qa.jenkins.test.executor.phase.execution.ExecutionPhase;
import org.jboss.qa.jenkins.test.executor.phase.runtimeconfiguration.RuntimeConfigurationPhase;
import org.jboss.qa.jenkins.test.executor.phase.start.StartPhase;
import org.jboss.qa.jenkins.test.executor.phase.staticconfiguration.StaticConfigurationPhase;
import org.jboss.qa.jenkins.test.executor.phase.stop.StopPhase;
import org.jboss.qa.jenkins.test.executor.utils.JenkinsUtils;
import org.jboss.qa.phaser.InstanceRegistry;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.PhaseTreeBuilder;
import org.jboss.qa.phaser.Phaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsTestExecutor {
    private static final Logger log = LoggerFactory.getLogger(JenkinsTestExecutor.class);
    public static final File WORKSPACE = new File(JenkinsUtils.getUniversalProperty("workspace", "target"));
    private Class<?> jobClass;

    public JenkinsTestExecutor(Class<?> jobClass) {
        this.jobClass = jobClass;
    }

    public void run() throws Exception {
        InstanceRegistry.insert((Object)new Workspace(WORKSPACE));
        PhaseTreeBuilder builder = new PhaseTreeBuilder();
        builder.addPhase((Phase)new DownloadPhase()).next().addPhase((Phase)new StaticConfigurationPhase()).addPhase((Phase)new StartPhase()).addPhase((Phase)new RuntimeConfigurationPhase()).addPhase((Phase)new ExecutionPhase()).addPhase((Phase)new StopPhase()).addPhase((Phase)new CleanUpPhase());
        new Phaser(builder.build(), this.jobClass).run();
    }
}

