/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenCli {
    private static final Logger log = LoggerFactory.getLogger(MavenCli.class);
    protected final File mavenHome;
    protected final File javaHome;
    protected final String xms;
    protected final String xmx;
    protected final String maxPermSize;
    protected final File pom;
    protected final boolean alsoMake;
    protected final boolean alsoMakeDependents;
    protected final boolean debug;
    protected final boolean nonRecursive;
    protected final boolean failAtEnd;
    protected final List<String> goals;
    protected final Set<String> profiles;
    protected final Set<String> projects;
    protected final Set<String> mavenOpts;
    protected final Map<String, String> sysProps;
    protected final Set<String> params;

    private MavenCli(Builder builder) {
        this.pom = builder.pom;
        this.checkMandatoryProperty("pom", this.pom);
        this.goals = builder.goals;
        this.checkMandatoryProperty("goals", this.goals);
        this.javaHome = builder.javaHome;
        this.mavenHome = builder.mavenHome;
        this.xms = builder.xms;
        this.xmx = builder.xmx;
        this.maxPermSize = builder.maxPermSize;
        this.mavenOpts = builder.mavenOpts;
        this.sysProps = builder.sysProps;
        this.profiles = builder.profiles;
        this.projects = builder.projects;
        this.params = builder.params;
        this.alsoMake = builder.alsoMake;
        this.debug = builder.debug;
        this.alsoMakeDependents = builder.alsoMakeDependents;
        this.nonRecursive = builder.nonRecursive;
        this.failAtEnd = builder.failAtEnd;
    }

    protected void checkMandatoryProperty(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Property '%s' is mandatory", name));
        }
    }

    public String getXms() {
        return this.xms;
    }

    public String getXmx() {
        return this.xmx;
    }

    public String getMaxPermSize() {
        return this.maxPermSize;
    }

    public Set<String> getParams() {
        return this.params;
    }

    public File getMavenHome() {
        return this.mavenHome;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public File getPom() {
        return this.pom;
    }

    public boolean isAlsoMake() {
        return this.alsoMake;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public boolean isAlsoMakeDependents() {
        return this.alsoMakeDependents;
    }

    public boolean isFailAtEnd() {
        return this.failAtEnd;
    }

    public Set<String> getMavenOpts() {
        return this.mavenOpts;
    }

    public Map<String, String> getSysProps() {
        return this.sysProps;
    }

    public List<String> getGoals() {
        return this.goals;
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public Set<String> getProjects() {
        return this.projects;
    }

    private List<String> generateCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        if (SystemUtils.IS_OS_WINDOWS) {
            cmd.add("cmd");
            cmd.add("/c");
            cmd.add(this.mavenHome != null ? this.mavenHome + File.separator + "bin" + File.separator + "mvn.bat" : "mvn.bat");
        } else {
            cmd.add("/bin/bash");
            cmd.add(this.mavenHome != null ? this.mavenHome + File.separator + "bin" + File.separator + "mvn" : "mvn");
        }
        if (this.xms != null) {
            this.mavenOpts.add("-Xms" + this.xms);
        }
        if (this.xmx != null) {
            this.mavenOpts.add("-Xmx" + this.xmx);
        }
        if (this.maxPermSize != null) {
            this.mavenOpts.add("-XX:MaxPermSize=" + this.maxPermSize);
        }
        cmd.add("-f");
        cmd.add(this.pom.getAbsolutePath());
        cmd.addAll(this.goals);
        if (!this.profiles.isEmpty()) {
            cmd.add("-P" + StringUtils.join(this.profiles, (String)","));
        }
        if (!this.projects.isEmpty()) {
            cmd.add("-pl");
            cmd.add(StringUtils.join(this.projects, (String)","));
        }
        if (this.alsoMake) {
            cmd.add("-am");
        }
        if (this.alsoMakeDependents) {
            cmd.add("-amd");
        }
        if (this.debug) {
            cmd.add("-X");
        }
        if (this.nonRecursive) {
            cmd.add("-N");
        }
        if (this.failAtEnd) {
            cmd.add("-fae");
        }
        for (Map.Entry<String, String> entry : this.sysProps.entrySet()) {
            cmd.add(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
        }
        if (this.params != null) {
            cmd.addAll(this.params);
        }
        log.info("Process arguments: " + ((Object)cmd).toString());
        return cmd;
    }

    public int run() throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(this.generateCommand());
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        processBuilder.environment().putAll(System.getenv());
        if (this.javaHome != null) {
            processBuilder.environment().put("JAVA_HOME", this.javaHome.getAbsolutePath());
        }
        if (this.mavenHome != null) {
            processBuilder.environment().put("M2_HOME", this.mavenHome.getAbsolutePath());
        }
        processBuilder.environment().put("MAVEN_OPTS", StringUtils.join(this.mavenOpts, (String)" "));
        log.info("JAVA_HOME={}", (Object)processBuilder.environment().get("JAVA_HOME"));
        log.info("M2_HOME={}", (Object)processBuilder.environment().get("M2_HOME"));
        log.info("MAVEN_OPTS={}", (Object)processBuilder.environment().get("MAVEN_OPTS"));
        Process process = processBuilder.start();
        return process.waitFor();
    }

    public static class Builder {
        private File mavenHome;
        private File javaHome;
        private String xms = "64m";
        private String xmx = "256m";
        private String maxPermSize = "512m";
        private File pom;
        private boolean alsoMake = false;
        private boolean alsoMakeDependents = false;
        private boolean debug = false;
        private boolean nonRecursive = false;
        private boolean failAtEnd = false;
        private List<String> goals = new ArrayList<String>();
        private Set<String> profiles = new HashSet<String>();
        private Set<String> projects = new HashSet<String>();
        private Set<String> mavenOpts = new HashSet<String>();
        private Map<String, String> sysProps = new HashMap<String, String>();
        private Set<String> params = new HashSet<String>();

        public Builder mavenHome(File mavenHome) {
            this.mavenHome = mavenHome;
            return this;
        }

        public Builder javaHome(File javaHome) {
            this.javaHome = javaHome;
            return this;
        }

        public Builder xms(String xms) {
            this.xms = xms;
            return this;
        }

        public Builder xmx(String xmx) {
            this.xmx = xmx;
            return this;
        }

        public Builder maxPermSize(String maxPermSize) {
            this.maxPermSize = maxPermSize;
            return this;
        }

        public Builder alsoMake(boolean alsoMake) {
            this.alsoMake = alsoMake;
            return this;
        }

        public Builder alsoMakeDependents(boolean alsoMakeDependents) {
            this.alsoMakeDependents = alsoMakeDependents;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder nonRecursive(boolean nonRecursive) {
            this.nonRecursive = nonRecursive;
            return this;
        }

        public Builder failAtEnd(boolean failAtEnd) {
            this.failAtEnd = failAtEnd;
            return this;
        }

        public Builder pom(File pom) {
            this.pom = pom;
            return this;
        }

        public Builder pom(String pom) {
            this.pom = new File(pom);
            return this;
        }

        public Builder goals(String ... goals) {
            this.goals.addAll(Arrays.asList(goals));
            return this;
        }

        public Builder goals(Collection<String> goals) {
            this.goals.addAll(goals);
            return this;
        }

        public Builder profiles(String ... profiles) {
            this.profiles.addAll(Arrays.asList(profiles));
            return this;
        }

        public Builder profiles(Collection<String> profiles) {
            this.profiles.addAll(profiles);
            return this;
        }

        public Builder projects(String ... projects) {
            this.projects.addAll(Arrays.asList(projects));
            return this;
        }

        public Builder projects(Collection<String> projects) {
            this.projects.addAll(projects);
            return this;
        }

        public Builder mavenOpts(String ... mavenOpts) {
            this.mavenOpts.addAll(Arrays.asList(mavenOpts));
            return this;
        }

        public Builder mavenOpts(Collection<String> mavenOpts) {
            this.mavenOpts.addAll(mavenOpts);
            return this;
        }

        public Builder sysProp(String key, String value) {
            this.sysProps.put(key, value);
            return this;
        }

        public Builder params(String ... params) {
            this.params.addAll(Arrays.asList(params));
            return this;
        }

        public Builder params(Collection<String> params) {
            this.params.addAll(params);
            return this;
        }

        public MavenCli build() {
            if (this.mavenHome != null && !this.mavenHome.exists()) {
                throw new IllegalArgumentException(String.format("Maven home does not exist: %s", this.mavenHome.getAbsolutePath()));
            }
            if (this.javaHome != null && !this.javaHome.exists()) {
                throw new IllegalArgumentException(String.format("Java home does not exist: %s", this.javaHome.getAbsolutePath()));
            }
            return new MavenCli(this);
        }
    }
}

