/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.utils.unpack;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.jboss.qa.jenkins.test.executor.utils.unpack.UnPacker;

public class GUnZipper
extends UnPacker {
    private static final String TYPE = "tar.gz";

    private static Set<TarArchiveEntry> getEntries(TarArchiveInputStream tarIn) throws IOException {
        TarArchiveEntry entry;
        HashSet<TarArchiveEntry> entries = new HashSet<TarArchiveEntry>();
        while ((entry = tarIn.getNextTarEntry()) != null) {
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void unpack(File archive, File destination) throws IOException {
        try (FileInputStream in = new FileInputStream(archive);
             GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzIn);){
            Set<TarArchiveEntry> entries = GUnZipper.getEntries(tarIn);
            if (this.ignoreRootFolders) {
                this.pathSegmentsToTrim = GUnZipper.countRootFolders(entries);
            }
            for (TarArchiveEntry entry : entries) {
                if (entry.isDirectory()) continue;
                File file = new File(destination, GUnZipper.trimPathSegments(entry.getName(), this.pathSegmentsToTrim));
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)tarIn, (OutputStream)fos);
                    if ((entry.getMode() & 0x40) == 0) continue;
                    file.setExecutable(true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
        }
    }
}

