/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.property;

import org.jboss.qa.jenkins.test.executor.property.PropertyReplacer;
import org.jboss.qa.jenkins.test.executor.property.PropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValuesPropertyReplacer
implements PropertyReplacer {
    private static final Logger log = LoggerFactory.getLogger(DefaultValuesPropertyReplacer.class);
    private final char boundaryCharacter;
    private final PropertyResolver resolver;
    private State state;
    private StringBuilder property;
    private StringBuilder defaultValue;

    public DefaultValuesPropertyReplacer(PropertyResolver resolver) {
        this('$', resolver);
    }

    public DefaultValuesPropertyReplacer(char boundaryCharacter, PropertyResolver resolver) {
        this.boundaryCharacter = boundaryCharacter;
        this.resolver = resolver;
    }

    private boolean isBoundary(int ch) {
        return this.boundaryCharacter == ch;
    }

    private boolean isOpenBrace(int ch) {
        return 123 == ch;
    }

    private boolean isCloseBrace(int ch) {
        return 125 == ch;
    }

    private boolean isDefaultValueDelimiter(int ch) {
        return 58 == ch;
    }

    @Override
    public String replace(String expression) {
        this.state = State.INITIAL;
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < expression.length()) {
            int ch = expression.codePointAt(i);
            switch (this.state) {
                case INITIAL: {
                    if (this.isBoundary(ch)) {
                        this.state = State.BOUNDARY;
                        break;
                    }
                    result.appendCodePoint(ch);
                    break;
                }
                case BOUNDARY: {
                    this.property = null;
                    if (this.isBoundary(ch)) {
                        result.appendCodePoint(ch);
                        this.state = State.INITIAL;
                        break;
                    }
                    if (this.isOpenBrace(ch)) {
                        this.property = new StringBuilder();
                        this.state = State.OPEN_BRACE;
                        break;
                    }
                    log.warn("Use of boundary character for property is invalid, will be ignored!");
                    result.appendCodePoint(ch);
                    this.state = State.INITIAL;
                    break;
                }
                case OPEN_BRACE: {
                    String value;
                    this.defaultValue = null;
                    if (this.isDefaultValueDelimiter(ch)) {
                        this.defaultValue = new StringBuilder();
                        this.state = State.DEFAULT;
                        break;
                    }
                    if (this.isCloseBrace(ch)) {
                        value = this.resolver.resolve(this.property.toString());
                        if (value != null) {
                            result.append(value);
                        }
                        this.state = State.INITIAL;
                        break;
                    }
                    this.property.appendCodePoint(ch);
                    break;
                }
                case DEFAULT: {
                    String value;
                    if (this.isCloseBrace(ch)) {
                        value = this.resolver.resolve(this.property.toString());
                        result.append(value != null ? value : this.defaultValue);
                        this.state = State.INITIAL;
                        break;
                    }
                    this.defaultValue.appendCodePoint(ch);
                }
            }
            i = expression.offsetByCodePoints(i, 1);
        }
        if (this.state != State.INITIAL && this.state != State.BOUNDARY) {
            throw new IllegalStateException("Incomplete expression, close brace is missing: " + result);
        }
        return result.toString();
    }

    private static enum State {
        INITIAL,
        BOUNDARY,
        OPEN_BRACE,
        DEFAULT;

    }
}

