/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.utils;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JenkinsUtils {
    private static final Logger log = LoggerFactory.getLogger(JenkinsUtils.class);

    private JenkinsUtils() {
    }

    public static String getUniversalProperty(String name, String defaultValue) {
        String result = defaultValue;
        String re = "[a-z0-9]+(\\.[a-z0-9]+)*";
        if (!Pattern.compile("[a-z0-9]+(\\.[a-z0-9]+)*").matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("Property '%s' should match pattern '%s'", name, "[a-z0-9]+(\\.[a-z0-9]+)*"));
        }
        ArrayList<String> forms = new ArrayList<String>();
        forms.add(name);
        String underscoreForm = name.replaceAll("\\.", "_");
        forms.add(underscoreForm);
        forms.add(underscoreForm.toUpperCase());
        StringBuilder sb = new StringBuilder();
        for (String part : name.split("\\.")) {
            if (sb.length() == 0) {
                sb.append(part);
                continue;
            }
            sb.append(part.substring(0, 1).toUpperCase() + part.substring(1));
        }
        forms.add(sb.toString());
        for (String form : forms) {
            if (System.getProperty(form) != null) {
                result = System.getProperty(form);
            } else if (System.getenv(form) != null) {
                result = System.getenv(form);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static String getUniversalProperty(String name) {
        return JenkinsUtils.getUniversalProperty(name, null);
    }
}

