/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.utils.unpack;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.lang3.StringUtils;

public abstract class UnPacker {
    protected boolean ignoreRootFolders;
    protected int pathSegmentsToTrim;

    protected static int countRootFolders(Set<? extends ArchiveEntry> entries) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ArchiveEntry archiveEntry : entries) {
            fileNames.add(archiveEntry.getName());
        }
        return UnPacker.countRootFolders(fileNames);
    }

    protected static int countRootFolders(List<String> fileNames) {
        String prefix = StringUtils.getCommonPrefix((String[])fileNames.toArray(new String[fileNames.size()]));
        if (!prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.lastIndexOf("/") + 1);
        }
        if (fileNames.remove(prefix)) {
            return UnPacker.countRootFolders(fileNames);
        }
        return StringUtils.countMatches((CharSequence)prefix, (CharSequence)"/");
    }

    protected static String trimPathSegments(String zipPath, int pathSegmentsToTrim) {
        int index;
        int position = 0;
        for (int i = 0; i < pathSegmentsToTrim && (index = zipPath.indexOf("/", position)) != -1; ++i) {
            position = index + 1;
        }
        return zipPath.substring(position);
    }

    public void setIgnoreRootFolders(boolean ignoreRootFolders) {
        this.ignoreRootFolders = ignoreRootFolders;
    }

    public void setPathSegmentsToTrim(int pathSegmentsToTrim) {
        this.pathSegmentsToTrim = pathSegmentsToTrim;
    }

    public abstract String type();

    public abstract void unpack(File var1, File var2) throws IOException;

    public abstract boolean handles(File var1);
}

