/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.utils.unpack;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.jboss.qa.jenkins.test.executor.utils.unpack.UnPacker;

public class GUnZipper
extends UnPacker {
    private static final String TYPE = "tar.gz";

    private static Set<TarArchiveEntry> getEntries(TarArchiveInputStream tarIn) throws IOException {
        TarArchiveEntry entry;
        HashSet<TarArchiveEntry> entries = new HashSet<TarArchiveEntry>();
        while ((entry = tarIn.getNextTarEntry()) != null) {
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public boolean handles(File archive) {
        return archive.getName().endsWith(TYPE);
    }

    @Override
    public void unpack(File archive, File destination) throws IOException {
        Throwable throwable;
        TarArchiveInputStream tarIn2;
        Throwable throwable2;
        GzipCompressorInputStream gzIn2;
        Throwable throwable3;
        BufferedInputStream in;
        try (FileInputStream fin = new FileInputStream(archive);){
            in = new BufferedInputStream(fin);
            throwable3 = null;
            try {
                gzIn2 = new GzipCompressorInputStream((InputStream)in);
                throwable2 = null;
                try {
                    tarIn2 = new TarArchiveInputStream((InputStream)gzIn2);
                    throwable = null;
                    try {
                        Set<TarArchiveEntry> entries = GUnZipper.getEntries(tarIn2);
                        if (this.ignoreRootFolders) {
                            this.pathSegmentsToTrim = GUnZipper.countRootFolders(entries);
                        }
                    }
                    catch (Throwable entries) {
                        throwable = entries;
                        throw entries;
                    }
                    finally {
                        if (tarIn2 != null) {
                            if (throwable != null) {
                                try {
                                    tarIn2.close();
                                }
                                catch (Throwable entries) {
                                    throwable.addSuppressed(entries);
                                }
                            } else {
                                tarIn2.close();
                            }
                        }
                    }
                }
                catch (Throwable tarIn2) {
                    throwable2 = tarIn2;
                    throw tarIn2;
                }
                finally {
                    if (gzIn2 != null) {
                        if (throwable2 != null) {
                            try {
                                gzIn2.close();
                            }
                            catch (Throwable tarIn2) {
                                throwable2.addSuppressed(tarIn2);
                            }
                        } else {
                            gzIn2.close();
                        }
                    }
                }
            }
            catch (Throwable gzIn2) {
                throwable3 = gzIn2;
                throw gzIn2;
            }
            finally {
                if (in != null) {
                    if (throwable3 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable gzIn2) {
                            throwable3.addSuppressed(gzIn2);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        fin = new FileInputStream(archive);
        var4_4 = null;
        try {
            in = new BufferedInputStream(fin);
            throwable3 = null;
            try {
                gzIn2 = new GzipCompressorInputStream((InputStream)in);
                throwable2 = null;
                try {
                    tarIn2 = new TarArchiveInputStream((InputStream)gzIn2);
                    throwable = null;
                    try {
                        TarArchiveEntry entry = null;
                        while ((entry = (TarArchiveEntry)tarIn2.getNextEntry()) != null) {
                            if (entry.isDirectory()) continue;
                            File file = new File(destination, GUnZipper.trimPathSegments(entry.getName(), this.pathSegmentsToTrim));
                            if (!file.getParentFile().exists()) {
                                file.getParentFile().mkdirs();
                            }
                            int buffer = 2048;
                            FileOutputStream fos = new FileOutputStream(file);
                            Throwable throwable4 = null;
                            try {
                                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                                Throwable throwable5 = null;
                                try {
                                    IOUtils.copy((InputStream)tarIn2, (OutputStream)fos);
                                    if ((entry.getMode() & 0x40) == 0) continue;
                                    file.setExecutable(true);
                                }
                                catch (Throwable throwable6) {
                                    throwable5 = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    if (dest == null) continue;
                                    if (throwable5 != null) {
                                        try {
                                            dest.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable5.addSuppressed(throwable7);
                                        }
                                        continue;
                                    }
                                    dest.close();
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable4 = throwable8;
                                throw throwable8;
                            }
                            finally {
                                if (fos == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable9) {
                                        throwable4.addSuppressed(throwable9);
                                    }
                                    continue;
                                }
                                fos.close();
                            }
                        }
                    }
                    catch (Throwable throwable10) {
                        throwable = throwable10;
                        throw throwable10;
                    }
                    finally {
                        if (tarIn2 != null) {
                            if (throwable != null) {
                                try {
                                    tarIn2.close();
                                }
                                catch (Throwable throwable11) {
                                    throwable.addSuppressed(throwable11);
                                }
                            } else {
                                tarIn2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable12) {
                    throwable2 = throwable12;
                    throw throwable12;
                }
                finally {
                    if (gzIn2 != null) {
                        if (throwable2 != null) {
                            try {
                                gzIn2.close();
                            }
                            catch (Throwable throwable13) {
                                throwable2.addSuppressed(throwable13);
                            }
                        } else {
                            gzIn2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable14) {
                throwable3 = throwable14;
                throw throwable14;
            }
            finally {
                if (in != null) {
                    if (throwable3 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable15) {
                            throwable3.addSuppressed(throwable15);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (Throwable throwable16) {
            var4_4 = throwable16;
            throw throwable16;
        }
        finally {
            if (fin != null) {
                if (var4_4 != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable17) {
                        var4_4.addSuppressed(throwable17);
                    }
                } else {
                    fin.close();
                }
            }
        }
    }
}

