/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor;

import java.util.ArrayList;
import java.util.List;
import org.jboss.qa.jenkins.test.executor.beans.Workspace;
import org.jboss.qa.jenkins.test.executor.phase.cleanup.CleanUpPhase;
import org.jboss.qa.jenkins.test.executor.phase.download.DownloadPhase;
import org.jboss.qa.jenkins.test.executor.phase.execution.ExecutionPhase;
import org.jboss.qa.jenkins.test.executor.phase.runtimesetup.RuntimeSetupPhase;
import org.jboss.qa.jenkins.test.executor.phase.runtimeteardown.RuntimeTeardownPhase;
import org.jboss.qa.jenkins.test.executor.phase.start.StartPhase;
import org.jboss.qa.jenkins.test.executor.phase.staticconfiguration.StaticConfigurationPhase;
import org.jboss.qa.jenkins.test.executor.phase.stop.StopPhase;
import org.jboss.qa.jenkins.test.executor.utils.JenkinsUtils;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.PhaseTreeBuilder;
import org.jboss.qa.phaser.Phaser;
import org.jboss.qa.phaser.registry.InstanceRegistry;
import org.jboss.qa.phaser.registry.SimpleInstanceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsTestExecutor {
    private static final Logger log = LoggerFactory.getLogger(JenkinsTestExecutor.class);
    private List<Object> jobInstances;

    public JenkinsTestExecutor(List<Object> jobInstances) {
        this.jobInstances = jobInstances;
    }

    public JenkinsTestExecutor(Object ... jobInstances) {
        this.jobInstances = new ArrayList<Object>();
        for (Object o : jobInstances) {
            this.jobInstances.add(o);
        }
    }

    public JenkinsTestExecutor(Class ... jobClasses) throws Exception {
        this.jobInstances = new ArrayList<Object>();
        for (Class o : jobClasses) {
            this.jobInstances.add(o.newInstance());
        }
    }

    public void run() throws Exception {
        SimpleInstanceRegistry registry = new SimpleInstanceRegistry();
        this.run((InstanceRegistry)registry);
    }

    public void run(InstanceRegistry registry) throws Exception {
        registry.insert((Object)new Workspace(JenkinsUtils.getWorkspace()));
        PhaseTreeBuilder builder = new PhaseTreeBuilder();
        builder.addPhase((Phase)new DownloadPhase()).addPhase((Phase)new StaticConfigurationPhase()).addPhase((Phase)new StartPhase()).addPhase((Phase)new RuntimeSetupPhase()).addPhase((Phase)new ExecutionPhase()).addPhase((Phase)new RuntimeTeardownPhase()).addPhase((Phase)new StopPhase()).addPhase((Phase)new CleanUpPhase());
        new Phaser(builder.build(), this.jobInstances).run(registry);
    }
}

