/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.phase.download;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import lombok.NonNull;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.qa.jenkins.test.executor.beans.Destination;
import org.jboss.qa.jenkins.test.executor.phase.download.Download;
import org.jboss.qa.jenkins.test.executor.property.ContextPropertyResolver;
import org.jboss.qa.jenkins.test.executor.property.DefaultValuesPropertyReplacer;
import org.jboss.qa.jenkins.test.executor.property.JenkinsPropertyResolver;
import org.jboss.qa.jenkins.test.executor.property.PropertyReplacer;
import org.jboss.qa.jenkins.test.executor.utils.AntEr;
import org.jboss.qa.jenkins.test.executor.utils.JenkinsUtils;
import org.jboss.qa.jenkins.test.executor.utils.unpack.UnPacker;
import org.jboss.qa.jenkins.test.executor.utils.unpack.UnPackerRegistry;
import org.jboss.qa.phaser.Inject;
import org.jboss.qa.phaser.PhaseDefinitionProcessor;
import org.jboss.qa.phaser.registry.InstanceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadPhaseProcessor
extends PhaseDefinitionProcessor {
    private static final Logger log = LoggerFactory.getLogger(DownloadPhaseProcessor.class);
    @Inject
    private InstanceRegistry registry;
    @NonNull
    private Download download;
    private PropertyReplacer propertyReplacer;
    private String url;
    private String downloadDestination;
    private String unpackDestination;

    private void setup() {
        if (this.propertyReplacer == null) {
            this.propertyReplacer = DefaultValuesPropertyReplacer.builder().resolver(new ContextPropertyResolver(this.registry)).resolver(new JenkinsPropertyResolver()).build();
        }
        this.resolveValues();
    }

    private void registerDestination(String id, File destination) {
        if (!id.isEmpty()) {
            this.registry.insert(id, (Object)new Destination(destination));
        }
    }

    private void resolveValues() {
        this.url = this.propertyReplacer.replace(this.download.url());
        if (SystemUtils.IS_OS_WINDOWS && this.url.startsWith("file://")) {
            this.url = this.url.replace("\\", "/");
            if (this.url.indexOf(":/", 7) > 7 && !this.url.startsWith("file:///")) {
                this.url = "file:///" + this.url.substring(7);
            }
        }
        this.downloadDestination = this.propertyReplacer.replace(this.download.destination().destination());
        this.unpackDestination = this.propertyReplacer.replace(this.download.unpack().destination().destination());
    }

    public void execute() {
        log.debug("@{} - {}", (Object)Download.class.getName(), (Object)this.download.id());
        this.setup();
        File downloaded = this.download();
        this.registerDestination(this.download.destination().id(), downloaded);
        if (this.download.unpack().unpack()) {
            File unpacked = this.unpack(downloaded);
            this.registerDestination(this.download.unpack().destination().id(), unpacked);
        }
    }

    private File download() {
        File destination = new File(JenkinsUtils.getWorkspace(), this.downloadDestination);
        destination.mkdirs();
        log.info("Download resource \"{}\"", (Object)this.download.id());
        AntEr.build().param("src", this.url).param("dest", destination.getAbsolutePath()).param("verbose", this.download.verbose() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()).invoke("get");
        return destination;
    }

    private File unpack(File downloaded) {
        File unpacked = downloaded;
        if (!this.unpackDestination.isEmpty()) {
            unpacked = new File(JenkinsUtils.getWorkspace(), this.unpackDestination);
        }
        File archive = new File(downloaded, this.url.substring(this.url.lastIndexOf("/")));
        log.info("Unpack resource {}", (Object)this.download.id());
        try {
            UnPacker unPacker = UnPackerRegistry.get(archive);
            if (unPacker == null) {
                throw new RuntimeException("No existing UnPacker for " + this.url);
            }
            unPacker.setPathSegmentsToTrim(this.download.unpack().pathSegmentsToTrim());
            unPacker.setIgnoreRootFolders(this.download.unpack().ignoreRootFolders());
            unPacker.unpack(archive, unpacked);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return unpacked;
    }

    @ConstructorProperties(value={"download"})
    public DownloadPhaseProcessor(@NonNull Download download) {
        if (download == null) {
            throw new NullPointerException("download");
        }
        this.download = download;
    }
}

