/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.qa.jenkins.test.executor.property.PropertyReplacer;
import org.jboss.qa.jenkins.test.executor.property.PropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValuesPropertyReplacer
implements PropertyReplacer {
    private static final Logger log = LoggerFactory.getLogger(DefaultValuesPropertyReplacer.class);
    private final char boundaryCharacter;
    private List<PropertyResolver> resolvers = new LinkedList<PropertyResolver>();

    public static DefaultValuesPropertyReplacerBuilder builder() {
        return new DefaultValuesPropertyReplacerBuilder().boundaryCharacter('$');
    }

    public DefaultValuesPropertyReplacer resolvers(PropertyResolver resolver) {
        this.resolvers.add(resolver);
        return this;
    }

    private boolean isBoundary(int ch) {
        return this.boundaryCharacter == ch;
    }

    private boolean isOpenBrace(int ch) {
        return 123 == ch;
    }

    private boolean isCloseBrace(int ch) {
        return 125 == ch;
    }

    private boolean isDefaultValueDelimiter(int ch) {
        return 58 == ch;
    }

    @Override
    public String replace(String expression) {
        State state = State.INITIAL;
        StringBuilder property = null;
        StringBuilder defaultValue = null;
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < expression.length()) {
            int ch = expression.codePointAt(i);
            switch (state) {
                case INITIAL: {
                    if (this.isBoundary(ch)) {
                        state = State.BOUNDARY;
                        break;
                    }
                    result.appendCodePoint(ch);
                    break;
                }
                case BOUNDARY: {
                    property = null;
                    if (this.isBoundary(ch)) {
                        result.appendCodePoint(ch);
                        state = State.INITIAL;
                        break;
                    }
                    if (this.isOpenBrace(ch)) {
                        property = new StringBuilder();
                        state = State.OPEN_BRACE;
                        break;
                    }
                    log.warn("Use of boundary character for property is invalid, will be ignored!");
                    result.appendCodePoint(ch);
                    state = State.INITIAL;
                    break;
                }
                case OPEN_BRACE: {
                    String value;
                    defaultValue = null;
                    if (this.isDefaultValueDelimiter(ch)) {
                        defaultValue = new StringBuilder();
                        state = State.DEFAULT;
                        break;
                    }
                    if (this.isCloseBrace(ch)) {
                        value = this.resolve(property.toString());
                        if (value != null) {
                            result.append(value);
                        }
                        state = State.INITIAL;
                        break;
                    }
                    property.appendCodePoint(ch);
                    break;
                }
                case DEFAULT: {
                    String value;
                    if (this.isCloseBrace(ch)) {
                        value = this.resolve(property.toString());
                        result.append(value != null ? value : defaultValue);
                        state = State.INITIAL;
                        break;
                    }
                    defaultValue.appendCodePoint(ch);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            i = expression.offsetByCodePoints(i, 1);
        }
        if (state != State.INITIAL && state != State.BOUNDARY) {
            throw new IllegalStateException("Incomplete expression, close brace is missing: " + result);
        }
        return result.toString();
    }

    private String resolve(String name) {
        for (PropertyResolver resolver : this.resolvers) {
            String value = resolver.resolve(name);
            if (value == null) continue;
            return value;
        }
        log.warn("Property '{}' was not resolved", (Object)name);
        return null;
    }

    DefaultValuesPropertyReplacer(char boundaryCharacter, List<PropertyResolver> resolvers) {
        this.boundaryCharacter = boundaryCharacter;
        this.resolvers = resolvers;
    }

    public static class DefaultValuesPropertyReplacerBuilder {
        private char boundaryCharacter;
        private ArrayList<PropertyResolver> resolvers;

        DefaultValuesPropertyReplacerBuilder() {
        }

        public DefaultValuesPropertyReplacerBuilder boundaryCharacter(char boundaryCharacter) {
            this.boundaryCharacter = boundaryCharacter;
            return this;
        }

        public DefaultValuesPropertyReplacerBuilder resolver(PropertyResolver resolver) {
            if (this.resolvers == null) {
                this.resolvers = new ArrayList();
            }
            this.resolvers.add(resolver);
            return this;
        }

        public DefaultValuesPropertyReplacerBuilder resolvers(Collection<? extends PropertyResolver> resolvers) {
            if (this.resolvers == null) {
                this.resolvers = new ArrayList();
            }
            this.resolvers.addAll(resolvers);
            return this;
        }

        public DefaultValuesPropertyReplacer build() {
            List<PropertyResolver> resolvers;
            switch (this.resolvers == null ? 0 : this.resolvers.size()) {
                case 0: {
                    resolvers = Collections.emptyList();
                    break;
                }
                case 1: {
                    resolvers = Collections.singletonList(this.resolvers.get(0));
                    break;
                }
                default: {
                    resolvers = Collections.unmodifiableList(new ArrayList<PropertyResolver>(this.resolvers));
                }
            }
            return new DefaultValuesPropertyReplacer(this.boundaryCharacter, resolvers);
        }

        public String toString() {
            return "DefaultValuesPropertyReplacer.DefaultValuesPropertyReplacerBuilder(boundaryCharacter=" + this.boundaryCharacter + ", resolvers=" + this.resolvers + ")";
        }
    }

    private static enum State {
        INITIAL,
        BOUNDARY,
        OPEN_BRACE,
        DEFAULT;

    }
}

