/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jenkins.test.executor.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncProcessRunner {
    private static final Logger log = LoggerFactory.getLogger(SyncProcessRunner.class);
    private final List<ProcessBuilderListner> processBuilderListners = new ArrayList<ProcessBuilderListner>();

    public int run(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        Process process = processBuilder.start();
        for (ProcessBuilderListner listener : this.processBuilderListners) {
            listener.onCreateOutputStream(process.getOutputStream());
        }
        ProcessOutputConsumer out = new ProcessOutputConsumer(process, System.out);
        out.start();
        ProcessOutputConsumer err = new ProcessOutputConsumer(process, System.err);
        err.start();
        int result = process.waitFor();
        out.join();
        err.join();
        return result;
    }

    public void addProcessBuilderListener(ProcessBuilderListner listener) {
        this.processBuilderListners.add(listener);
    }

    public void removeProcessBuilderListener(ProcessBuilderListner listener) {
        this.processBuilderListners.remove(listener);
    }

    public static interface ProcessBuilderListner {
        public void onCreateOutputStream(OutputStream var1);
    }

    public class ProcessOutputConsumer
    extends Thread {
        private final boolean stderr;
        private final Process process;
        private final PrintStream out;

        public ProcessOutputConsumer(Process process, PrintStream out) {
            this(process, out, out == System.err);
        }

        public ProcessOutputConsumer(Process process, PrintStream out, boolean stderr) {
            this.process = process;
            this.out = out;
            this.stderr = stderr;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(this.stderr ? this.process.getErrorStream() : this.process.getInputStream()));){
                this.doRedirect(r);
            }
            catch (IOException e) {
                log.error("Problem while processing input stream.", (Throwable)e);
            }
        }

        private void doRedirect(BufferedReader reader) throws IOException {
            String line;
            while ((line = reader.readLine()) != null) {
                this.out.println(line);
                if (!Thread.interrupted()) continue;
                return;
            }
        }
    }
}

