/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.jboss.qa.phaser.Create;
import org.jboss.qa.phaser.ExecutionError;
import org.jboss.qa.phaser.PhaseDefinition;
import org.jboss.qa.phaser.PhaseDefinitionProcessor;
import org.jboss.qa.phaser.context.Context;
import org.jboss.qa.phaser.context.PropertyAnnotationProcessor;
import org.jboss.qa.phaser.registry.InstanceRegistry;

public class ExecutionNode {
    @NonNull
    private PhaseDefinition phaseDefinition;
    @NonNull
    private PhaseDefinitionProcessor processor;
    private List<ExecutionNode> childNodes = new ArrayList<ExecutionNode>();

    public void addChildNode(ExecutionNode node) {
        this.childNodes.add(node);
    }

    public void addChildNodes(Collection<ExecutionNode> nodes) {
        this.childNodes.addAll(nodes);
    }

    public ExecutionError execute(boolean finalize, InstanceRegistry register) {
        if (finalize && !this.phaseDefinition.isRunAlways()) {
            return null;
        }
        try {
            this.processor.execute();
            if (this.phaseDefinition.getMethod() != null) {
                Class<?>[] paramClasses = this.phaseDefinition.getMethod().getParameterTypes();
                Annotation[][] paramAnnotations = this.phaseDefinition.getMethod().getParameterAnnotations();
                if (paramClasses.length == 0) {
                    this.phaseDefinition.getMethod().invoke(this.phaseDefinition.getJob(), new Object[0]);
                } else {
                    ArrayList<List<Object>> paramInstances = new ArrayList<List<Object>>();
                    for (int i = 0; i < paramClasses.length; ++i) {
                        boolean created = false;
                        for (int j = 0; j < paramAnnotations[i].length; ++j) {
                            if (!(paramAnnotations[i][j] instanceof Create)) continue;
                            if (paramClasses[i].isAssignableFrom(InstanceRegistry.class)) {
                                throw new IllegalStateException("Can not use @Create annotation for InstanceRegistry");
                            }
                            Create create = (Create)paramAnnotations[i][j];
                            Object o = paramClasses[i].newInstance();
                            if (StringUtils.isNotEmpty((CharSequence)create.id())) {
                                register.insert(create.id(), o);
                            } else {
                                register.insert(o);
                            }
                            ArrayList ip = new ArrayList();
                            ip.add(o);
                            paramInstances.add(ip);
                            created = true;
                        }
                        if (created) continue;
                        if (paramClasses[i].isAssignableFrom(InstanceRegistry.class)) {
                            paramInstances.add(Collections.singletonList(register));
                            continue;
                        }
                        paramInstances.add(register.get(paramClasses[i]));
                    }
                    for (List<Object> paramList : ExecutionNode.createCartesianProduct(paramInstances)) {
                        this.invokeMethod(this.phaseDefinition.getMethod(), paramList.toArray(), register);
                    }
                }
            }
            return null;
        }
        catch (InvocationTargetException e) {
            return this.generateExecutionError(e.getCause());
        }
        catch (Throwable e) {
            return this.generateExecutionError(e);
        }
    }

    private ExecutionError generateExecutionError(Throwable t) {
        if (this.phaseDefinition.getExceptionHandling() != null) {
            return this.processor.handleException(this.phaseDefinition.getExceptionHandling(), t);
        }
        return this.processor.handleException(t);
    }

    private static List<List<Object>> createCartesianProduct(List<List<Object>> lists) {
        ArrayList<List<Object>> resultLists = new ArrayList<List<Object>>();
        if (lists.size() == 0) {
            resultLists.add(new ArrayList());
            return resultLists;
        }
        List<Object> firstList = lists.get(0);
        List<List<Object>> remainingLists = ExecutionNode.createCartesianProduct(lists.subList(1, lists.size()));
        for (Object condition : firstList) {
            for (List<Object> remainingList : remainingLists) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                resultList.add(condition);
                resultList.addAll(remainingList);
                resultLists.add(resultList);
            }
        }
        return resultLists;
    }

    private void invokeMethod(Method method, Object[] params, InstanceRegistry register) throws Exception {
        List<Context> ctxs = register.get(Context.class);
        if (!ctxs.isEmpty()) {
            Context ctx = ctxs.get(0);
            PropertyAnnotationProcessor resolver = new PropertyAnnotationProcessor(ctx);
            method.invoke(this.phaseDefinition.getJob(), resolver.process(method, params));
        } else {
            method.invoke(this.phaseDefinition.getJob(), params);
        }
    }

    @ConstructorProperties(value={"phaseDefinition", "processor"})
    public ExecutionNode(@NonNull PhaseDefinition phaseDefinition, @NonNull PhaseDefinitionProcessor processor) {
        if (phaseDefinition == null) {
            throw new NullPointerException("phaseDefinition");
        }
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        this.phaseDefinition = phaseDefinition;
        this.processor = processor;
    }

    public List<ExecutionNode> getChildNodes() {
        return this.childNodes;
    }
}

