/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.commons.lang3.StringUtils;
import org.jboss.qa.phaser.AfterJob;
import org.jboss.qa.phaser.BeforeJob;
import org.jboss.qa.phaser.ErrorReport;
import org.jboss.qa.phaser.ErrorReporter;
import org.jboss.qa.phaser.ExceptionHandling;
import org.jboss.qa.phaser.ExecutionError;
import org.jboss.qa.phaser.ExecutionNode;
import org.jboss.qa.phaser.Inject;
import org.jboss.qa.phaser.context.Context;
import org.jboss.qa.phaser.context.PropertyAnnotationProcessor;
import org.jboss.qa.phaser.registry.InstanceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger log = LoggerFactory.getLogger(Executor.class);
    private List<Object> jobs;
    private List<ExecutionNode> roots;
    private InstanceRegistry register;

    public Executor(List<Object> jobs, List<ExecutionNode> roots, InstanceRegistry register) throws Exception {
        this.jobs = jobs;
        this.roots = roots;
        this.register = register;
        this.injectProperties();
        this.injectFields();
    }

    public void execute() throws Exception {
        LinkedList<ErrorReport> throwAtEnd = new LinkedList<ErrorReport>();
        this.invokeJobMethods(BeforeJob.class);
        LinkedList<ExecutionNode> nodeQueue = new LinkedList<ExecutionNode>(this.roots);
        boolean finalizeState = false;
        while (!nodeQueue.isEmpty()) {
            ExecutionNode node = (ExecutionNode)nodeQueue.poll();
            ExecutionError err = node.execute(finalizeState, this.register);
            if (err != null) {
                ExceptionHandling eh = err.getExceptionHandling();
                ErrorReport errorReport = new ErrorReport("Exception thrown by phase execution:", err.getThrowable());
                switch (eh.getReport()) {
                    case THROW_AT_END: {
                        throwAtEnd.add(errorReport);
                        break;
                    }
                    case LOG: {
                        ErrorReporter.report(errorReport);
                        break;
                    }
                    default: {
                        log.debug("Exception by phase execution, continue.");
                    }
                }
                if (eh.getExecution() == ExceptionHandling.Execution.IMMEDIATELY_STOP) break;
                if (eh.getExecution() == ExceptionHandling.Execution.FINALIZE) {
                    finalizeState = true;
                }
            }
            nodeQueue.addAll(node.getChildNodes());
        }
        this.invokeJobMethods(AfterJob.class);
        ErrorReporter.finalErrorReport(throwAtEnd);
    }

    private void invokeJobMethods(Class<? extends Annotation> annotationClass) throws Exception {
        for (Object job : this.jobs) {
            for (Method m : job.getClass().getMethods()) {
                Annotation annotation = m.getAnnotation(annotationClass);
                if (annotation == null) continue;
                m.invoke(job, new Object[0]);
            }
        }
    }

    private void injectProperties() throws Exception {
        List<Context> ctxs = this.register.get(Context.class);
        if (ctxs.isEmpty()) {
            log.warn("Property injection is not activated. You can activate it by adding context into instance registry");
            return;
        }
        Context context = ctxs.get(0);
        PropertyAnnotationProcessor resolver = new PropertyAnnotationProcessor(context);
        for (Object job : this.jobs) {
            resolver.process(job);
        }
    }

    private void injectFields() throws Exception {
        for (final Object job : this.jobs) {
            Class<?> current = job.getClass();
            while (current.getSuperclass() != null) {
                for (final Field field : current.getDeclaredFields()) {
                    final Inject inject = field.getAnnotation(Inject.class);
                    if (inject == null) continue;
                    final Class<?> type = field.getType();
                    Enhancer enhancer = new Enhancer();
                    enhancer.setSuperclass(type);
                    enhancer.setCallback((Callback)new InvocationHandler(){

                        public Object invoke(Object o, Method method, Object[] args) throws Throwable {
                            if (type.isAssignableFrom(InstanceRegistry.class)) {
                                return method.invoke((Object)Executor.this.register, args);
                            }
                            if (StringUtils.isNotEmpty((CharSequence)inject.id())) {
                                return method.invoke(Executor.this.register.get(inject.id(), type), args);
                            }
                            List instances = Executor.this.register.get(type);
                            if (instances.size() == 1) {
                                return method.invoke(instances.get(0), args);
                            }
                            if (instances.size() > 1) {
                                log.warn("Can not inject {} in {}: more instances existing", (Object)field.getName(), (Object)job.getClass().getCanonicalName());
                            }
                            return method.invoke(null, args);
                        }
                    });
                    log.debug("Creating proxy for {}", (Object)field.getName());
                    field.setAccessible(true);
                    field.set(job, enhancer.create());
                }
                current = current.getSuperclass();
            }
        }
    }
}

