/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.jboss.qa.phaser.ExecutionNode;
import org.jboss.qa.phaser.PhaseTreeNode;
import org.jboss.qa.phaser.PhaseValidationException;

public class PhaseTree {
    private List<PhaseTreeNode> roots;

    public PhaseTree validate() throws PhaseValidationException {
        for (PhaseTreeNode root : this.roots) {
            root.validate();
        }
        return this;
    }

    public PhaseTree buildPhaseDefinitions(List<Object> jobs) throws Exception {
        for (PhaseTreeNode root : this.roots) {
            root.buildPhaseDefinitions(jobs);
        }
        return this;
    }

    public List<ExecutionNode> buildExecutionTree() {
        ArrayList<ExecutionNode> nds = new ArrayList<ExecutionNode>();
        for (PhaseTreeNode root : this.roots) {
            nds.addAll(root.buildExecutionTree(null));
        }
        return nds;
    }

    @ConstructorProperties(value={"roots"})
    public PhaseTree(List<PhaseTreeNode> roots) {
        this.roots = roots;
    }

    public List<PhaseTreeNode> getRoots() {
        return this.roots;
    }
}

