/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.qa.phaser.context.Context;
import org.jboss.qa.phaser.context.Property;

public class PropertyAnnotationProcessor {
    private Context context;

    public PropertyAnnotationProcessor(Context context) {
        this.context = context;
    }

    public void process(Object job) throws IllegalAccessException {
        Class<?> current = job.getClass();
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                Property inject = field.getAnnotation(Property.class);
                if (inject == null) continue;
                Class<?> type = field.getType();
                field.setAccessible(true);
                Object value = this.context.get(inject.value(), type);
                if (value != null) {
                    field.set(job, value);
                    continue;
                }
                this.context.set(inject.value(), field.get(job), type);
            }
            current = current.getSuperclass();
        }
    }

    public Object[] process(Method method, Object[] params) {
        Class<?>[] paramClasses = method.getParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        if (params == null) {
            params = new Object[paramClasses.length];
        }
        if (params.length != paramClasses.length) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < paramClasses.length; ++i) {
            for (int j = 0; j < paramAnnotations[i].length; ++j) {
                if (!(paramAnnotations[i][j] instanceof Property) || params[i] != null) continue;
                Property property = (Property)paramAnnotations[i][j];
                Object o = this.context.get(property.value(), paramClasses[i]);
                params[i] = o;
            }
        }
        return params;
    }
}

