/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.jboss.qa.phaser.registry.InstanceRegistry;

public class SimpleInstanceRegistry
implements InstanceRegistry {
    private Map<String, Object> namedInstances = new HashMap<String, Object>();
    private Map<Class<?>, List<Object>> typedInstances = new HashMap();

    @Override
    public void insert(Object o) {
        this.insert(o, o.getClass());
        this.insert(o, ClassUtils.getAllInterfaces(o.getClass()));
        this.insert(o, ClassUtils.getAllSuperclasses(o.getClass()));
    }

    private void insert(Object o, List<Class<?>> classes) {
        for (Class<?> c : classes) {
            this.insert(o, c);
        }
    }

    private void insert(Object o, Class<?> c) {
        List<Object> instances = this.typedInstances.get(c);
        if (instances == null) {
            instances = new ArrayList<Object>();
            this.typedInstances.put(c, instances);
        }
        instances.add(o);
    }

    @Override
    public void insert(String id, Object o) {
        this.namedInstances.put(id, o);
        this.insert(o);
    }

    @Override
    public <T> T get(String id, Class<T> clazz) {
        Object o = this.namedInstances.get(id);
        if (o != null && clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return null;
    }

    @Override
    public <T> List<T> get(Class<T> clazz) {
        List<Object> instances = this.typedInstances.get(clazz);
        return instances == null ? Collections.emptyList() : instances;
    }

    public String toString() {
        return "SimpleInstanceRegistry{namedInstances=" + this.namedInstances + ", typedInstances=" + this.typedInstances + '}';
    }
}

