/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser.processors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.qa.phaser.processors.FieldProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiExecutor {
    private static final Logger log = LoggerFactory.getLogger(CdiExecutor.class);
    private FieldProcessor defaultProcessor;
    private List<FieldProcessor> processors;

    public void inject(Object bean) {
        Class<?> current = bean.getClass();
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    Object value = field.get(bean);
                    if (field.getAnnotations().length > 0) {
                        for (FieldProcessor processor : this.processors) {
                            Object annotation = field.getAnnotation(processor.getAnnotationClass());
                            if (annotation == null) continue;
                            value = value != null ? processor.processField(field.getType(), annotation, value) : processor.processField(field.getType(), annotation);
                            field.set(bean, value);
                        }
                        continue;
                    }
                    if (this.defaultProcessor == null) continue;
                    value = value != null ? this.defaultProcessor.processField(field.getType(), null, value) : this.defaultProcessor.processField(field.getType(), null);
                    field.set(bean, value);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can not inject value into field `" + field.getName() + "` in class " + bean.getClass().getCanonicalName(), e);
                }
            }
            current = current.getSuperclass();
        }
    }

    CdiExecutor(FieldProcessor defaultProcessor, List<FieldProcessor> processors) {
        this.defaultProcessor = defaultProcessor;
        this.processors = processors;
    }

    public static CdiExecutorBuilder builder() {
        return new CdiExecutorBuilder();
    }

    public static class CdiExecutorBuilder {
        private FieldProcessor defaultProcessor;
        private ArrayList<FieldProcessor> processors;

        CdiExecutorBuilder() {
        }

        public CdiExecutorBuilder defaultProcessor(FieldProcessor defaultProcessor) {
            this.defaultProcessor = defaultProcessor;
            return this;
        }

        public CdiExecutorBuilder processor(FieldProcessor processor) {
            if (this.processors == null) {
                this.processors = new ArrayList();
            }
            this.processors.add(processor);
            return this;
        }

        public CdiExecutorBuilder processors(Collection<? extends FieldProcessor> processors) {
            if (this.processors == null) {
                this.processors = new ArrayList();
            }
            this.processors.addAll(processors);
            return this;
        }

        public CdiExecutor build() {
            List<FieldProcessor> processors;
            switch (this.processors == null ? 0 : this.processors.size()) {
                case 0: {
                    processors = Collections.emptyList();
                    break;
                }
                case 1: {
                    processors = Collections.singletonList(this.processors.get(0));
                    break;
                }
                default: {
                    processors = Collections.unmodifiableList(new ArrayList<FieldProcessor>(this.processors));
                }
            }
            return new CdiExecutor(this.defaultProcessor, processors);
        }

        public String toString() {
            return "CdiExecutor.CdiExecutorBuilder(defaultProcessor=" + this.defaultProcessor + ", processors=" + this.processors + ")";
        }
    }
}

