/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.jboss.qa.phaser.ExecutionError;
import org.jboss.qa.phaser.PhaseDefinition;
import org.jboss.qa.phaser.PhaseDefinitionProcessor;
import org.jboss.qa.phaser.context.Context;
import org.jboss.qa.phaser.context.PropertyAnnotationProcessor;
import org.jboss.qa.phaser.processors.MethodExecutor;
import org.jboss.qa.phaser.registry.CreateAnnotationProcessor;
import org.jboss.qa.phaser.registry.InjectAnnotationProcessor;
import org.jboss.qa.phaser.registry.InstanceRegistry;

public class ExecutionNode {
    @NonNull
    private PhaseDefinition phaseDefinition;
    @NonNull
    private PhaseDefinitionProcessor processor;
    private List<ExecutionNode> childNodes = new ArrayList<ExecutionNode>();

    public void addChildNode(ExecutionNode node) {
        this.childNodes.add(node);
    }

    public void addChildNodes(Collection<ExecutionNode> nodes) {
        this.childNodes.addAll(nodes);
    }

    public ExecutionError execute(boolean finalize, InstanceRegistry registry) {
        if (finalize && !this.phaseDefinition.isRunAlways()) {
            return null;
        }
        try {
            this.processor.execute();
            Method method = this.phaseDefinition.getMethod();
            if (method != null) {
                Class<?>[] paramClasses = method.getParameterTypes();
                MethodExecutor.MethodExecutorBuilder builder = MethodExecutor.builder().processor(new CreateAnnotationProcessor(registry)).processor(new InjectAnnotationProcessor(registry)).defaultProcessor(new InjectAnnotationProcessor(registry));
                List<Context> ctxs = registry.get(Context.class);
                if (!ctxs.isEmpty()) {
                    builder.processor(new PropertyAnnotationProcessor(ctxs.get(0)));
                }
                builder.build().invokeMethod(method, this.phaseDefinition.getJob());
            }
            return null;
        }
        catch (InvocationTargetException e) {
            return this.generateExecutionError(e.getCause());
        }
        catch (Throwable e) {
            return this.generateExecutionError(e);
        }
    }

    private ExecutionError generateExecutionError(Throwable t) {
        if (this.phaseDefinition.getExceptionHandling() != null) {
            return this.processor.handleException(this.phaseDefinition.getExceptionHandling(), t);
        }
        return this.processor.handleException(t);
    }

    @ConstructorProperties(value={"phaseDefinition", "processor"})
    public ExecutionNode(@NonNull PhaseDefinition phaseDefinition, @NonNull PhaseDefinitionProcessor processor) {
        if (phaseDefinition == null) {
            throw new NullPointerException("phaseDefinition");
        }
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        this.phaseDefinition = phaseDefinition;
        this.processor = processor;
    }

    public List<ExecutionNode> getChildNodes() {
        return this.childNodes;
    }
}

