/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jirabot;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.jirabot.JiraInfo;

public class IssueCache {
    public static final int ISSUE_CACHE_EXPIRATION_HOURS = 2;
    public static final int EXPIRATION_CHECK_MINUTES = 60;
    public static final int REPEAT_DELAY_SECONDS = 120;
    private final Map<String, JiraInfo> cache = Collections.synchronizedMap(new HashMap());
    private static final IssueCache singleton = new IssueCache();
    private ScheduledThreadPoolExecutor expiryThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
    private long timeout = 0x6DDD00L;
    private long expirationCheckFrequency = 3600000L;

    private IssueCache() {
        this.expiryThreadPoolExecutor.scheduleWithFixedDelay(new IssueCacheExpiry(), this.expirationCheckFrequency, this.expirationCheckFrequency, TimeUnit.MILLISECONDS);
    }

    public void stopExporyThread() {
        this.expiryThreadPoolExecutor.shutdown();
    }

    public static IssueCache getSingleton() {
        return singleton;
    }

    public JiraInfo getItem(String key) {
        return this.cache.get(key.toUpperCase());
    }

    public void putItem(String key, JiraInfo jiraInfo) {
        this.cache.put(key, jiraInfo);
    }

    public void removeItem(String key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    private class IssueCacheExpiry
    implements Runnable {
        private IssueCacheExpiry() {
        }

        public void run() {
            HashMap referenceCopy = new HashMap(IssueCache.this.cache);
            long currentTimeMillis = System.currentTimeMillis();
            for (Map.Entry itemEntry : referenceCopy.entrySet()) {
                System.out.println("Checking if " + itemEntry.getValue() + " isStale ");
                if (!((JiraInfo)itemEntry.getValue()).isStale(currentTimeMillis)) continue;
                System.out.println("Removing expired entry " + itemEntry.getValue());
                IssueCache.this.cache.remove(itemEntry.getKey());
            }
        }
    }
}

