/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QualifiedName
implements Comparable<QualifiedName>,
Iterable<String> {
    public static final QualifiedName ROOT_NAME = new QualifiedName(new String[0]);
    private final String[] segments;

    public QualifiedName(String[] nameSegments) throws NullPointerException, IllegalArgumentException {
        String[] segments;
        if (nameSegments == null) {
            throw new NullPointerException("segments is null");
        }
        for (String s : segments = (String[])nameSegments.clone()) {
            if (s == null) {
                throw new NullPointerException("Null segment");
            }
            if (s.length() != 0) continue;
            throw new IllegalArgumentException("Empty segment");
        }
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QualifiedName)) {
            return false;
        }
        QualifiedName name = (QualifiedName)o;
        return Arrays.equals(this.segments, name.segments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    @Override
    public int compareTo(QualifiedName o) {
        if (this == o) {
            return 0;
        }
        String[] a = this.segments;
        String[] b = o.segments;
        int alen = a.length;
        int blen = b.length;
        for (int i = 0; i < alen && i < blen; ++i) {
            int cmp = a[i].compareTo(b[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (alen < blen) {
            return -1;
        }
        if (alen > blen) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.segments.length == 0) {
            return "/";
        }
        for (String segment : this.segments) {
            try {
                builder.append('/');
                builder.append(URLEncoder.encode(segment, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return builder.toString();
    }

    public static QualifiedName parse(String path) {
        int segEnd;
        ArrayList<String> decoded = new ArrayList<String>();
        int len = path.length();
        if (len < 1) {
            throw new IllegalArgumentException("Empty path");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Relative paths are not allowed");
        }
        if (len == 1) {
            return ROOT_NAME;
        }
        int segStart = 0;
        do {
            String segment;
            String string = segment = (segEnd = path.indexOf(47, segStart + 1)) == -1 ? path.substring(segStart + 1) : path.substring(segStart + 1, segEnd);
            if (segment.length() == 0) {
                throw new IllegalArgumentException(segEnd == -1 ? "Invalid trailing slash" : "Empty segment in path");
            }
            try {
                decoded.add(URLDecoder.decode(segment, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            segStart = segEnd;
        } while (segEnd != -1);
        return new QualifiedName(decoded.toArray(new String[decoded.size()]));
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < QualifiedName.this.segments.length;
            }

            @Override
            public String next() {
                try {
                    return QualifiedName.this.segments[this.i++];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException("next() past end");
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove()");
            }
        };
    }

    public int length() {
        return this.segments.length;
    }
}

