/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.remoting.Client;
import org.jboss.remoting.ClientSource;
import org.jboss.remoting.CloseHandler;
import org.jboss.remoting.Endpoint;
import org.jboss.remoting.LocalServiceConfiguration;
import org.jboss.remoting.RemotingException;
import org.jboss.remoting.RequestListener;
import org.jboss.remoting.spi.Handle;
import org.jboss.remoting.spi.RequestHandler;
import org.jboss.remoting.spi.RequestHandlerSource;
import org.jboss.xnio.CloseableExecutor;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Remoting {
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting");
    private static final ThreadFactory OUR_THREAD_FACTORY = new ThreadFactory(){
        private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        public Thread newThread(Runnable r) {
            Thread thread = this.defaultThreadFactory.newThread(r);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    log.error(e, "Uncaught exception in thread %s", (Object)t);
                }
            });
            return thread;
        }
    };

    public static Endpoint createEndpoint(String name) throws IOException {
        return Remoting.createEndpoint(name, 10);
    }

    public static Endpoint createEndpoint(String name, int maxThreads) throws IOException {
        final CloseableExecutor executor = Remoting.createExecutor(maxThreads);
        Endpoint endpoint = Remoting.createEndpoint((Executor)executor, name);
        endpoint.addCloseHandler(new CloseHandler<Endpoint>(){

            @Override
            public void handleClose(Endpoint closed) {
                IoUtils.safeClose((Closeable)executor);
            }
        });
        return endpoint;
    }

    public static CloseableExecutor createExecutor(int maxThreads) {
        return IoUtils.closeableExecutor((ExecutorService)new ThreadPoolExecutor(1, maxThreads, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(50), OUR_THREAD_FACTORY, new ThreadPoolExecutor.CallerRunsPolicy()), (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    public static Endpoint createEndpoint(Executor executor, String name) throws IOException {
        try {
            return (Endpoint)Class.forName("org.jboss.remoting.core.EndpointImpl").getConstructor(Executor.class, String.class).newInstance(executor, name);
        }
        catch (Exception e) {
            throw new EndpointException("Unable to create endpoint", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, O> Client<I, O> createLocalClient(Endpoint endpoint, RequestListener<I, O> requestListener, Class<I> requestClass, Class<O> replyClass) throws IOException {
        Handle<RequestHandler> handle = endpoint.createRequestHandler(requestListener, requestClass, replyClass);
        try {
            Client<I, O> client = endpoint.createClient(handle.getResource(), requestClass, replyClass);
            return client;
        }
        finally {
            IoUtils.safeClose(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, O> ClientSource<I, O> createLocalClientSource(Endpoint endpoint, LocalServiceConfiguration<I, O> config) throws IOException {
        Handle<RequestHandlerSource> handle = endpoint.registerService(config);
        try {
            ClientSource<I, O> clientSource = endpoint.createClientSource(handle.getResource(), config.getRequestClass(), config.getReplyClass());
            return clientSource;
        }
        finally {
            IoUtils.safeClose(handle);
        }
    }

    private Remoting() {
    }

    public static final class EndpointException
    extends RemotingException {
        private static final long serialVersionUID = -9157350594373125152L;

        public EndpointException() {
        }

        public EndpointException(String msg) {
            super(msg);
        }

        public EndpointException(Throwable cause) {
            super(cause);
        }

        public EndpointException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

