/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.spi;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.remoting.CloseHandler;
import org.jboss.remoting.HandleableCloseable;
import org.jboss.remoting.spi.AbstractHandleableCloseable;
import org.jboss.remoting.spi.AutoCloseable;
import org.jboss.remoting.spi.Handle;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.WeakCloseable;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutoCloseable<T>
extends AbstractHandleableCloseable<T>
implements AutoCloseable<T> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting.resource");
    private final AtomicInteger refcount = new AtomicInteger(0);
    private final Executor executor;

    protected AbstractAutoCloseable(Executor executor) {
        super(executor);
        this.executor = executor;
    }

    protected void dec() throws IOException {
        int v = this.refcount.decrementAndGet();
        if (v == 0) {
            log.trace("Lowering reference count of %s to 0 (closing)", (Object)this);
            if (this.refcount.compareAndSet(0, -65536)) {
                this.close();
            }
        } else if (v < 0) {
            this.refcount.incrementAndGet();
        } else {
            log.trace("Lowering reference count of %s to %d", (Object)this, (Object)v);
        }
    }

    protected void inc() throws IOException {
        int v = this.refcount.getAndIncrement();
        log.trace("Raising reference count of %s to %d", (Object)this, (Object)(v + 1));
        if (v < 0) {
            this.refcount.decrementAndGet();
            throw new IOException("Resource is closed");
        }
    }

    @Override
    public Handle<T> getHandle() throws IOException {
        HandleImpl handle = new HandleImpl();
        HandleableCloseable.Key key = this.addCloseHandler(new HandleCloseHandler(handle));
        handle.addCloseHandler(new KeyCloseHandler(key));
        return handle;
    }

    public String toString() {
        return "generic resource <" + Integer.toHexString(this.hashCode()) + ">";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyCloseHandler<T>
    implements CloseHandler<T> {
        private final HandleableCloseable.Key key;

        public KeyCloseHandler(HandleableCloseable.Key key) {
            this.key = key;
        }

        @Override
        public void handleClose(T closed) {
            this.key.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandleCloseHandler<T>
    implements CloseHandler<T> {
        private final Closeable handle;

        public HandleCloseHandler(Handle<T> handle) {
            this.handle = new WeakCloseable(new WeakReference<Handle<T>>(handle));
        }

        @Override
        public void handleClose(T closed) {
            IoUtils.safeClose((Closeable)this.handle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HandleImpl
    extends AbstractHandleableCloseable<Handle<T>>
    implements Handle<T> {
        private HandleImpl() throws IOException {
            super(AbstractAutoCloseable.this.executor);
            AbstractAutoCloseable.this.inc();
        }

        @Override
        protected void closeAction() throws IOException {
            AbstractAutoCloseable.this.dec();
        }

        @Override
        public T getResource() {
            return AbstractAutoCloseable.this;
        }

        public String toString() {
            return "handle <" + Integer.toHexString(this.hashCode()) + "> to " + String.valueOf(AbstractAutoCloseable.this);
        }
    }
}

