/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.spi;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.remoting.CloseHandler;
import org.jboss.remoting.QualifiedName;
import org.jboss.remoting.ServiceRegistrationException;
import org.jboss.remoting.spi.Handle;
import org.jboss.remoting.spi.RequestHandlerSource;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamedServiceRegistry {
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting.named-registry");
    private final ConcurrentMap<QualifiedName, Handle<RequestHandlerSource>> map = new ConcurrentHashMap<QualifiedName, Handle<RequestHandlerSource>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handle<RequestHandlerSource> registerService(final QualifiedName path, final RequestHandlerSource service) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        Handle<RequestHandlerSource> handle = service.getHandle();
        boolean ok = false;
        try {
            Handle<RequestHandlerSource> oldHandle = this.map.putIfAbsent(path, handle);
            if (oldHandle != null) {
                throw new ServiceRegistrationException(String.format("Failed to register a service at path \"%s\" on %s (a service is already registered at that location)", path, this));
            }
            handle.addCloseHandler(new CloseHandler<Handle<RequestHandlerSource>>(){

                @Override
                public void handleClose(Handle<RequestHandlerSource> closed) {
                    if (NamedServiceRegistry.this.map.remove(path, service)) {
                        log.trace("Removed service %s at path \"%s\" on %s (service handle was closed)", (Object)service, (Object)path, (Object)this);
                    }
                }
            });
            log.trace("Registered %s at path \"%s\" on %s", (Object)service, (Object)path, (Object)this);
            ok = true;
            Handle<RequestHandlerSource> handle2 = handle;
            return handle2;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose(handle);
            }
        }
    }

    public Handle<RequestHandlerSource> lookupService(QualifiedName path) {
        return (Handle)this.map.get(path);
    }

    public Set<Map.Entry<QualifiedName, Handle<RequestHandlerSource>>> getEntrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public String toString() {
        return "named service registry <" + Integer.toHexString(this.hashCode()) + ">";
    }
}

