/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.Home;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.marshal.compress.CompressingUnMarshaller;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.http.WebServerError;
import org.jboss.remoting.transport.web.WebUtil;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.util.Base64;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.RunnableTaskWrapper;
import org.jboss.util.threadpool.TaskWrapper;
import org.jboss.util.threadpool.ThreadPool;

public class HTTPClientInvoker
extends RemoteClientInvoker {
    public static final String MAX_NUM_TIMEOUT_THREADS = "maxNumTimeoutThreads";
    public static final String MAX_TIMEOUT_QUEUE_SIZE = "maxTimeoutQueueSize";
    public static final int MAX_NUM_TIMEOUT_THREADS_DEFAULT = 10;
    public static final String NUMBER_OF_CALL_ATTEMPTS = "numberOfCallAttempts";
    protected static final Logger log = Logger.getLogger((Class)HTTPClientInvoker.class);
    protected boolean noThrowOnError;
    protected int numberOfCallAttempts = 1;
    private Object timeoutThreadPoolLock = new Object();
    private ThreadPool timeoutThreadPool;

    public HTTPClientInvoker(InvokerLocator locator) {
        super(locator);
        this.configureParameters();
    }

    public HTTPClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        this.configureParameters();
    }

    protected Object transport(String sessionId, final Object invocation, Map metadata, final Marshaller marshaller, final UnMarshaller unmarshaller) throws IOException, ConnectionFailedException {
        Object result;
        HttpURLConnection conn;
        int simulatedTimeout;
        String validatedUrl = this.validateURL(this.getLocator().getLocatorURI());
        if (metadata == null) {
            metadata = new HashMap();
        }
        if ((simulatedTimeout = this.getSimulatedTimeout(this.configuration, metadata, conn = this.createURLConnection(validatedUrl, metadata))) <= 0) {
            return this.makeInvocation(conn, validatedUrl, invocation, metadata, marshaller, unmarshaller, true);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("using simulated timeout: " + simulatedTimeout));
        }
        class Holder {
            public Object value;

            Holder() {
            }
        }
        final Holder resultHolder = new Holder();
        final HashMap finalMetadata = metadata;
        Runnable r = new Runnable(){
            {
            }

            public void run() {
                block3: {
                    try {
                        resultHolder.value = HTTPClientInvoker.this.useHttpURLConnection(conn, invocation, finalMetadata, marshaller, unmarshaller);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("result: " + resultHolder.value));
                        }
                    }
                    catch (Exception e) {
                        resultHolder.value = e;
                        if (!log.isTraceEnabled()) break block3;
                        log.trace((Object)("exception: " + e));
                    }
                }
            }
        };
        Thread.interrupted();
        ThreadPool pool = this.getTimeoutThreadPool();
        WaitingTaskWrapper wrapper = new WaitingTaskWrapper(r, simulatedTimeout);
        if (log.isTraceEnabled()) {
            log.trace((Object)"starting task in thread pool");
        }
        pool.runTaskWrapper((TaskWrapper)wrapper);
        if (log.isTraceEnabled()) {
            log.trace((Object)"task finished in thread pool");
        }
        if ((result = resultHolder.value) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"invocation timed out");
            }
            SocketTimeoutException cause = new SocketTimeoutException("timed out");
            throw new CannotConnectException("Can not connect http client invoker.", cause);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning result: " + result));
        }
        return result;
    }

    protected Object makeInvocation(HttpURLConnection conn, String url, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller, boolean setTimeout) throws IOException {
        Throwable savedException = null;
        for (int i = 0; i < this.numberOfCallAttempts; ++i) {
            try {
                Object o = this.useHttpURLConnection(conn, invocation, metadata, marshaller, unmarshaller);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("result: " + o));
                }
                return o;
            }
            catch (CannotConnectException e) {
                savedException = e.getCause();
                String suffix = i < this.numberOfCallAttempts - 1 ? ": will retry" : "";
                log.debug((Object)("Cannot connect on attempt " + (i + 1) + suffix));
                conn = this.createURLConnection(url, metadata);
                if (!setTimeout) continue;
                this.getSimulatedTimeout(this.configuration, metadata, conn);
                continue;
            }
        }
        String msg = "Can not connect http client invoker after " + this.numberOfCallAttempts + " attempt(s)";
        throw new CannotConnectException(msg, savedException);
    }

    private Object useHttpURLConnection(HttpURLConnection conn, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws WebServerError {
        Object result = null;
        int responseCode = -1;
        try {
            Map header;
            this.setChunked(this.configuration, conn);
            String basicAuth = this.getBasicAuth(metadata);
            if (basicAuth != null) {
                conn.setRequestProperty("Authorization", basicAuth);
            }
            if ((result = this.checkForLeasePing(conn, invocation, metadata)) != null) {
                return result;
            }
            boolean sendingData = true;
            String type = "POST";
            if (metadata != null) {
                type = (String)metadata.get("TYPE");
                if (type != null) {
                    if (!type.equals("POST") && !type.equals("PUT")) {
                        sendingData = false;
                    }
                } else {
                    type = "POST";
                }
            } else {
                metadata = new HashMap<String, Object>();
                header = new HashMap<String, String>();
                header.put("Content-Type", WebUtil.getContentType(invocation));
                metadata.put("HEADER", header);
            }
            if ((header = (Map)metadata.get("HEADER")) != null) {
                Set keys = header.keySet();
                Iterator itr = keys.iterator();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    String value = (String)header.get(key);
                    log.debug((Object)("Setting request header with " + key + " : " + value));
                    conn.setRequestProperty(key, value);
                }
            } else {
                conn.setRequestProperty("Content-Type", WebUtil.getContentType(invocation));
            }
            conn.setRequestProperty("JBoss-Remoting-Version", new Integer(this.getVersion()).toString());
            conn.setRequestProperty("User-Agent", "JBossRemoting - 2.4.0.GA (Pinto)");
            if (sendingData) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod(type);
                OutputStream stream = SecurityUtility.getOutputStream(conn);
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(invocation, stream, this.getVersion());
                } else {
                    marshaller.write(invocation, stream);
                }
                responseCode = SecurityUtility.getResponseCode(conn);
                InputStream is = responseCode < 400 ? conn.getInputStream() : conn.getErrorStream();
                Map<String, List<String>> headers = conn.getHeaderFields();
                if (metadata == null) {
                    metadata = new HashMap();
                }
                if (headers != null) {
                    Iterator<Map.Entry<String, List<String>>> i = headers.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry<String, List<String>> e = i.next();
                        if (e.getKey() == null) continue;
                        metadata.put(e.getKey(), e.getValue());
                    }
                }
                metadata.put("ResponseCodeMessage", conn.getResponseMessage());
                metadata.put("ResponseCode", new Integer(responseCode));
                metadata.put("ResponseHeaders", headers);
                result = this.readResponse(metadata, headers, unmarshaller, is);
            } else {
                conn.setDoOutput(false);
                conn.setDoInput(true);
                conn.setRequestMethod(type);
                SecurityUtility.connect(conn);
                InputStream is = SecurityUtility.getResponseCode(conn) < 400 ? conn.getInputStream() : conn.getErrorStream();
                Map<String, List<String>> headers = conn.getHeaderFields();
                result = this.readResponse(null, headers, unmarshaller, is);
                if (metadata == null) {
                    metadata = new HashMap();
                }
                metadata.putAll(headers);
                metadata.put("ResponseCodeMessage", conn.getResponseMessage());
                responseCode = SecurityUtility.getResponseCode(conn);
                metadata.put("ResponseCode", new Integer(responseCode));
                metadata.put("ResponseHeaders", conn.getHeaderFields());
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error invoking http client invoker.", (Throwable)e);
            throw new CannotConnectException("Can not connect http client invoker.", e);
        }
        if (responseCode >= 400) {
            Object configObj;
            boolean doNotThrow = this.noThrowOnError;
            if (metadata != null && (configObj = metadata.get("NoThrowOnError")) != null && configObj instanceof String) {
                doNotThrow = Boolean.valueOf((String)configObj);
            }
            if (doNotThrow) {
                if (result instanceof String) {
                    WebServerError ex = new WebServerError((String)result);
                    return ex;
                }
                if (result instanceof InvocationResponse) {
                    return ((InvocationResponse)result).getResult();
                }
                return result;
            }
            if (result instanceof InvocationResponse) {
                return result;
            }
            if (result instanceof String) {
                WebServerError ex = new WebServerError((String)result);
                throw ex;
            }
            WebServerError ex = new WebServerError("Error received when calling on web server.  Error returned was " + responseCode);
            throw ex;
        }
        return result;
    }

    private Object checkForLeasePing(HttpURLConnection conn, Object invocation, Map metadata) throws IOException {
        InvocationRequest request;
        Object payload;
        InvocationResponse response = null;
        boolean shouldLease = false;
        long leasePeriod = -1L;
        if (invocation != null && invocation instanceof InvocationRequest && (payload = (request = (InvocationRequest)invocation).getParameter()) != null && payload instanceof String && "$PING$".equalsIgnoreCase((String)payload) && request.getReturnPayload() != null) {
            try {
                conn.setDoOutput(false);
                conn.setDoInput(true);
                conn.setRequestMethod("HEAD");
                conn.setRequestProperty("JBoss-Remoting-Version", new Integer(this.getVersion()).toString());
                conn.setRequestProperty("User-Agent", "JBossRemoting - 2.4.0.GA (Pinto)");
                conn.setRequestProperty("JBoss-Remoting-Lease-Query", "true");
                conn.setRequestProperty("sessionId", request.getSessionId());
                SecurityUtility.connect(conn);
                Map<String, List<String>> headers = conn.getHeaderFields();
                if (headers != null) {
                    List<String> leasingPeriod;
                    List<String> leasingEnabled = headers.get("LEASING_ENABLED");
                    if (leasingEnabled != null && leasingEnabled instanceof List) {
                        shouldLease = new Boolean(leasingEnabled.get(0));
                    }
                    if ((leasingPeriod = headers.get("LEASE_PERIOD")) != null && leasingPeriod instanceof List) {
                        leasePeriod = new Long(leasingPeriod.get(0));
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)"Error checking server for lease information.", (Throwable)e);
            }
            HashMap<String, Long> p = new HashMap<String, Long>();
            p.put("clientLeasePeriod", new Long(leasePeriod));
            InvocationResponse innterResponse = new InvocationResponse(null, new Boolean(shouldLease), false, p);
            response = new InvocationResponse(null, innterResponse, false, null);
        }
        return response;
    }

    private Object readResponse(Map metadata, Map headers, UnMarshaller unmarshaller, InputStream is) throws IOException, ClassNotFoundException {
        Object o;
        Map map;
        String encoding = null;
        Object ceObj = headers.get("Content-Encoding");
        if (ceObj != null && ceObj instanceof List) {
            encoding = (String)((List)ceObj).get(0);
        }
        if (encoding != null && encoding.indexOf("gzip") >= 0) {
            unmarshaller = new CompressingUnMarshaller(MarshalFactory.getUnMarshaller("serializable"));
        }
        Map map2 = map = metadata == null ? headers : metadata;
        if (map.get("preserveLines") == null && (o = this.configuration.get("preserveLines")) != null) {
            map.put("preserveLines", o);
        }
        Object result = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read(is, map, this.getVersion()) : unmarshaller.read(is, map);
        return result;
    }

    private void setChunked(Map metadata, HttpURLConnection conn) {
        String chunkedValue = (String)metadata.get("chunkedLength");
        if (chunkedValue != null && chunkedValue.length() > 0) {
            try {
                int chunkedLength = Integer.parseInt(chunkedValue);
                try {
                    Class<?> cl = conn.getClass();
                    Class[] paramTypes = new Class[]{Integer.TYPE};
                    Method setChunkedLengthMethod = SecurityUtility.getMethod(cl, "setChunkedStreamingMode", paramTypes);
                    setChunkedLengthMethod.invoke((Object)conn, new Integer(chunkedLength));
                }
                catch (NoSuchMethodException e) {
                    log.warn((Object)("Could not set chunked length (" + chunkedLength + ") on http client transport as method not available with JDK 1.4 (only JDK 1.5 or higher)"));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"Error setting http client connection chunked length.");
                    log.debug((Object)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)"Error setting http client connection chunked length.");
                    log.debug((Object)e);
                }
                catch (Exception e) {
                    log.error((Object)"Unexpected error setting http client connection chunked length.");
                    log.debug((Object)e);
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)("Could not set chunked length for http client connection because value (" + chunkedValue + ") is not a number."));
            }
        }
    }

    private int getSimulatedTimeout(Map configuration, Map metadata, HttpURLConnection conn) {
        int timeout = -1;
        String connectionTimeout = (String)configuration.get("timeout");
        String invocationTimeout = (String)metadata.get("timeout");
        if (invocationTimeout != null && invocationTimeout.length() > 0) {
            try {
                timeout = Integer.parseInt(invocationTimeout);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Could not set timeout for current invocation because value (" + invocationTimeout + ") is not a number."));
            }
        }
        if (timeout < 0 && connectionTimeout != null && connectionTimeout.length() > 0) {
            try {
                timeout = Integer.parseInt(connectionTimeout);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Could not set timeout for http client connection because value (" + connectionTimeout + ") is not a number."));
            }
        }
        if (timeout < 0) {
            timeout = 0;
        }
        try {
            Class<?> cl = conn.getClass();
            Class[] paramTypes = new Class[]{Integer.TYPE};
            Method setTimeoutMethod = SecurityUtility.getMethod(cl, "setConnectTimeout", paramTypes);
            setTimeoutMethod.invoke((Object)conn, new Integer(timeout));
            setTimeoutMethod = SecurityUtility.getMethod(cl, "setReadTimeout", paramTypes);
            setTimeoutMethod.invoke((Object)conn, new Integer(timeout));
            return -1;
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)"Using older JDK (prior to 1.5): will simulate timeout");
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Error setting http client connection timeout.");
            log.debug((Object)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Error setting http client connection timeout.");
            log.debug((Object)e);
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error setting http client connection timeout.");
            log.debug((Object)e);
        }
        return timeout;
    }

    protected String validateURL(String url) {
        String validatedUrl = url;
        if (validatedUrl.startsWith("servlet")) {
            validatedUrl = "http" + validatedUrl.substring("servlet".length());
        }
        return validatedUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Home getUsableAddress() {
        InvokerLocator savedLocator = this.locator;
        String protocol = savedLocator.getProtocol();
        String path = savedLocator.getPath();
        Map params = savedLocator.getParameters();
        List homes = this.getConnectHomes();
        Iterator it = homes.iterator();
        while (it.hasNext()) {
            Object var10_10;
            Home home = null;
            try {
                home = (Home)it.next();
                this.locator = new InvokerLocator(protocol, home.host, home.port, path, params);
                this.invoke(new InvocationRequest(null, null, "$ECHO$", null, null, null));
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " able to contact server at: " + home));
                }
                Home home2 = home;
                var10_10 = null;
                this.locator = savedLocator;
                return home2;
            }
            catch (Throwable e) {
                try {
                    log.debug((Object)(this + " unable to contact server at: " + home));
                    var10_10 = null;
                    this.locator = savedLocator;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    this.locator = savedLocator;
                    throw throwable;
                }
            }
        }
        return null;
    }

    protected HttpURLConnection createURLConnection(String url, Map metadata) throws IOException {
        URL externalURL = null;
        HttpURLConnection httpURLConn = null;
        String proxyHost = null;
        String proxyportString = null;
        int proxyPort = 80;
        if (metadata != null) {
            proxyHost = (String)metadata.get("http.proxyHost");
            proxyportString = (String)metadata.get("http.proxyPort");
            if (proxyportString != null && proxyportString.length() > 0) {
                try {
                    proxyPort = Integer.parseInt(proxyportString);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Error converting proxy port specified (" + proxyportString + ") to a number."));
                }
            }
        }
        if (proxyHost != null) {
            externalURL = new URL(url);
            try {
                Class proxyClass = ClassLoaderUtility.loadClass("java.net.Proxy", HTTPClientInvoker.class);
                InetSocketAddress proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
                Class<?>[] decalredClasses = proxyClass.getDeclaredClasses();
                Class<?> proxyTypeClass = null;
                for (int x = 0; x < decalredClasses.length; ++x) {
                    Class<?> declaredClass = decalredClasses[x];
                    String className = declaredClass.getName();
                    if (!className.endsWith("Type")) continue;
                    proxyTypeClass = declaredClass;
                    break;
                }
                Object proxyType = null;
                Field[] fields = proxyTypeClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    String fieldName = field.getName();
                    if (!fieldName.endsWith("HTTP")) continue;
                    proxyType = field.get(proxyTypeClass);
                    break;
                }
                Constructor proxyConstructor = proxyClass.getConstructor(proxyTypeClass, SocketAddress.class);
                Object proxy = proxyConstructor.newInstance(proxyType, proxyAddress);
                Method openConnection = SecurityUtility.getMethod(URL.class, "openConnection", new Class[]{proxyClass});
                httpURLConn = (HttpURLConnection)openConnection.invoke((Object)externalURL, proxy);
            }
            catch (Exception e) {
                log.error((Object)("Can not set proxy for http invocation (proxy host: " + proxyHost + ", proxy port: " + proxyPort + ") " + "as this configuration requires JDK 1.5 or later.  If running JDK 1.4, can use proxy by setting system properties."));
                log.debug((Object)e);
            }
            String proxyAuth = this.getProxyAuth(metadata);
            if (proxyAuth != null) {
                httpURLConn.setRequestProperty("Proxy-Authorization", proxyAuth);
            }
        } else {
            externalURL = new URL(url);
            httpURLConn = (HttpURLConnection)externalURL.openConnection();
        }
        return httpURLConn;
    }

    private String getProxyAuth(Map metadata) {
        String authString = null;
        String username = null;
        String password = null;
        if (metadata != null) {
            username = (String)metadata.get("http.proxy.username");
        }
        if (username == null || username.length() == 0) {
            username = SecurityUtility.getSystemProperty("http.proxy.username");
        }
        if (metadata != null) {
            password = (String)metadata.get("http.proxy.password");
        }
        if (password == null) {
            password = SecurityUtility.getSystemProperty("http.proxy.password");
        }
        if (username != null && password != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(username);
            buffer.append(":");
            buffer.append(password);
            String encoded = Base64.encodeBytes((byte[])buffer.toString().getBytes());
            authString = "Basic " + encoded;
        }
        return authString;
    }

    private String getBasicAuth(Map metadata) {
        String authString = null;
        String username = null;
        String password = null;
        if (metadata != null) {
            username = (String)metadata.get("http.basic.username");
        }
        if (username == null || username.length() == 0) {
            username = SecurityUtility.getSystemProperty("http.basic.username");
        }
        if (metadata != null) {
            password = (String)metadata.get("http.basic.password");
        }
        if (password == null) {
            password = SecurityUtility.getSystemProperty("http.basic.password");
        }
        if (username != null && password != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(username);
            buffer.append(":");
            buffer.append(password);
            String encoded = Base64.encodeBytes((byte[])buffer.toString().getBytes(), (int)8);
            authString = "Basic " + encoded;
        }
        return authString;
    }

    protected void handleConnect() throws ConnectionFailedException {
        if ("multihome".equals(this.locator.getHost())) {
            Home home = this.getUsableAddress();
            if (home == null) {
                throw new ConnectionFailedException(this + " unable to find a usable address for: " + home);
            }
            String protocol = this.locator.getProtocol();
            String path = this.locator.getPath();
            Map params = this.locator.getParameters();
            this.locator = new InvokerLocator(protocol, home.host, home.port, path, params);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " will use InvokerLocator " + this.locator));
            }
        }
    }

    protected void handleDisconnect() {
    }

    protected String getDefaultDataType() {
        return "http";
    }

    public void setTimeoutThreadPool(ThreadPool pool) {
        this.timeoutThreadPool = pool;
    }

    protected void configureParameters() {
        Object val = this.configuration.get("NoThrowOnError");
        if (val != null) {
            try {
                this.noThrowOnError = Boolean.valueOf((String)val);
                log.debug((Object)(this + " setting noThrowOnError to " + this.noThrowOnError));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + "NoThrowOnError" + " value of " + val + " to a boolean value."));
            }
        }
        if ((val = this.configuration.get(NUMBER_OF_CALL_ATTEMPTS)) != null) {
            try {
                this.numberOfCallAttempts = Integer.valueOf((String)val);
                log.debug((Object)(this + " setting numberOfCallRetries to " + this.numberOfCallAttempts));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + NUMBER_OF_CALL_ATTEMPTS + " value of " + val + " to an int value."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getTimeoutThreadPool() {
        Object object = this.timeoutThreadPoolLock;
        synchronized (object) {
            if (this.timeoutThreadPool == null) {
                int maxNumberThreads = 10;
                int maxTimeoutQueueSize = -1;
                BasicThreadPool pool = new BasicThreadPool("HTTP timeout");
                log.debug((Object)("created new thread pool: " + pool));
                Object param = this.configuration.get(MAX_NUM_TIMEOUT_THREADS);
                if (param instanceof String) {
                    try {
                        maxNumberThreads = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("maxNumberThreads parameter has invalid format: " + param));
                    }
                } else if (param != null) {
                    log.error((Object)("maxNumberThreads parameter must be a string in integer format: " + param));
                }
                if ((param = this.configuration.get(MAX_TIMEOUT_QUEUE_SIZE)) instanceof String) {
                    try {
                        maxTimeoutQueueSize = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("maxTimeoutQueueSize parameter has invalid format: " + param));
                    }
                } else if (param != null) {
                    log.error((Object)("maxTimeoutQueueSize parameter must be a string in integer format: " + param));
                }
                pool.setMaximumPoolSize(maxNumberThreads);
                if (maxTimeoutQueueSize > 0) {
                    pool.setMaximumQueueSize(maxTimeoutQueueSize);
                }
                pool.setBlockingMode(BlockingMode.RUN);
                this.timeoutThreadPool = pool;
            }
        }
        return this.timeoutThreadPool;
    }

    static class WaitingTaskWrapper
    extends RunnableTaskWrapper {
        long completeTimeout;

        public WaitingTaskWrapper(Runnable runnable, long completeTimeout) {
            super(runnable, 0L, completeTimeout);
            this.completeTimeout = completeTimeout;
        }

        public int getTaskWaitType() {
            return 2;
        }

        public String toString() {
            return "WaitingTaskWrapper[" + this.completeTimeout + "]";
        }
    }
}

