/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.SerializableStore;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.AsynchInvokerCallbackHandler;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.CallbackErrorHandler;
import org.jboss.remoting.callback.CallbackErrorHandlerWrapper;
import org.jboss.remoting.callback.CallbackListener;
import org.jboss.remoting.callback.CallbackStoreWrapper;
import org.jboss.remoting.callback.DefaultCallbackErrorHandler;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.NullCallbackStore;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.security.SSLServerSocketFactoryServiceMBean;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.security.SSLSocketBuilderMBean;
import org.jboss.remoting.security.SSLSocketFactoryService;
import org.jboss.remoting.util.SecurityUtility;

public class ServerInvokerCallbackHandler
implements AsynchInvokerCallbackHandler,
ConnectionListener {
    private static final Logger log = Logger.getLogger((Class)ServerInvokerCallbackHandler.class);
    private static boolean trace = log.isTraceEnabled();
    private InvocationRequest invocation;
    private Client callBackClient;
    private ArrayList callbacks = new ArrayList();
    private String sessionId;
    private String listenerId;
    private String clientSessionId;
    private InvokerLocator serverLocator;
    private int blockingTimeout = 5000;
    private boolean shouldPersist;
    private SerializableStore callbackStore = null;
    private CallbackErrorHandler callbackErrorHandler = null;
    public static final String CALLBACK_STORE_KEY = "callbackStore";
    public static final String CALLBACK_ERROR_HANDLER_KEY = "callbackErrorHandler";
    public static final String CALLBACK_MEM_CEILING = "callbackMemCeiling";
    public static final String CALLBACK_LISTENER = "callbackListener";
    public static final String REMOTING_ACKNOWLEDGES_PUSH_CALLBACKS = "remotingAcknowledgesPushCallbacks";
    public static final String CALLBACK_ID = "callbackId";
    public static final String CALLBACK_TIMEOUT = "callbackTimeout";
    public static final String SERVER_INVOKER = "serverInvoker";
    public static final String SERVER_INVOKER_CALLBACK_HANDLER = "serverInvokerCallbackHandler";
    private double memPercentCeiling = 20.0;
    private Map idToListenerMap = Collections.synchronizedMap(new HashMap());

    public ServerInvokerCallbackHandler(InvocationRequest invocation, InvokerLocator serverLocator, ServerInvoker owner) throws Exception {
        if (invocation == null) {
            throw new Exception("Can not construct ServerInvokerCallbackHandler with null InvocationRequest.");
        }
        this.invocation = invocation;
        this.serverLocator = serverLocator;
        this.init(invocation, owner);
    }

    public void connect() throws Exception {
        if (this.callBackClient != null) {
            if (this.callBackClient.isConnected()) {
                return;
            }
            this.callBackClient.connect();
        }
    }

    private void init(InvocationRequest invocation, ServerInvoker owner) throws Exception {
        Object val;
        this.clientSessionId = invocation.getSessionId();
        this.sessionId = invocation.getSessionId();
        HashMap metadata = null;
        metadata = owner.getConfiguration() == null ? new HashMap() : new HashMap(owner.getConfiguration());
        if (invocation.getRequestPayload() != null) {
            metadata.putAll(invocation.getRequestPayload());
        }
        this.listenerId = (String)metadata.get("listenerId");
        if (this.listenerId != null) {
            this.sessionId = this.sessionId + "+" + this.listenerId;
        }
        log.debug((Object)("Session id for callback handler is " + this.sessionId));
        if (invocation.getLocator() != null) {
            val = metadata.get(CALLBACK_TIMEOUT);
            if (val instanceof String) {
                try {
                    Integer.parseInt((String)val);
                    metadata.put("timeout", val);
                    log.debug((Object)(this + " using callbackTimeout value " + val));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("callbackTimeout value must have valid numeric format: " + val));
                }
            } else if (val != null) {
                log.warn((Object)("callbackTimeout value must be a String: " + val));
            }
            this.configureSocketFactory(metadata, owner);
            metadata.put(SERVER_INVOKER, owner);
            metadata.put(SERVER_INVOKER_CALLBACK_HANDLER, this);
            this.callBackClient = new Client(invocation.getLocator(), invocation.getSubsystem(), metadata);
            this.callBackClient.setSessionId(this.sessionId);
            this.createCallbackErrorHandler(owner, invocation.getSubsystem());
        } else {
            this.createCallbackStore(owner, this.sessionId);
        }
        val = metadata.get("blockingTimeout");
        if (val != null) {
            if (val instanceof String) {
                try {
                    this.blockingTimeout = Integer.parseInt((String)val);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Error converting blockingTimeout to type long.  " + e.getMessage()));
                }
            } else {
                log.warn((Object)("Value for blockingTimeout configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName()));
            }
        }
    }

    private void configureSocketFactory(Map clientConfig, ServerInvoker serverInvoker) throws Exception {
        if (serverInvoker.getSocketFactory() != null) {
            clientConfig.put("customSocketFactory", serverInvoker.getSocketFactory());
            return;
        }
        if (clientConfig == null) {
            clientConfig = new HashMap<String, SocketFactory>();
        }
        if (clientConfig.containsKey("customSocketFactory")) {
            serverInvoker.setSocketFactory((SocketFactory)clientConfig.get("customSocketFactory"));
            return;
        }
        String serverSocketFactoryString = (String)clientConfig.get("serverSocketFactory");
        if (serverSocketFactoryString != null && serverSocketFactoryString.length() > 0) {
            MBeanServer server = serverInvoker.getMBeanServer();
            try {
                Object o;
                SSLSocketBuilderMBean sslSocketBuilder;
                String className;
                boolean isCorrectType;
                ObjectName serverSocketFactoryObjName = new ObjectName(serverSocketFactoryString);
                if (server != null && (isCorrectType = SecurityUtility.isInstanceOf(server, serverSocketFactoryObjName, className = SSLServerSocketFactoryServiceMBean.class.getName())) && (sslSocketBuilder = (SSLSocketBuilderMBean)(o = SecurityUtility.getMBeanAttribute(server, serverSocketFactoryObjName, "SSLSocketBuilder"))) != null) {
                    SSLSocketBuilder clonedSSLSocketBuilder = (SSLSocketBuilder)sslSocketBuilder.clone();
                    boolean shouldUseDefault = sslSocketBuilder.getUseSSLServerSocketFactory();
                    clonedSSLSocketBuilder.setUseSSLSocketFactory(shouldUseDefault);
                    boolean useClientMode = sslSocketBuilder.isServerSocketUseClientMode();
                    clonedSSLSocketBuilder.setSocketUseClientMode(useClientMode);
                    SSLSocketFactoryService sslSocketFactoryService = new SSLSocketFactoryService();
                    sslSocketFactoryService.setSSLSocketBuilder(clonedSSLSocketBuilder);
                    sslSocketFactoryService.start();
                    clientConfig.put("customSocketFactory", sslSocketFactoryService);
                    clientConfig.put("org.jboss.remoting.socket.useClientMode", (SocketFactory)((Object)"false"));
                    clientConfig.put("hostnameVerifier", (SocketFactory)((Object)"org.jboss.test.remoting.transport.http.ssl.config.SelfIdentifyingHostnameVerifier"));
                    serverInvoker.setSocketFactory(sslSocketFactoryService);
                    return;
                }
            }
            catch (Exception ignored) {
                log.debug((Object)"error", (Throwable)ignored);
            }
        }
        if (serverInvoker.getServerSocketFactory() instanceof SSLServerSocketFactory && !clientConfig.containsKey("org.jboss.remoting.socket.useClientMode")) {
            clientConfig.put("org.jboss.remoting.socket.useClientMode", (SocketFactory)((Object)"false"));
        }
    }

    public String getCallbackSessionId() {
        return this.sessionId;
    }

    public String getClientSessionId() {
        return this.clientSessionId;
    }

    public String getSubsystem() {
        return this.invocation.getSubsystem();
    }

    public void setMemPercentCeiling(Double ceiling) {
        if (ceiling != null) {
            this.memPercentCeiling = ceiling;
        }
    }

    public Double getMemPercentCeiling() {
        return new Double(this.memPercentCeiling);
    }

    private void createCallbackStore(ServerInvoker owner, String sessionId) throws Exception {
        block11: {
            String storeName;
            Map config = owner.getConfiguration();
            if (config != null && (storeName = (String)config.get(CALLBACK_STORE_KEY)) != null) {
                try {
                    MBeanServer server = owner.getMBeanServer();
                    ObjectName storeObjectName = new ObjectName(storeName);
                    if (server != null) {
                        this.callbackStore = (SerializableStore)MBeanServerInvocationHandler.newProxyInstance(server, storeObjectName, SerializableStore.class, false);
                        this.callbackStore = new CallbackStoreWrapper(this.callbackStore);
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)("Could not create callback store from the configration value given (" + storeName + ") as an MBean."));
                    if (trace) {
                        log.trace((Object)("Error is: " + ex.getMessage()), (Throwable)ex);
                    }
                    this.callbackStore = null;
                }
                if (this.callbackStore == null) {
                    try {
                        Class<?> storeClass = Class.forName(storeName);
                        this.callbackStore = (SerializableStore)storeClass.newInstance();
                    }
                    catch (Exception e) {
                        log.debug((Object)("Could not create callback store from the configuration value given (" + storeName + ") as a fully qualified class name."));
                        if (!trace) break block11;
                        log.trace((Object)("Error is: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        if (this.callbackStore == null) {
            this.callbackStore = new NullCallbackStore();
        } else {
            HashMap<String, String> storeConfig = new HashMap<String, String>();
            storeConfig.putAll(owner.getConfiguration());
            String filePath = (String)storeConfig.get("StoreFilePath");
            if (filePath == null) {
                filePath = SecurityUtility.getSystemProperty("jboss.server.data.dir", "data");
            }
            String separator = SecurityUtility.getSystemProperty("file.separator");
            String newFilePath = filePath + separator + "remoting" + separator + sessionId;
            storeConfig.put("StoreFilePath", newFilePath);
            this.callbackStore.setConfig(storeConfig);
        }
        this.callbackStore.create();
        this.callbackStore.start();
        this.configureMemCeiling(owner.getConfiguration());
    }

    private void createCallbackErrorHandler(ServerInvoker owner, String subsystem) throws Exception {
        block9: {
            String errorHandlerName;
            Map config = owner.getConfiguration();
            if (config != null && (errorHandlerName = (String)config.get(CALLBACK_ERROR_HANDLER_KEY)) != null) {
                try {
                    MBeanServer server = owner.getMBeanServer();
                    ObjectName errorHandlerObjectName = new ObjectName(errorHandlerName);
                    if (server != null) {
                        this.callbackErrorHandler = (CallbackErrorHandler)MBeanServerInvocationHandler.newProxyInstance(server, errorHandlerObjectName, CallbackErrorHandler.class, false);
                        this.callbackErrorHandler = new CallbackErrorHandlerWrapper(this.callbackErrorHandler);
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)("Could not create callback error handler from the configration value given (" + errorHandlerName + ") as an MBean."));
                    if (trace) {
                        log.trace((Object)("Error is: " + ex.getMessage()), (Throwable)ex);
                    }
                    this.callbackErrorHandler = null;
                }
                if (this.callbackErrorHandler == null) {
                    try {
                        Class<?> errorHandlerClass = Class.forName(errorHandlerName);
                        this.callbackErrorHandler = (CallbackErrorHandler)errorHandlerClass.newInstance();
                    }
                    catch (Exception e) {
                        log.debug((Object)("Could not create callback error handler from the configuration value given (" + errorHandlerName + ") as a fully qualified class name."));
                        if (!trace) break block9;
                        log.trace((Object)("Error is: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        if (this.callbackErrorHandler == null) {
            this.callbackErrorHandler = new DefaultCallbackErrorHandler();
        }
        HashMap<String, String> errorHandlerConfig = new HashMap<String, String>();
        errorHandlerConfig.putAll(owner.getConfiguration());
        errorHandlerConfig.put("handlerSubsystem", subsystem);
        this.callbackErrorHandler.setConfig(errorHandlerConfig);
        this.callbackErrorHandler.setServerInvoker(owner);
        this.callbackErrorHandler.setCallbackHandler(this);
    }

    private void configureMemCeiling(Map configuration) {
        String ceiling;
        if (configuration != null && (ceiling = (String)configuration.get(CALLBACK_MEM_CEILING)) != null) {
            try {
                double newCeiling = Double.parseDouble(ceiling);
                this.setMemPercentCeiling(new Double(newCeiling));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Found new store memory ceiling seting (" + ceiling + "), but can not convert to type double."), (Throwable)e);
            }
        }
    }

    public Client getCallbackClient() {
        return this.callBackClient;
    }

    public static String getId(InvocationRequest invocation) {
        String listenerId;
        String sessionId = invocation.getSessionId();
        Map metadata = invocation.getRequestPayload();
        if (metadata != null && (listenerId = (String)metadata.get("listenerId")) != null) {
            sessionId = sessionId + "+" + listenerId;
        }
        return sessionId;
    }

    public String getId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCallbacks(Map metadata) {
        log.trace((Object)"entering getCallbacks()");
        boolean blocking = false;
        int currentBlockingTimeout = this.blockingTimeout;
        if (metadata != null) {
            Object val = metadata.get("blockingMode");
            if ("blocking".equals(val)) {
                blocking = true;
            }
            if ((val = metadata.get("blockingTimeout")) != null) {
                if (val instanceof String) {
                    try {
                        currentBlockingTimeout = Integer.parseInt((String)val);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Error converting blockingTimeout to type long.  " + e.getMessage()));
                    }
                } else {
                    log.warn((Object)("Value for blockingTimeout configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName()));
                }
            }
        }
        if (trace) {
            log.trace((Object)("block: " + blocking));
            log.trace((Object)("blocking timeout: " + currentBlockingTimeout));
        }
        ArrayList arrayList = this.callbacks;
        synchronized (arrayList) {
            List callbackList = this.constructCallbackList();
            if (blocking && callbackList.isEmpty()) {
                try {
                    this.callbacks.wait(currentBlockingTimeout);
                    callbackList = this.constructCallbackList();
                }
                catch (InterruptedException e) {
                    log.debug((Object)"unexpected interrupt");
                }
            }
            if (trace) {
                log.trace((Object)("callbackList.size(): " + callbackList.size()));
            }
            return callbackList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List constructCallbackList() {
        List callbackList = null;
        ArrayList arrayList = this.callbacks;
        synchronized (arrayList) {
            callbackList = (List)this.callbacks.clone();
            this.callbacks.clear();
        }
        List persistedCallbacks = null;
        try {
            persistedCallbacks = this.getPersistedCallbacks();
        }
        catch (IOException e) {
            log.debug((Object)"Can not get persisted callbacks.", (Throwable)e);
            throw new RuntimeException("Error getting callbacks", e);
        }
        callbackList.addAll(persistedCallbacks);
        return callbackList;
    }

    private List getPersistedCallbacks() throws IOException {
        ArrayList<Object> callbacks = new ArrayList<Object>();
        int size = this.callbackStore.size();
        for (int x = 0; x < size; ++x) {
            callbacks.add(this.callbackStore.getNext());
            if (!this.isMemLow()) continue;
            new Thread(){

                public void run() {
                    System.gc();
                }
            }.start();
            break;
        }
        return callbacks;
    }

    public boolean isPullCallbackHandler() {
        return this.callBackClient == null;
    }

    public void handleCallback(Callback callback) throws HandleCallbackException {
        this.handleCallback(callback, false, false);
    }

    public void handleCallbackOneway(Callback callback) throws HandleCallbackException {
        this.handleCallback(callback, true, false);
    }

    public void handleCallbackOneway(Callback callback, boolean serverSide) throws HandleCallbackException {
        this.handleCallback(callback, true, serverSide);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCallback(Callback callback, boolean asynch, boolean serverSide) throws HandleCallbackException {
        block26: {
            try {
                Object callbackId = this.checkForCallbackListener(callback);
                if (this.callBackClient == null) {
                    if (this.shouldPersist()) {
                        try {
                            this.persistCallback(callback);
                            ArrayList arrayList = this.callbacks;
                            synchronized (arrayList) {
                                this.callbacks.notify();
                            }
                            callback = null;
                            new Thread(){

                                public void run() {
                                    System.gc();
                                }
                            }.start();
                            break block26;
                        }
                        catch (IOException e) {
                            log.debug((Object)"Unable to persist callback", (Throwable)e);
                            throw new HandleCallbackException("Unable to persist callback and will not be able to deliver.", e);
                        }
                    }
                    ArrayList e = this.callbacks;
                    synchronized (e) {
                        if (trace) {
                            log.debug((Object)(this + " got PULL callback. Adding to callback list ..."));
                        }
                        this.callbacks.add(callback);
                        this.callbacks.notify();
                        break block26;
                    }
                }
                try {
                    if (trace) {
                        log.debug((Object)(this + " got PUSH callback " + callback));
                    }
                    boolean handleAcknowledgement = false;
                    if (callback != null) {
                        HashMap<String, InvokerLocator> returnPayload = callback.getReturnPayload();
                        if (returnPayload == null) {
                            returnPayload = new HashMap<String, InvokerLocator>();
                        } else {
                            Object o = returnPayload.remove(REMOTING_ACKNOWLEDGES_PUSH_CALLBACKS);
                            if (!asynch && (o instanceof String && Boolean.valueOf((String)o).booleanValue() || o instanceof Boolean && ((Boolean)o).booleanValue())) {
                                handleAcknowledgement = true;
                            }
                        }
                        returnPayload.put("server_locator", this.serverLocator);
                        callback.setReturnPayload(returnPayload);
                    }
                    InternalInvocation internalInvocation = new InternalInvocation("handleCallback", new Object[]{callback});
                    if (asynch) {
                        if (trace) {
                            log.debug((Object)(this + " sending ASYNCHRONOUSLY the callback to the client"));
                        }
                        this.callBackClient.invokeOneway(internalInvocation, callback.getRequestPayload(), serverSide);
                    } else {
                        if (trace) {
                            log.debug((Object)(this + " sending SYNCHRONOUSLY the callback to the client"));
                        }
                        this.callBackClient.invoke(internalInvocation, callback.getRequestPayload());
                    }
                    this.handlePushCallbackAcknowledgement(callbackId, handleAcknowledgement);
                }
                catch (Throwable ex) {
                    if (this.callbackErrorHandler == null) {
                        throw ex;
                    }
                    if (trace) {
                        log.trace((Object)(this + " handing the error over to " + this.callbackErrorHandler));
                    }
                    this.callbackErrorHandler.handleError(ex);
                }
            }
            catch (Throwable t) {
                log.debug((Object)"Error handling callback", t);
                throw new HandleCallbackException("Error handling callback", t);
            }
        }
    }

    private void persistCallback(InvocationRequest callback) throws IOException {
        this.callbackStore.add(callback);
    }

    private boolean shouldPersist() {
        if (this.shouldPersist) {
            return true;
        }
        return this.isMemLow();
    }

    private boolean isMemLow() {
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        float percentage = 100L * free / total;
        return max == total && this.memPercentCeiling >= (double)percentage;
    }

    Object checkForCallbackListener(Callback callback) {
        Map returnPayload = callback.getReturnPayload();
        if (returnPayload == null) {
            return null;
        }
        Object listenerObject = returnPayload.remove(CALLBACK_LISTENER);
        if (listenerObject == null) {
            return null;
        }
        Object callbackId = returnPayload.get(CALLBACK_ID);
        if (callbackId == null) {
            log.error((Object)"CALLBACK_ID is null: unable to acknowledge callback");
            return null;
        }
        if (listenerObject instanceof CallbackListener) {
            if (this.listenerId != null) {
                returnPayload.put("listenerId", this.listenerId);
                this.idToListenerMap.put(callbackId, listenerObject);
                return callbackId;
            }
            log.error((Object)"LISTENER_ID_KEY is null: unable to acknowledge callback");
            return null;
        }
        log.error((Object)("callback preprocess listener has wrong type: " + listenerObject));
        return null;
    }

    private void handlePushCallbackAcknowledgement(Object callbackId, boolean handleAck) {
        if (!handleAck) {
            return;
        }
        if (callbackId == null) {
            log.error((Object)"Unable to acknowledge push callback: callback id is null");
            return;
        }
        CallbackListener listener = (CallbackListener)this.idToListenerMap.get(callbackId);
        if (listener == null) {
            log.error((Object)"Unable to acknowledge push callback: listener is null");
            return;
        }
        listener.acknowledgeCallback(this, callbackId, null);
    }

    public void acknowledgeCallbacks(InternalInvocation invocation) throws Exception {
        Object[] params = invocation.getParameters();
        if (params == null) {
            return;
        }
        List callbackIds = (List)params[0];
        List responses = (List)params[1];
        if (callbackIds == null || callbackIds.size() == 0) {
            return;
        }
        Iterator idsIterator = callbackIds.iterator();
        Iterator responseIterator = null;
        if (responses != null) {
            responseIterator = responses.iterator();
        }
        Object callbackId = null;
        Object response = null;
        while (idsIterator.hasNext()) {
            CallbackListener listener;
            callbackId = idsIterator.next();
            if (responseIterator != null) {
                response = responseIterator.next();
            }
            if ((listener = (CallbackListener)this.idToListenerMap.remove(callbackId)) == null) {
                log.warn((Object)("Cannot acknowledge callback: unrecognized id: " + callbackId));
                continue;
            }
            listener.acknowledgeCallback(this, callbackId, response);
        }
    }

    public String toString() {
        return "ServerInvokerCallbackHandler[" + this.getId() + "]";
    }

    public synchronized void destroy() {
        if (this.callBackClient != null) {
            this.callBackClient.disconnect();
            this.callBackClient = null;
        }
        if (this.callbackStore != null) {
            this.callbackStore.purgeFiles();
            this.callbackStore = null;
        }
    }

    public void handleConnectionException(Throwable throwable, Client client) {
        if (this.clientSessionId.equals(client.getSessionId())) {
            this.destroy();
            log.debug((Object)(this + " shut down"));
        }
    }

    public boolean isShouldPersist() {
        return this.shouldPersist;
    }

    public void setShouldPersist(boolean shouldPersist) {
        this.shouldPersist = shouldPersist;
    }
}

