/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.servlet.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.remoting.util.ServletSecurityUtility;

public class ServerInvokerServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger((Class)ServerInvokerServlet.class);
    private ServletServerInvokerMBean servletInvoker;
    private static final long serialVersionUID = 8796224225710165263L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletInvoker = this.getInvokerFromInvokerUrl(config);
        if (this.servletInvoker == null) {
            this.servletInvoker = this.getInvokerFromInvokerName(config);
            if (this.servletInvoker == null) {
                throw new ServletException("Could not find init parameter for 'locatorUrl' or 'locatorName' - one of which must be supplied for ServerInvokerServlet to function.");
            }
        }
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("processRequest, ContentLength: " + request.getContentLength()));
            log.trace((Object)("processRequest, ContentType: " + request.getContentType()));
        }
        int bufferSize = 1024;
        byte[] byteBuffer = new byte[bufferSize];
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        int pointer = 0;
        int contentLength = request.getContentLength();
        ServletInputStream inputStream = request.getInputStream();
        int amtRead = inputStream.read(byteBuffer);
        while (amtRead > 0) {
            byteOutputStream.write(byteBuffer, pointer, amtRead);
            if (amtRead < bufferSize && byteOutputStream.size() >= contentLength) break;
            amtRead = inputStream.read(byteBuffer);
        }
        byteOutputStream.flush();
        byte[] totalByteArray = byteOutputStream.toByteArray();
        byte[] out = ServletSecurityUtility.processRequest(this.servletInvoker, request, totalByteArray, response);
        ServletOutputStream outStream = response.getOutputStream();
        outStream.write(out);
        outStream.flush();
        outStream.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Servlet front to JBossRemoting servlet server invoker.";
    }

    protected ServletServerInvokerMBean getInvokerFromInvokerUrl(ServletConfig config) throws ServletException {
        String locatorUrl = config.getInitParameter("locatorUrl");
        if (locatorUrl == null) {
            return null;
        }
        try {
            InvokerLocator validatedLocator = new InvokerLocator(locatorUrl);
            locatorUrl = InvokerLocator.validateLocator(validatedLocator).getLocatorURI();
        }
        catch (MalformedURLException e) {
            log.warn((Object)("malformed URL: " + locatorUrl));
            return null;
        }
        ServerInvoker[] serverInvokers = InvokerRegistry.getServerInvokers();
        if (serverInvokers != null && serverInvokers.length > 0) {
            for (int x = 0; x < serverInvokers.length; ++x) {
                ServerInvoker svrInvoker = serverInvokers[x];
                InvokerLocator locator = svrInvoker.getLocator();
                if (!locatorUrl.equalsIgnoreCase(locator.getLocatorURI())) continue;
                return (ServletServerInvokerMBean)((Object)svrInvoker);
            }
            throw new ServletException("Can not find servlet server invoker with same locator as specified (" + locatorUrl + ")");
        }
        throw new ServletException("Can not find any server invokers registered.  Could be that servlet server invoker not registered or has been created using different classloader.");
    }

    protected ServletServerInvokerMBean getInvokerFromInvokerName(ServletConfig config) throws ServletException {
        ObjectName localInvokerName = null;
        String name = config.getInitParameter("invokerName");
        if (name == null) {
            return null;
        }
        try {
            localInvokerName = new ObjectName(name);
            log.debug((Object)("localInvokerName=" + localInvokerName));
        }
        catch (MalformedObjectNameException e) {
            throw new ServletException("Failed to build invokerName", (Throwable)e);
        }
        String mbeanServerId = config.getInitParameter("mbeanServer");
        MBeanServer mbeanServer = this.getMBeanServer(mbeanServerId);
        if (mbeanServer == null) {
            throw new ServletException("Failed to locate the MBeanServer");
        }
        return (ServletServerInvokerMBean)MBeanServerInvocationHandler.newProxyInstance(mbeanServer, localInvokerName, ServletServerInvokerMBean.class, false);
    }

    protected MBeanServer getMBeanServer(String mbeanServerId) {
        if (mbeanServerId == null) {
            mbeanServerId = "jboss";
        }
        if (mbeanServerId.equals("*platform*")) {
            try {
                MBeanServer s = SecurityUtility.getPlatformMBeanServer();
                log.debug((Object)"Using platform MBeanServer");
                return s;
            }
            catch (Exception e) {
                mbeanServerId = "jboss";
            }
        }
        Iterator i = SecurityUtility.findMBeanServer(null).iterator();
        while (i.hasNext()) {
            MBeanServer server = (MBeanServer)i.next();
            if (server.getDefaultDomain() == null || !server.getDefaultDomain().equals(mbeanServerId)) continue;
            log.debug((Object)("Using MBeanServer with defaultDomain: " + mbeanServerId));
            return server;
        }
        return null;
    }
}

