/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import java.beans.IntrospectionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.Home;
import org.jboss.remoting.InvocationFailureException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.Version;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.socket.ClientSocketWrapper;
import org.jboss.remoting.transport.socket.OpenConnectionChecker;
import org.jboss.remoting.transport.socket.ServerAddress;
import org.jboss.remoting.transport.socket.SocketWrapper;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.util.propertyeditor.PropertyEditors;

public class MicroSocketClientInvoker
extends RemoteClientInvoker {
    private static final Logger log = Logger.getLogger((Class)MicroSocketClientInvoker.class);
    public static final String TCP_NODELAY_FLAG = "enableTcpNoDelay";
    public static final String MAX_POOL_SIZE_FLAG = "clientMaxPoolSize";
    public static final String CLIENT_SOCKET_CLASS_FLAG = "clientSocketClass";
    public static final String ONEWAY_CONNECTION_TIMEOUT = "onewayConnectionTimeout";
    public static final String USE_ONEWAY_CONNECTION_TIMEOUT = "useOnewayConnectionTimeout";
    public static final String CONNECTION_WAIT = "connectionWait";
    public static final String WRITE_TIMEOUT = "writeTimeout";
    public static final boolean TCP_NODELAY_DEFAULT = false;
    public static final int MAX_CALL_RETRIES = 3;
    public static final int MAX_POOL_SIZE = 50;
    public static final int ONEWAY_CONNECTION_TIMEOUT_DEFAULT = 2000;
    public static final int CONNECTION_WAIT_DEFAULT = 30000;
    private static boolean trace = log.isTraceEnabled();
    static int counter = 0;
    protected static final Map connectionPools = new HashMap();
    protected static final Map semaphores = new HashMap();
    public static long getSocketTime = 0L;
    public static long readTime = 0L;
    public static long writeTime = 0L;
    public static long serializeTime = 0L;
    public static long deserializeTime = 0L;
    private static final String patternString = "^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$";
    private static final Pattern RETRIABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private Constructor clientSocketConstructor = null;
    private boolean reuseAddress = true;
    protected InetAddress addr;
    protected int port;
    protected boolean shouldCheckConnection = false;
    protected boolean enableTcpNoDelay = false;
    protected String clientSocketClassName = ClientSocketWrapper.class.getName();
    protected Class clientSocketClass = null;
    protected int numberOfCallRetries = 3;
    protected int maxPoolSize = 50;
    protected int onewayConnectionTimeout = 2000;
    protected boolean useOnewayConnectionTimeout = true;
    protected int connectionWait = 30000;
    protected LinkedList pool = null;
    protected Semaphore semaphore;
    protected ServerAddress address;
    protected Home home;
    protected boolean keepAlive;
    protected boolean keepAliveSet;
    protected boolean oOBInline;
    protected boolean oOBInlineSet;
    protected int receiveBufferSize = -1;
    protected int sendBufferSize = -1;
    protected boolean soLinger;
    protected boolean soLingerSet;
    protected int soLingerDuration = -1;
    protected int trafficClass = -1;
    protected boolean generalizeSocketException;
    protected int writeTimeout = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool(LinkedList thepool) {
        try {
            if (thepool == null) {
                return;
            }
            LinkedList linkedList = thepool;
            synchronized (linkedList) {
                int size = thepool.size();
                for (int i = 0; i < size; ++i) {
                    SocketWrapper socketWrapper = (SocketWrapper)thepool.removeFirst();
                    try {
                        socketWrapper.close();
                        socketWrapper = null;
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception ex) {
            log.debug((Object)"Failure", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPools() {
        Map map = connectionPools;
        synchronized (map) {
            Iterator i = connectionPools.keySet().iterator();
            while (i.hasNext()) {
                ServerAddress sa = (ServerAddress)i.next();
                if (trace) {
                    log.trace((Object)("clearing pool for " + sa));
                }
                MicroSocketClientInvoker.clearPool((LinkedList)connectionPools.get(sa));
                i.remove();
            }
            semaphores.clear();
        }
    }

    public MicroSocketClientInvoker(InvokerLocator locator) {
        this(locator, null);
    }

    public MicroSocketClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        try {
            this.setup();
        }
        catch (Exception ex) {
            log.debug((Object)("Error setting up " + this), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        log.debug((Object)(this + " constructed"));
    }

    public boolean checkingConnection() {
        return this.shouldCheckConnection;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuse) {
        this.reuseAddress = reuse;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        this.keepAliveSet = true;
    }

    public boolean isOOBInline() {
        return this.oOBInline;
    }

    public void setOOBInline(boolean inline) {
        this.oOBInline = inline;
        this.oOBInlineSet = true;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isSoLinger() {
        return this.soLinger;
    }

    public int getSoLingerDuration() {
        return this.soLingerDuration;
    }

    public void setSoLinger(boolean soLinger) {
        this.soLinger = soLinger;
        this.soLingerSet = true;
    }

    public void setSoLingerDuration(int soLingerDuration) {
        this.soLingerDuration = soLingerDuration;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public boolean isGeneralizeSocketException() {
        return this.generalizeSocketException;
    }

    public void setGeneralizeSocketException(boolean generalizeSocketException) {
        this.generalizeSocketException = generalizeSocketException;
    }

    public synchronized void disconnect() {
        log.debug((Object)(this + " disconnecting ..."));
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flushConnectionPool() {
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            while (this.pool != null) {
                if (this.pool.size() <= 0) return;
                SocketWrapper socketWrapper = (SocketWrapper)this.pool.removeFirst();
                try {
                    socketWrapper.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Failed to close socket wrapper", (Throwable)e);
                }
            }
            return;
        }
    }

    public int getConnectionWait() {
        return this.connectionWait;
    }

    public void setConnectionWait(int connectionWait) {
        this.connectionWait = connectionWait;
    }

    public Home getHomeInUse() {
        return this.home;
    }

    public void setNumberOfCallRetries(int numberOfCallRetries) {
        this.numberOfCallRetries = numberOfCallRetries < 1 ? 3 : numberOfCallRetries;
    }

    public int getNumberOfCallRetries() {
        return this.numberOfCallRetries;
    }

    public void setNumberOfRetries(int numberOfRetries) {
        log.warn((Object)"numberOfRetries is no longer used");
    }

    public int getNumberOfRetries() {
        log.warn((Object)"numberOfRetries is no longer used");
        return -1;
    }

    public String getServerHostName() throws Exception {
        return this.address.address;
    }

    public int getNumberOfUsedConnections() {
        if (this.semaphore == null) {
            return 0;
        }
        return this.maxPoolSize - (int)this.semaphore.permits();
    }

    public int getNumberOfAvailableConnections() {
        if (this.semaphore == null) {
            return 0;
        }
        return (int)this.semaphore.permits();
    }

    protected void setup() throws Exception {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.configuration);
        MicroSocketClientInvoker.mapJavaBeanProperties(this, props, false);
        this.configureParameters();
        if (!"multihome".equals(this.locator.getHost())) {
            this.addr = MicroSocketClientInvoker.getAddressByName(this.locator.getHost());
            this.port = this.locator.getPort();
            this.address = this.createServerAddress(this.addr, this.port);
        } else {
            List homes = this.locator.getConnectHomeList();
            if (homes.size() == 1) {
                Home home = (Home)homes.iterator().next();
                this.addr = MicroSocketClientInvoker.getAddressByName(home.host);
                this.address = this.createServerAddress(this.addr, home.port);
            }
        }
    }

    protected void configureParameters() {
        String value;
        Map params = this.configuration;
        if (params == null) {
            return;
        }
        Object val = params.get(TCP_NODELAY_FLAG);
        if (val != null) {
            try {
                this.enableTcpNoDelay = Boolean.valueOf((String)val);
                log.debug((Object)(this + " setting enableTcpNoDelay to " + this.enableTcpNoDelay));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + TCP_NODELAY_FLAG + " value of " + val + " to a boolean value."));
            }
        }
        if ((val = params.get(MAX_POOL_SIZE_FLAG)) != null) {
            try {
                this.maxPoolSize = Integer.valueOf((String)val);
                log.debug((Object)(this + " setting maxPoolSize to " + this.maxPoolSize));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + MAX_POOL_SIZE_FLAG + " value of " + val + " to a int value"));
            }
        }
        if ((val = params.get(CLIENT_SOCKET_CLASS_FLAG)) != null && (value = (String)val).length() > 0) {
            this.clientSocketClassName = value;
            log.debug((Object)(this + " setting client socket wrapper class name to " + this.clientSocketClassName));
        }
        if ((val = params.get("socket.check_connection")) != null && ((String)val).length() > 0) {
            value = (String)val;
            this.shouldCheckConnection = Boolean.valueOf(value);
            log.debug((Object)(this + " setting shouldCheckConnection to " + this.shouldCheckConnection));
        } else if (this.getVersion() == 1) {
            this.shouldCheckConnection = true;
            log.debug((Object)(this + " setting shouldCheckConnection to " + this.shouldCheckConnection));
        }
        val = params.get(ONEWAY_CONNECTION_TIMEOUT);
        if (val != null) {
            try {
                this.onewayConnectionTimeout = Integer.valueOf((String)val);
                log.debug((Object)(this + " setting onewayConnectionTimeout to " + this.onewayConnectionTimeout));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + ONEWAY_CONNECTION_TIMEOUT + " value of " + val + " to an int value"));
            }
        }
        if ((val = params.get(USE_ONEWAY_CONNECTION_TIMEOUT)) != null) {
            try {
                this.useOnewayConnectionTimeout = Boolean.valueOf((String)val);
                log.debug((Object)(this + " setting useOnewayConnectionTimeout to " + this.useOnewayConnectionTimeout));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + USE_ONEWAY_CONNECTION_TIMEOUT + " value of " + val + " to a boolean value"));
            }
        }
        if ((val = params.get(WRITE_TIMEOUT)) != null) {
            try {
                this.writeTimeout = Integer.valueOf((String)val);
                log.debug((Object)(this + " setting writeTimeout to " + this.writeTimeout));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + WRITE_TIMEOUT + " value of " + val + " to an int value"));
            }
        }
    }

    protected ServerAddress createServerAddress(InetAddress addr, int port) {
        return new ServerAddress(addr.getHostAddress(), port, this.enableTcpNoDelay, -1, this.maxPoolSize);
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    protected synchronized void handleConnect() throws ConnectionFailedException {
        this.initPool();
        if ("multihome".equals(this.locator.getHost())) {
            this.home = this.getUsableAddress(this.locator);
            if (this.home == null) {
                throw new ConnectionFailedException(this + " unable to find a usable address for: " + this.home);
            }
            this.locator.setHomeInUse(this.home);
        } else {
            this.home = new Home(this.locator.getHost(), this.locator.getPort());
        }
    }

    protected Home getUsableAddress(InvokerLocator locator) {
        List homes = this.getConnectHomes();
        Iterator it = homes.iterator();
        Home home = null;
        while (it.hasNext()) {
            try {
                home = (Home)it.next();
                this.addr = MicroSocketClientInvoker.getAddressByName(home.host);
                this.address = this.createServerAddress(this.addr, home.port);
                this.invoke(new InvocationRequest(null, null, "$ECHO$", null, null, null));
                if (trace) {
                    log.trace((Object)(this + " able to contact server at: " + home));
                }
                return home;
            }
            catch (Throwable e) {
                log.debug((Object)(this + " unable to contact server at: " + home));
            }
        }
        return null;
    }

    protected synchronized void handleDisconnect() {
        MicroSocketClientInvoker.clearPools();
        MicroSocketClientInvoker.clearPool(this.pool);
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object transport(String sessionID, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        int retryCount;
        InvocationRequest ir;
        SocketWrapper socketWrapper = null;
        Object response = null;
        boolean oneway = false;
        int tempTimeout = -1;
        int timeLeft = -1;
        int savedTimeout = -1;
        long start = -1L;
        if (metadata != null) {
            String tempTimeoutString;
            Object val = metadata.get("oneway");
            if (val != null && val instanceof String && Boolean.valueOf((String)val).booleanValue()) {
                oneway = true;
            }
            if ((tempTimeoutString = (String)metadata.get("timeout")) != null) {
                try {
                    tempTimeout = Integer.valueOf(tempTimeoutString);
                    log.debug((Object)(this + " setting timeout to " + tempTimeout + " for this invocation"));
                }
                catch (Exception e) {
                    log.warn((Object)(this + " could not convert " + "timeout" + " value of " + tempTimeoutString + " to an integer value."));
                }
            }
        }
        if (tempTimeout >= 0) {
            start = System.currentTimeMillis();
        }
        boolean serverSideOneway = false;
        if (oneway && invocation instanceof InvocationRequest && (ir = (InvocationRequest)invocation).getParameter() instanceof OnewayInvocation) {
            serverSideOneway = true;
        }
        Exception sockEx = null;
        for (retryCount = 0; retryCount < this.numberOfCallRetries; ++retryCount) {
            if (trace) {
                log.trace((Object)(this + " retryCount: " + retryCount));
            }
            if (0 < tempTimeout && (timeLeft = (int)((long)tempTimeout - (System.currentTimeMillis() - start))) <= 0) break;
            try {
                boolean tryPool = retryCount < this.numberOfCallRetries - 1 || this.maxPoolSize == 1 || this.numberOfCallRetries == 1;
                socketWrapper = this.getConnection(marshaller, unmarshaller, tryPool, timeLeft);
                log.trace((Object)(this + " got socketWrapper: " + socketWrapper));
            }
            catch (InterruptedException e) {
                this.semaphore.release();
                if (trace) {
                    log.trace((Object)(this + " released semaphore: " + this.semaphore.permits()), (Throwable)e);
                }
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                this.semaphore.release();
                if (trace) {
                    log.trace((Object)(this + " released semaphore: " + this.semaphore.permits()), (Throwable)e);
                }
                sockEx = new CannotConnectException("Can not get connection to server. Problem establishing socket connection for " + this.locator, e);
                continue;
            }
            if (tempTimeout >= 0) {
                timeLeft = (int)((long)tempTimeout - (System.currentTimeMillis() - start));
                if (timeLeft <= 0) break;
                savedTimeout = socketWrapper.getTimeout();
                socketWrapper.setTimeout(timeLeft);
            }
            try {
                int version = this.getVersion();
                boolean performVersioning = Version.performVersioning(version);
                OutputStream outputStream = socketWrapper.getOutputStream();
                log.trace((Object)(this + "got outputStream: " + outputStream));
                if (performVersioning) {
                    log.trace((Object)(this + " writing version"));
                    this.writeVersion(outputStream, version);
                    log.trace((Object)(this + " wrote version"));
                }
                this.versionedWrite(outputStream, marshaller, invocation, version);
                if (serverSideOneway) {
                    if (trace) {
                        log.trace((Object)(this + " sent oneway invocation, so not waiting for response, returning null"));
                    }
                } else if (oneway) {
                    if (performVersioning && this.useOnewayConnectionTimeout) {
                        int onewaySavedTimeout = socketWrapper.getTimeout();
                        socketWrapper.setTimeout(this.onewayConnectionTimeout);
                        InputStream inputStream = socketWrapper.getInputStream();
                        version = this.readVersion(inputStream);
                        if (version == -1) {
                            throw new EOFException("end of file");
                        }
                        if (version == 254) {
                            log.trace((Object)(this + " received version 254: treating as end of file"));
                            throw new EOFException("end of file");
                        }
                        socketWrapper.setTimeout(onewaySavedTimeout);
                    }
                } else {
                    InputStream inputStream = socketWrapper.getInputStream();
                    if (performVersioning) {
                        version = this.readVersion(inputStream);
                        if (version == -1) {
                            throw new EOFException("end of file");
                        }
                        if (version == 254) {
                            log.trace((Object)(this + " received version 254: treating as end of file"));
                            throw new EOFException("end of file");
                        }
                    }
                    response = this.versionedRead(inputStream, unmarshaller, version);
                }
                if (tempTimeout < 0) break;
                socketWrapper.setTimeout(savedTimeout);
                break;
            }
            catch (SocketException sex) {
                this.handleRetriableException(socketWrapper, sex, retryCount);
                sockEx = sex;
                continue;
            }
            catch (EOFException ex) {
                this.handleRetriableException(socketWrapper, ex, retryCount);
                sockEx = ex;
                continue;
            }
            catch (IOException e) {
                if (this.isGeneralizeSocketException() && e.getMessage() != null && RETRIABLE_ERROR_MESSAGE.matcher(e.getMessage()).matches()) {
                    this.handleRetriableException(socketWrapper, e, retryCount);
                    sockEx = new SocketException(e.getMessage());
                    continue;
                }
                return this.handleOtherException(e, this.semaphore, socketWrapper, oneway);
            }
            catch (Exception ex) {
                return this.handleOtherException(ex, this.semaphore, socketWrapper, oneway);
            }
        }
        if (retryCount >= this.numberOfCallRetries) {
            this.handleException(sockEx, socketWrapper);
        }
        if (response == null && tempTimeout > 0 && timeLeft <= 0) {
            if (sockEx == null) {
                sockEx = new CannotConnectException("Can not get connection to server. Timed out establishing socket connection for " + this.locator);
            }
            this.handleException(sockEx, socketWrapper);
        }
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() < this.maxPoolSize) {
                this.pool.add(socketWrapper);
                if (trace) {
                    log.trace((Object)(this + " returned " + socketWrapper + " to pool"));
                }
            } else {
                if (trace) {
                    log.trace((Object)(this + "'s pool is full, will close the connection"));
                }
                try {
                    socketWrapper.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            this.semaphore.release();
            if (trace) {
                log.trace((Object)(this + " released semaphore: " + this.semaphore.permits()));
            }
        }
        if (trace && !oneway) {
            log.trace((Object)(this + " received response " + response));
        }
        return response;
    }

    protected Object handleException(Exception ex, SocketWrapper socketWrapper) throws ClassNotFoundException, InvocationFailureException {
        if (ex instanceof ClassNotFoundException) {
            log.debug((Object)"Error loading classes from remote call result.", (Throwable)ex);
            throw (ClassNotFoundException)ex;
        }
        if (ex instanceof CannotConnectException) {
            log.debug((Object)this, (Throwable)ex);
            throw (CannotConnectException)ex;
        }
        if (ex instanceof InterruptedException) {
            log.debug((Object)this, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        throw new InvocationFailureException("Unable to perform invocation", ex);
    }

    protected void handleRetriableException(SocketWrapper socketWrapper, Exception e, int retryCount) {
        block8: {
            if (trace) {
                log.trace((Object)(this + "(" + socketWrapper + ") got Exception: " + e));
            }
            try {
                this.semaphore.release();
                if (trace) {
                    log.trace((Object)(this + " released semaphore: " + this.semaphore.permits()));
                }
                socketWrapper.close();
            }
            catch (Exception ex) {
                if (!trace) break block8;
                log.trace((Object)(this + " couldn't successfully close its socketWrapper"), (Throwable)ex);
            }
        }
        if (retryCount == this.numberOfCallRetries - 2) {
            this.flushConnectionPool();
        }
        if (trace) {
            if (retryCount < this.numberOfCallRetries - 1) {
                log.trace((Object)(this + " will try again, retries: " + retryCount + " < " + this.numberOfCallRetries));
            } else {
                log.trace((Object)(this + " retries exhausted"));
            }
        }
    }

    protected Object handleOtherException(Exception ex, Semaphore semaphore, SocketWrapper socketWrapper, boolean oneway) throws ClassNotFoundException, InvocationFailureException {
        log.debug((Object)(this + " got exception: " + socketWrapper), (Throwable)ex);
        try {
            semaphore.release();
            if (trace) {
                log.trace((Object)(this + " released semaphore: " + semaphore.permits()));
            }
            socketWrapper.close();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (oneway) {
            return null;
        }
        return this.handleException(ex, socketWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPool() {
        Map map = connectionPools;
        synchronized (map) {
            this.pool = (LinkedList)connectionPools.get(this.address);
            this.semaphore = (Semaphore)semaphores.get(this.address);
            if (this.pool == null) {
                this.pool = new LinkedList();
                connectionPools.put(this.address, this.pool);
                log.debug((Object)("Creating semaphore with size " + this.maxPoolSize));
                this.semaphore = new Semaphore((long)this.maxPoolSize);
                semaphores.put(this.address, this.semaphore);
                if (trace) {
                    LinkedList linkedList = this.pool;
                    synchronized (linkedList) {
                        log.trace((Object)(this + " added new pool (" + this.pool + ") as " + this.address));
                    }
                }
            } else if (trace) {
                LinkedList linkedList = this.pool;
                synchronized (linkedList) {
                    log.trace((Object)(this + " using pool (" + this.pool + ") already defined for " + this.address));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketWrapper getConnection(Marshaller marshaller, UnMarshaller unmarshaller, boolean tryPool, int timeAllowed) throws Exception {
        boolean timedout;
        long start = System.currentTimeMillis();
        long timeToWait = timeAllowed > 0 ? (long)timeAllowed : (long)this.connectionWait;
        boolean bl = timedout = !this.semaphore.attempt(timeToWait);
        if (trace) {
            log.trace((Object)(this + " obtained semaphore: " + this.semaphore.permits()));
        }
        if (timedout) {
            throw new IllegalStateException("Timeout waiting for a free socket");
        }
        SocketWrapper pooled = null;
        if (tryPool) {
            LinkedList linkedList = this.pool;
            synchronized (linkedList) {
                if (this.pool.size() > 0) {
                    pooled = this.getPooledConnection();
                    if (trace) {
                        log.trace((Object)(this + " reusing pooled connection: " + pooled));
                    }
                }
            }
        } else if (trace) {
            log.trace((Object)(this + " avoiding connection pool, creating new socket"));
        }
        if (pooled == null) {
            Socket socket = null;
            if (trace) {
                log.trace((Object)(this + " creating socket "));
            }
            int timeRemaining = -1;
            if (0 <= timeAllowed) {
                timeRemaining = (int)((long)timeAllowed - (System.currentTimeMillis() - start));
            }
            socket = this.createSocket(this.address.address, this.address.port, timeRemaining);
            if (trace) {
                log.trace((Object)(this + " created socket: " + socket));
            }
            socket.setTcpNoDelay(this.address.enableTcpNoDelay);
            HashMap<String, Serializable> metadata = this.getLocator().getParameters();
            metadata = metadata == null ? new HashMap<String, Serializable>(2) : new HashMap(metadata);
            metadata.put("marshaller", marshaller);
            metadata.put("unmarshaller", unmarshaller);
            if (this.writeTimeout > 0) {
                metadata.put(WRITE_TIMEOUT, new Integer(this.writeTimeout));
            }
            if (timeAllowed > 0) {
                timeRemaining = (int)((long)timeAllowed - (System.currentTimeMillis() - start));
                if (timeRemaining <= 0) {
                    throw new IllegalStateException("Timeout creating a new socket");
                }
                metadata.put("temptimeout", new Integer(timeRemaining));
            }
            pooled = this.createClientSocket(socket, this.address.timeout, metadata);
        }
        return pooled;
    }

    protected SocketWrapper createClientSocket(Socket socket, int timeout, Map metadata) throws Exception {
        if (this.clientSocketConstructor == null) {
            if (this.clientSocketClass == null) {
                this.clientSocketClass = ClassLoaderUtility.loadClass(this.clientSocketClassName, this.getClass());
            }
            Class[] args = new Class[]{Socket.class, Map.class, Integer.class};
            this.clientSocketConstructor = this.clientSocketClass.getConstructor(args);
        }
        SocketWrapper clientSocketWrapper = null;
        clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(socket, metadata, new Integer(timeout));
        return clientSocketWrapper;
    }

    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        Socket s = new Socket();
        this.configureSocket(s);
        InetSocketAddress inetAddr = new InetSocketAddress(address, port);
        MicroSocketClientInvoker.connect(s, inetAddr);
        return s;
    }

    protected void configureSocket(Socket s) throws SocketException {
        s.setReuseAddress(this.getReuseAddress());
        if (this.keepAliveSet) {
            s.setKeepAlive(this.keepAlive);
        }
        if (this.oOBInlineSet) {
            s.setOOBInline(this.oOBInline);
        }
        if (this.receiveBufferSize > -1) {
            s.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize > -1) {
            s.setSendBufferSize(this.sendBufferSize);
        }
        if (this.soLingerSet && this.soLingerDuration > 0) {
            s.setSoLinger(this.soLinger, this.soLingerDuration);
        }
        if (this.trafficClass > -1) {
            s.setTrafficClass(this.trafficClass);
        }
    }

    protected SocketWrapper getPooledConnection() {
        SocketWrapper socketWrapper = null;
        while (this.pool.size() > 0) {
            socketWrapper = (SocketWrapper)this.pool.removeFirst();
            try {
                if (socketWrapper == null) continue;
                if (socketWrapper instanceof OpenConnectionChecker) {
                    ((OpenConnectionChecker)((Object)socketWrapper)).checkOpenConnection();
                }
                if (this.shouldCheckConnection) {
                    socketWrapper.checkConnection();
                    return socketWrapper;
                }
                return socketWrapper;
            }
            catch (Exception ex) {
                if (trace) {
                    log.trace((Object)(this + " couldn't reuse connection from pool"));
                }
                try {
                    socketWrapper.close();
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to close socket wrapper", (Throwable)e);
                }
            }
        }
        return null;
    }

    private Object versionedRead(InputStream inputStream, UnMarshaller unmarshaller, int version) throws IOException, ClassNotFoundException {
        switch (version) {
            case 1: 
            case 2: 
            case 22: {
                if (trace) {
                    log.trace((Object)(this + " reading response from unmarshaller"));
                }
                if (unmarshaller instanceof VersionedUnMarshaller) {
                    return ((VersionedUnMarshaller)unmarshaller).read(inputStream, null, version);
                }
                return unmarshaller.read(inputStream, null);
            }
        }
        throw new IOException("Can not read data for version " + version + ". " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
    }

    private void versionedWrite(OutputStream outputStream, Marshaller marshaller, Object invocation, int version) throws IOException {
        switch (version) {
            case 1: 
            case 2: 
            case 22: {
                if (trace) {
                    log.trace((Object)(this + " writing invocation to marshaller"));
                }
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(invocation, outputStream, version);
                } else {
                    marshaller.write(invocation, outputStream);
                }
                if (trace) {
                    log.trace((Object)(this + " done writing invocation to marshaller"));
                }
                return;
            }
        }
        throw new IOException("Can not write data for version " + version + ".  " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
    }

    private int readVersion(InputStream inputStream) throws IOException {
        if (trace) {
            log.trace((Object)(this + " reading version from input stream"));
        }
        int version = inputStream.read();
        if (trace) {
            log.trace((Object)(this + " read version " + version + " from input stream"));
        }
        return version;
    }

    private void writeVersion(OutputStream outputStream, int version) throws IOException {
        if (trace) {
            log.trace((Object)(this + " writing version " + version + " on output stream"));
        }
        outputStream.write(version);
    }

    private static void mapJavaBeanProperties(final Object o, final Properties props, final boolean isStrict) throws IntrospectionException {
        if (SecurityUtility.skipAccessControl()) {
            PropertyEditors.mapJavaBeanProperties((Object)o, (Properties)props, (boolean)isStrict);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IntrospectionException {
                    PropertyEditors.mapJavaBeanProperties((Object)o, (Properties)props, (boolean)isStrict);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IntrospectionException)e.getCause();
        }
    }

    private static void connect(final Socket socket, final InetSocketAddress address) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            socket.connect(address);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    socket.connect(address);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static InetAddress getAddressByName(final String host) throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return InetAddress.getByName(host);
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }
}

