/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.bisocket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.Home;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.socketfactory.CreationListenerServerSocket;
import org.jboss.remoting.socketfactory.CreationListenerSocketFactory;
import org.jboss.remoting.socketfactory.SocketCreationListener;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.bisocket.BisocketClientInvoker;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.SocketServerInvoker;
import org.jboss.remoting.util.SecurityUtility;

public class BisocketServerInvoker
extends SocketServerInvoker {
    private static final Logger log = Logger.getLogger((Class)BisocketServerInvoker.class);
    private static Map listenerIdToServerInvokerMap = Collections.synchronizedMap(new HashMap());
    private static Timer timer;
    private static Object timerLock;
    private Map listenerIdToInvokerLocatorMap = Collections.synchronizedMap(new HashMap());
    private Set secondaryServerSockets = new HashSet();
    private InvokerLocator secondaryLocator;
    private Set secondaryServerSocketThreads = new HashSet();
    private Map controlConnectionThreadMap = new HashMap();
    private Map controlConnectionRestartsMap = Collections.synchronizedMap(new HashMap());
    private int pingFrequency = 5000;
    private int pingWindowFactor = 2;
    private int pingWindow = this.pingWindowFactor * this.pingFrequency;
    private int socketCreationRetries = 10;
    private int controlConnectionRestarts = 10;
    private ControlMonitorTimerTask controlMonitorTimerTask;
    protected boolean isCallbackServer = false;
    protected List secondaryBindPorts = new ArrayList();
    protected List secondaryConnectPorts = new ArrayList();
    static /* synthetic */ Class class$java$util$Timer;

    public static BisocketServerInvoker getBisocketServerInvoker(String listenerId) {
        return (BisocketServerInvoker)listenerIdToServerInvokerMap.get(listenerId);
    }

    public BisocketServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public BisocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.isCallbackServer) {
            int nVal;
            Object val = this.configuration.get("maxRetries");
            if (val != null) {
                try {
                    this.socketCreationRetries = nVal = Integer.valueOf((String)val).intValue();
                    log.debug((Object)("Setting socket creation retry limit: " + this.socketCreationRetries));
                }
                catch (Exception e) {
                    log.warn((Object)("Could not convert maxRetries value of " + val + " to an int value."));
                }
            }
            if ((val = this.configuration.get("maxControlConnectionRestarts")) != null) {
                try {
                    this.controlConnectionRestarts = nVal = Integer.valueOf((String)val).intValue();
                    log.debug((Object)("Setting control connection restart limit: " + this.controlConnectionRestarts));
                }
                catch (Exception e) {
                    log.warn((Object)("Could not convert maxControlConnectionRestarts value of " + val + " to an int value."));
                }
            }
            if (this.maxPoolSize <= 0) {
                this.maxPoolSize = MAX_POOL_SIZE_DEFAULT;
            }
            this.clientpool = new LRUPool(2, this.maxPoolSize);
            this.clientpool.create();
            this.threadpool = new LinkedList();
            this.checkSocketFactoryWrapper();
            if (this.pingFrequency > 0) {
                this.controlMonitorTimerTask = new ControlMonitorTimerTask(this);
                Object e = timerLock;
                synchronized (e) {
                    if (timer == null) {
                        timer = new Timer(true);
                    }
                    try {
                        timer.schedule((TimerTask)this.controlMonitorTimerTask, this.pingFrequency, (long)this.pingFrequency);
                    }
                    catch (IllegalStateException e2) {
                        log.debug((Object)"Unable to schedule TimerTask on existing Timer", (Throwable)e2);
                        timer = new Timer(true);
                        timer.schedule((TimerTask)this.controlMonitorTimerTask, this.pingFrequency, (long)this.pingFrequency);
                    }
                }
            }
            this.running = true;
            this.started = true;
        } else {
            Object host;
            super.start();
            if (this.serverSockets.size() < this.secondaryBindPorts.size()) {
                log.warn((Object)(this + " extra secondary bind ports will be ignored"));
            } else if (this.serverSockets.size() > this.secondaryBindPorts.size()) {
                log.warn((Object)(this + " not enough secondary bind ports: will use anonymous ports as necessary"));
            }
            if (this.secondaryConnectPorts.size() == 0) {
                this.secondaryConnectPorts = this.secondaryBindPorts;
            } else if (this.secondaryConnectPorts.size() != this.secondaryBindPorts.size()) {
                log.warn((Object)(this + " number of secondary connect ports != number of secondary bind ports"));
                log.warn((Object)(this + " will ignore secondary connect ports"));
                this.secondaryConnectPorts = this.secondaryBindPorts;
            }
            int i = 0;
            Iterator it = this.serverSockets.iterator();
            while (it.hasNext()) {
                ServerSocket ss = (ServerSocket)it.next();
                host = ss.getInetAddress();
                int secondaryBindPort = -1;
                if (this.secondaryBindPorts.size() > i) {
                    secondaryBindPort = (Integer)this.secondaryBindPorts.get(i);
                } else {
                    this.secondaryBindPorts.add(new Integer(-1));
                }
                if (secondaryBindPort < 0) {
                    secondaryBindPort = PortUtil.findFreePort(((InetAddress)host).getHostAddress());
                    this.secondaryBindPorts.set(i, new Integer(secondaryBindPort));
                }
                ServerSocket secondaryServerSocket = null;
                final int finalBindPort = secondaryBindPort;
                try {
                    secondaryServerSocket = (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction((InetAddress)host){
                        private final /* synthetic */ InetAddress val$host;
                        {
                            this.val$host = inetAddress;
                        }

                        public Object run() throws Exception {
                            ServerSocket ss = null;
                            ss = BisocketServerInvoker.this.serverSocketFactory != null ? BisocketServerInvoker.this.serverSocketFactory.createServerSocket(finalBindPort, 0, this.val$host) : new ServerSocket(finalBindPort, 0, this.val$host);
                            return ss;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getCause();
                }
                ss = this.checkSecondaryServerSocketWrapper(secondaryServerSocket);
                this.secondaryServerSockets.add(ss);
                log.debug((Object)(this + " created secondary " + ss));
                ++i;
            }
            i = 0;
            it = this.secondaryServerSockets.iterator();
            while (it.hasNext()) {
                ServerSocket secondaryServerSocket = (ServerSocket)it.next();
                SecondaryServerSocketThread t = new SecondaryServerSocketThread(secondaryServerSocket);
                t.setName("secondaryServerSocketThread[" + i++ + "]");
                t.setDaemon(true);
                t.start();
                this.secondaryServerSocketThreads.add(t);
                log.debug((Object)(this + " created " + t));
            }
            if (this.getLocator().isMultihome()) {
                int j = 0;
                host = ((Home)this.connectHomes.get((int)j)).host;
                int port = (Integer)this.secondaryConnectPorts.get(j);
                if (port < 0) {
                    port = (Integer)this.secondaryBindPorts.get(j);
                }
                StringBuffer sb = new StringBuffer((String)host).append(':').append(port);
                for (j = 1; j < this.connectHomes.size(); ++j) {
                    host = ((Home)this.connectHomes.get((int)j)).host;
                    port = (Integer)this.secondaryConnectPorts.get(j);
                    if (port < 0) {
                        port = (Integer)this.secondaryBindPorts.get(j);
                    }
                    sb.append('!').append((String)host).append(':').append(port);
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("homes", sb.toString());
                this.secondaryLocator = new InvokerLocator(null, "multihome", -1, null, params);
            } else {
                String connectAddress = this.getLocator().getHost();
                int connectPort = (Integer)this.secondaryConnectPorts.get(0);
                if (connectPort < 0) {
                    connectPort = (Integer)this.secondaryBindPorts.get(0);
                }
                this.secondaryLocator = new InvokerLocator(null, connectAddress, connectPort, null, null);
            }
            log.debug((Object)(this + " created secondary InvokerLocator: " + this.secondaryLocator));
        }
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createControlConnection(String listenerId, boolean firstConnection) throws IOException {
        Object ioe;
        BisocketClientInvoker clientInvoker = BisocketClientInvoker.getBisocketClientInvoker(listenerId);
        if (clientInvoker == null) {
            log.debug((Object)"Unable to retrieve client invoker: must have disconnected");
            throw new ClientUnavailableException();
        }
        InvokerLocator oldLocator = (InvokerLocator)this.listenerIdToInvokerLocatorMap.get(listenerId);
        InvokerLocator newLocator = null;
        try {
            newLocator = clientInvoker.getSecondaryLocator();
        }
        catch (Throwable t) {
            log.debug((Object)"unable to get secondary locator", t);
            throw new IOException("unable to get secondary locator: " + t.getMessage());
        }
        boolean locatorChanged = !newLocator.equals(oldLocator);
        this.listenerIdToInvokerLocatorMap.put(listenerId, newLocator);
        String host = newLocator.getHost();
        int port = newLocator.getPort();
        if (newLocator.isMultihome()) {
            host = clientInvoker.getHomeInUse().host;
            port = -1;
            Iterator it = null;
            it = newLocator.getConnectHomeList().isEmpty() ? newLocator.getHomeList().iterator() : newLocator.getConnectHomeList().iterator();
            while (it.hasNext()) {
                Home h = (Home)it.next();
                if (!host.equals(h.host)) continue;
                port = h.port;
                newLocator.setHomeInUse(h);
                break;
            }
        }
        if (port == -1) {
            throw new IOException("Cannot find matching home for control connection");
        }
        log.debug((Object)("creating control connection: " + newLocator));
        Socket socket = null;
        IOException savedException = null;
        final String finalHost = host;
        final int finalPort = port;
        for (int i = 0; i < this.socketCreationRetries; ++i) {
            try {
                socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Socket s = null;
                        s = BisocketServerInvoker.this.socketFactory != null ? BisocketServerInvoker.this.socketFactory.createSocket(finalHost, finalPort) : new Socket(finalHost, finalPort);
                        return s;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                ioe = (IOException)e.getCause();
                log.debug((Object)"Error creating a control socket", (Throwable)ioe);
                savedException = ioe;
            }
            if (socket != null) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                log.debug((Object)"received interrupt");
            }
        }
        if (socket == null) {
            log.debug((Object)("unable to create control connection after " + this.socketCreationRetries + " retries"), (Throwable)savedException);
            throw savedException;
        }
        DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
        if (firstConnection) {
            dos.write(2);
        } else {
            dos.write(3);
        }
        dos.writeUTF(listenerId);
        ControlConnectionThread thread = new ControlConnectionThread(socket, listenerId);
        thread.setName("control: " + socket.toString());
        thread.setDaemon(true);
        ioe = this.controlConnectionThreadMap;
        synchronized (ioe) {
            this.controlConnectionThreadMap.put(listenerId, thread);
        }
        Object o = this.controlConnectionRestartsMap.get(listenerId);
        if (o != null) {
            int restarts = (Integer)o;
            if (locatorChanged || restarts > 0) {
                this.controlConnectionRestartsMap.put(listenerId, new Integer(++restarts));
            }
        } else {
            this.controlConnectionRestartsMap.put(listenerId, new Integer(0));
        }
        thread.start();
        log.debug((Object)(this + " created control connection (" + listenerId + "): " + socket.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyControlConnection(String listenerId) {
        Thread t = null;
        Map map = this.controlConnectionThreadMap;
        synchronized (map) {
            t = (Thread)this.controlConnectionThreadMap.remove(listenerId);
        }
        if (t != null) {
            ((ControlConnectionThread)t).shutdown();
            log.debug((Object)(this + " shutting down control connection: " + listenerId));
        } else {
            log.debug((Object)("unrecognized listener ID: " + listenerId));
        }
        this.listenerIdToInvokerLocatorMap.remove(listenerId);
        this.controlConnectionRestartsMap.remove(listenerId);
    }

    public int getControlConnectionRestarts() {
        return this.controlConnectionRestarts;
    }

    public void setControlConnectionRestarts(int controlConnectionRestarts) {
        this.controlConnectionRestarts = controlConnectionRestarts;
    }

    public int getPingFrequency() {
        return this.pingFrequency;
    }

    public void setPingFrequency(int pingFrequency) {
        this.pingFrequency = pingFrequency;
        this.pingWindow = this.pingWindowFactor * pingFrequency;
    }

    public int getPingWindowFactor() {
        return this.pingWindowFactor;
    }

    public void setPingWindowFactor(int pingWindowFactor) {
        this.pingWindowFactor = pingWindowFactor;
        this.pingWindow = pingWindowFactor * this.pingFrequency;
    }

    public int getSecondaryBindPort() {
        if (this.secondaryBindPorts.size() == 0 || this.secondaryBindPorts.size() > 1) {
            return -1;
        }
        return (Integer)this.secondaryBindPorts.get(0);
    }

    public void setSecondaryBindPort(int secondaryPort) {
        this.secondaryBindPorts.clear();
        this.secondaryBindPorts.add(new Integer(secondaryPort));
    }

    public List getSecondaryBindPorts() {
        return new ArrayList(this.secondaryBindPorts);
    }

    public void setSecondaryBindPorts(List secondaryBindPorts) {
        this.secondaryBindPorts = secondaryBindPorts;
    }

    public void setSecondaryBindPorts(String secondaryBindPortString) {
        StringTokenizer tok = new StringTokenizer(secondaryBindPortString, "!");
        String token = null;
        while (tok.hasMoreTokens()) {
            try {
                token = tok.nextToken();
                this.secondaryBindPorts.add(Integer.valueOf(token));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid format for \"secondaryBindPort\": " + token));
                this.secondaryBindPorts.add(new Integer(-1));
            }
        }
    }

    public int getSecondaryConnectPort() {
        if (this.secondaryConnectPorts.size() == 0 || this.secondaryConnectPorts.size() > 1) {
            return -1;
        }
        return (Integer)this.secondaryConnectPorts.get(0);
    }

    public void setSecondaryConnectPort(int secondaryConnectPort) {
        this.secondaryConnectPorts.clear();
        this.secondaryConnectPorts.add(new Integer(secondaryConnectPort));
    }

    public List getSecondaryConnectPorts() {
        return new ArrayList(this.secondaryConnectPorts);
    }

    public void setSecondaryConnectPorts(List secondaryConnectPorts) {
        this.secondaryConnectPorts = secondaryConnectPorts;
    }

    public void setSecondaryConnectPorts(String secondaryConnectPortString) {
        StringTokenizer tok = new StringTokenizer(secondaryConnectPortString, "!");
        String token = null;
        while (tok.hasMoreTokens()) {
            try {
                token = tok.nextToken();
                this.secondaryConnectPorts.add(Integer.valueOf(token));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid format for \"secondaryConnectPort\": " + token));
                this.secondaryConnectPorts.add(new Integer(-1));
            }
        }
    }

    public int getSocketCreationRetries() {
        return this.socketCreationRetries;
    }

    public void setSocketCreationRetries(int socketCreationRetries) {
        this.socketCreationRetries = socketCreationRetries;
    }

    protected void setup() throws Exception {
        Object o = this.configuration.get("isCallbackServer");
        if (o != null) {
            if (o instanceof String) {
                this.isCallbackServer = Boolean.valueOf((String)o);
            } else if (o instanceof Boolean) {
                this.isCallbackServer = (Boolean)o;
            } else {
                log.error((Object)("unrecognized value for configuration key \"isCallbackServer\": " + o));
            }
        }
        super.setup();
        o = this.configuration.get("pingFrequency");
        if (o instanceof String && ((String)o).length() > 0) {
            try {
                this.pingFrequency = Integer.valueOf((String)o);
                log.debug((Object)(this + " setting pingFrequency to " + this.pingFrequency));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid format for \"pingFrequency\": " + o));
            }
        } else if (o != null) {
            log.warn((Object)"\"pingFrequency\" must be specified as a String");
        }
        if ((o = this.configuration.get("pingWindowFactor")) instanceof String && ((String)o).length() > 0) {
            try {
                this.pingWindowFactor = Integer.valueOf((String)o);
                log.debug((Object)(this + " setting pingWindowFactor to " + this.pingWindowFactor));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid format for \"pingWindowFactor\": " + o));
            }
        } else if (o != null) {
            log.warn((Object)"\"pingWindowFactor\" must be specified as a String");
        }
        this.pingWindow = this.pingWindowFactor * this.pingFrequency;
        o = this.configuration.get("secondaryBindPorts");
        if (o instanceof String && ((String)o).length() > 0) {
            this.setSecondaryBindPorts((String)o);
        } else if (o instanceof List) {
            this.setSecondaryBindPorts((List)o);
        } else if (o != null) {
            log.warn((Object)"\"secondaryBindPorts\" must be specified as a String or a List");
        }
        o = this.configuration.get("secondaryConnectPorts");
        if (o instanceof String && ((String)o).length() > 0) {
            this.setSecondaryConnectPorts((String)o);
        } else if (o instanceof List) {
            this.setSecondaryConnectPorts((List)o);
        } else if (o != null) {
            log.warn((Object)"\"secondaryConnectPorts\" must be specified as a String or a List");
        }
        if (this.secondaryBindPorts.isEmpty()) {
            for (int i = 0; i < this.homes.size(); ++i) {
                this.secondaryBindPorts.add(new Integer(-1));
            }
        }
        if (this.secondaryConnectPorts.isEmpty()) {
            this.secondaryConnectPorts = new ArrayList(this.secondaryBindPorts);
        }
        if (this.isCallbackServer) {
            this.socketFactory = this.createSocketFactory(this.configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Map map = this.controlConnectionThreadMap;
        synchronized (map) {
            Iterator it = this.controlConnectionThreadMap.values().iterator();
            while (it.hasNext()) {
                ControlConnectionThread t = (ControlConnectionThread)it.next();
                it.remove();
                t.shutdown();
            }
        }
        super.cleanup();
        if (this.controlMonitorTimerTask != null) {
            this.controlMonitorTimerTask.shutdown();
        }
        Iterator it = this.secondaryServerSocketThreads.iterator();
        while (it.hasNext()) {
            SecondaryServerSocketThread t = (SecondaryServerSocketThread)it.next();
            t.shutdown();
        }
        it = this.secondaryServerSockets.iterator();
        while (it.hasNext()) {
            try {
                ServerSocket ss = (ServerSocket)it.next();
                ss.close();
            }
            catch (IOException e) {
                log.info((Object)("Error closing secondary server socket: " + e.getMessage()));
            }
        }
        this.secondaryBindPorts.clear();
        this.secondaryConnectPorts.clear();
    }

    protected InvokerLocator getSecondaryLocator() {
        return this.secondaryLocator;
    }

    protected void checkSocketFactoryWrapper() throws IOException {
        Object o = this.configuration.get("socketCreationServerListener");
        if (o != null) {
            if (o instanceof SocketCreationListener) {
                SocketCreationListener listener = (SocketCreationListener)o;
                if (this.socketFactory instanceof CreationListenerSocketFactory) {
                    CreationListenerSocketFactory clsf = (CreationListenerSocketFactory)this.socketFactory;
                    clsf.setListener(listener);
                } else {
                    this.socketFactory = new CreationListenerSocketFactory(this.socketFactory, listener);
                }
            } else {
                log.error((Object)("socket creation listener of invalid type: " + o));
            }
        } else if (this.socketFactory instanceof CreationListenerSocketFactory) {
            CreationListenerSocketFactory clsf = (CreationListenerSocketFactory)this.socketFactory;
            this.socketFactory = clsf.getFactory();
        }
    }

    protected ServerSocket checkSecondaryServerSocketWrapper(ServerSocket secondaryServerSocket) throws IOException {
        Object o = this.configuration.get("socketCreationClientListener");
        if (o != null) {
            if (o instanceof SocketCreationListener) {
                SocketCreationListener listener = (SocketCreationListener)o;
                if (secondaryServerSocket instanceof CreationListenerServerSocket) {
                    CreationListenerServerSocket clss = (CreationListenerServerSocket)secondaryServerSocket;
                    clss.setListener(listener);
                } else {
                    secondaryServerSocket = new CreationListenerServerSocket(secondaryServerSocket, listener);
                }
            } else {
                log.error((Object)("socket creation listener of invalid type: " + o));
            }
        } else if (secondaryServerSocket instanceof CreationListenerServerSocket) {
            CreationListenerServerSocket clss = (CreationListenerServerSocket)secondaryServerSocket;
            secondaryServerSocket = clss.getServerSocket();
        }
        return secondaryServerSocket;
    }

    protected Object handleInternalInvocation(InternalInvocation ii, InvocationRequest ir, ServerInvocationHandler handler) throws Throwable {
        String listenerId;
        Map metadata;
        if ("getSecondaryInvokerLocator".equals(ii.getMethodName())) {
            return this.secondaryLocator;
        }
        Object response = super.handleInternalInvocation(ii, ir, handler);
        if ("addClientListener".equals(ii.getMethodName())) {
            String listenerId2;
            Map metadata2 = ir.getRequestPayload();
            if (metadata2 != null && (listenerId2 = (String)metadata2.get("listenerId")) != null) {
                listenerIdToServerInvokerMap.put(listenerId2, this);
            }
        } else if ("removeClientListener".equals(ii.getMethodName()) && (metadata = ir.getRequestPayload()) != null && (listenerId = (String)metadata.get("listenerId")) != null) {
            listenerIdToServerInvokerMap.remove(listenerId);
            BisocketClientInvoker.removeBisocketClientInvoker(listenerId);
            this.destroyControlConnection(listenerId);
        }
        return response;
    }

    private static Method getDeclaredMethod(final Class c, final String name, final Class[] parameterTypes) throws NoSuchMethodException {
        if (SecurityUtility.skipAccessControl()) {
            Method m = c.getDeclaredMethod(name, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    Method m = c.getDeclaredMethod(name, parameterTypes);
                    m.setAccessible(true);
                    return m;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NoSuchMethodException)e.getCause();
        }
    }

    static {
        timerLock = new Object();
    }

    static class ClientUnavailableException
    extends IOException {
        private static final long serialVersionUID = 2846502029152028732L;

        ClientUnavailableException() {
        }
    }

    static class ControlMonitorTimerTask
    extends TimerTask {
        private boolean running = true;
        private BisocketServerInvoker invoker;
        private Map listenerIdToInvokerLocatorMap;
        private Map controlConnectionThreadMap;
        private Map controlConnectionRestartsMap;
        private int controlConnectionRestarts;

        ControlMonitorTimerTask(BisocketServerInvoker invoker) {
            this.invoker = invoker;
            this.listenerIdToInvokerLocatorMap = invoker.listenerIdToInvokerLocatorMap;
            this.controlConnectionThreadMap = invoker.controlConnectionThreadMap;
            this.controlConnectionRestartsMap = invoker.controlConnectionRestartsMap;
            this.controlConnectionRestarts = invoker.controlConnectionRestarts;
        }

        synchronized void shutdown() {
            this.running = false;
            this.invoker = null;
            this.listenerIdToInvokerLocatorMap = null;
            this.controlConnectionThreadMap = null;
            this.cancel();
            try {
                Method purge = BisocketServerInvoker.getDeclaredMethod(class$java$util$Timer == null ? (class$java$util$Timer = BisocketServerInvoker.class$("java.util.Timer")) : class$java$util$Timer, "purge", new Class[0]);
                purge.invoke((Object)timer, new Object[0]);
            }
            catch (Exception e) {
                log.debug((Object)"running with jdk 1.4: unable to purge Timer");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!this.running) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"checking connections");
            }
            HashSet controlConnectionThreads = null;
            ControlMonitorTimerTask controlMonitorTimerTask = this;
            synchronized (controlMonitorTimerTask) {
                if (!this.running) {
                    return;
                }
                controlConnectionThreads = new HashSet(this.controlConnectionThreadMap.values());
            }
            Iterator it = controlConnectionThreads.iterator();
            while (it.hasNext()) {
                Object locator;
                ControlConnectionThread t = (ControlConnectionThread)it.next();
                final String listenerId = t.getListenerId();
                ControlMonitorTimerTask controlMonitorTimerTask2 = this;
                synchronized (controlMonitorTimerTask2) {
                    if (!this.running) {
                        return;
                    }
                    locator = this.listenerIdToInvokerLocatorMap.get(listenerId);
                }
                if (t.checkConnection()) continue;
                t.shutdown();
                controlMonitorTimerTask2 = this;
                synchronized (controlMonitorTimerTask2) {
                    if (!this.running) {
                        return;
                    }
                    this.controlConnectionThreadMap.remove(listenerId);
                    Object o = this.controlConnectionRestartsMap.get(listenerId);
                    int restarts = (Integer)o;
                    if (restarts + 1 > this.controlConnectionRestarts) {
                        log.warn((Object)(this + ": detected failure on control connection " + t));
                        log.warn((Object)("Control connection " + listenerId + " has been recreated " + restarts + " times."));
                        log.warn((Object)"Assuming it is a connection to an old server, and will not restart");
                        this.controlConnectionRestartsMap.remove(listenerId);
                        continue;
                    }
                    log.warn((Object)(this + ": detected failure on control connection " + t + " (" + listenerId + ": requesting new control connection"));
                }
                Thread t2 = new Thread(){

                    public void run() {
                        if (!ControlMonitorTimerTask.this.running) {
                            return;
                        }
                        try {
                            ControlMonitorTimerTask.this.invoker.createControlConnection(listenerId, false);
                        }
                        catch (ClientUnavailableException e) {
                            log.debug((Object)("Unable to recreate control connection: " + locator), (Throwable)e);
                        }
                        catch (IOException e) {
                            if (ControlMonitorTimerTask.this.running) {
                                log.error((Object)("Unable to recreate control connection: " + locator), (Throwable)e);
                            }
                            log.debug((Object)("Unable to recreate control connection: " + locator), (Throwable)e);
                        }
                    }
                };
                t2.setName("controlConnectionRecreate:" + t.getName());
                t2.start();
            }
        }
    }

    class SecondaryServerSocketThread
    extends Thread {
        private ServerSocket secondaryServerSocket;
        boolean running = true;

        SecondaryServerSocketThread(ServerSocket secondaryServerSocket) throws IOException {
            this.secondaryServerSocket = secondaryServerSocket;
        }

        void shutdown() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            block9: while (this.running) {
                try {
                    Socket socket = null;
                    try {
                        socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return SecondaryServerSocketThread.this.secondaryServerSocket.accept();
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (IOException)e.getCause();
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("accepted: " + socket));
                    }
                    DataInputStream dis = new DataInputStream(socket.getInputStream());
                    int action = dis.read();
                    String listenerId = dis.readUTF();
                    switch (action) {
                        case 2: {
                            BisocketClientInvoker.transferSocket(listenerId, socket, true);
                            if (!log.isTraceEnabled()) continue block9;
                            log.trace((Object)("SecondaryServerSocketThread: created control socket: (" + socket + ")" + listenerId));
                            continue block9;
                        }
                        case 3: {
                            BisocketClientInvoker invoker = BisocketClientInvoker.getBisocketCallbackClientInvoker(listenerId);
                            if (invoker == null) {
                                log.debug((Object)("received new control socket for unrecognized listenerId: " + listenerId));
                                continue block9;
                            }
                            invoker.replaceControlSocket(socket);
                            if (!log.isTraceEnabled()) continue block9;
                            log.trace((Object)("SecondaryServerSocketThread: recreated control socket: " + listenerId));
                            continue block9;
                        }
                        case 4: {
                            BisocketClientInvoker.transferSocket(listenerId, socket, false);
                            if (!log.isTraceEnabled()) continue block9;
                            log.trace((Object)("SecondaryServerSocketThread: transferred socket: " + listenerId));
                            continue block9;
                        }
                    }
                    log.error((Object)("unrecognized action on SecondaryServerSocketThread: " + action));
                }
                catch (IOException e) {
                    if (this.running) {
                        log.error((Object)"Failed to accept socket connection", (Throwable)e);
                        continue;
                    }
                    return;
                }
            }
        }

        ServerSocket getServerSocket() {
            return this.secondaryServerSocket;
        }
    }

    class ControlConnectionThread
    extends Thread {
        private static final int MAX_INITIAL_ATTEMPTS = 5;
        private Socket controlSocket;
        private String listenerId;
        private DataInputStream dis;
        private boolean running;
        private int errorCount;
        private long lastPing = -1L;
        private int initialAttempts;

        ControlConnectionThread(Socket socket, String listenerId) throws IOException {
            this.controlSocket = socket;
            this.listenerId = listenerId;
            this.dis = new DataInputStream(socket.getInputStream());
        }

        void shutdown() {
            this.running = false;
            try {
                this.controlSocket.close();
            }
            catch (IOException e) {
                log.warn((Object)"unable to close controlSocket");
            }
            this.interrupt();
        }

        boolean checkConnection() {
            if (this.lastPing < 0L && this.initialAttempts++ < 5) {
                return true;
            }
            if (this.lastPing < 0L) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            if (log.isTraceEnabled()) {
                log.trace((Object)("elapsed: " + (currentTime - this.lastPing)));
            }
            return currentTime - this.lastPing <= (long)BisocketServerInvoker.this.pingWindow;
        }

        String getListenerId() {
            return this.listenerId;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                Socket socket;
                block20: {
                    socket = null;
                    try {
                        int action = this.dis.read();
                        this.lastPing = System.currentTimeMillis();
                        switch (action) {
                            case 4: {
                                InvokerLocator locator = (InvokerLocator)BisocketServerInvoker.this.listenerIdToInvokerLocatorMap.get(this.listenerId);
                                IOException savedException = null;
                                final String finalHost = locator.getHost();
                                final int finalPort = locator.getPort();
                                for (int i = 0; i < BisocketServerInvoker.this.socketCreationRetries; ++i) {
                                    try {
                                        socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                            public Object run() throws Exception {
                                                Socket s = null;
                                                s = BisocketServerInvoker.this.socketFactory != null ? BisocketServerInvoker.this.socketFactory.createSocket(finalHost, finalPort) : new Socket(finalHost, finalPort);
                                                return s;
                                            }
                                        });
                                    }
                                    catch (PrivilegedActionException e) {
                                        IOException ioe = (IOException)e.getCause();
                                        log.debug((Object)"Error creating a socket", (Throwable)ioe);
                                        savedException = ioe;
                                    }
                                    if (socket != null) break;
                                    try {
                                        Thread.sleep(1000L);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        if (this.running) {
                                            log.debug((Object)"received unexpected interrupt");
                                            continue;
                                        }
                                        return;
                                    }
                                }
                                if (socket == null) {
                                    log.error((Object)("Unable to create socket after " + BisocketServerInvoker.this.socketCreationRetries + " retries"), (Throwable)savedException);
                                    break;
                                }
                                DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
                                dos.write(4);
                                dos.writeUTF(this.listenerId);
                                break block20;
                            }
                            case 1: {
                                break;
                            }
                            case -1: {
                                this.shutdown();
                                return;
                            }
                            default: {
                                log.error((Object)("unrecognized action on ControlConnectionThread (" + this.listenerId + "): " + action));
                                break;
                            }
                        }
                        continue;
                    }
                    catch (IOException e) {
                        if (this.running) {
                            if ("Socket closed".equalsIgnoreCase(e.getMessage()) || "Socket is closed".equalsIgnoreCase(e.getMessage()) || "Connection reset".equalsIgnoreCase(e.getMessage())) {
                                this.shutdown();
                                return;
                            }
                            log.error((Object)("Unable to process control connection: " + e.getMessage()), (Throwable)e);
                            if (++this.errorCount <= 5) continue;
                            this.shutdown();
                            return;
                        }
                        return;
                    }
                }
                if (!this.running) {
                    return;
                }
                try {
                    BisocketServerInvoker.this.processInvocation(socket);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to create new ServerThread: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

