/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.AttachmentsImpl;
import org.jboss.remoting3.Client;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.FutureReplyImpl;
import org.jboss.remoting3.IndeterminateOutcomeException;
import org.jboss.remoting3.QueueExecutor;
import org.jboss.remoting3.RemoteRequestException;
import org.jboss.remoting3.TypedRequest;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ReplyHandler;
import org.jboss.remoting3.spi.RequestHandler;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientImpl<I, O>
extends AbstractHandleableCloseable<Client<I, O>>
implements Client<I, O> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting.client");
    private final RequestHandler handler;
    private final Class<I> requestClass;
    private final Class<O> replyClass;
    private final Attachments attachments = new AttachmentsImpl();

    private ClientImpl(RequestHandler handler, Executor executor, Class<I> requestClass, Class<O> replyClass) {
        super(executor);
        this.handler = handler;
        this.requestClass = requestClass;
        this.replyClass = replyClass;
    }

    static <I, O> ClientImpl<I, O> create(RequestHandler handler, Executor executor, Class<I> requestClass, Class<O> replyClass) {
        final ClientImpl<I, O> ci = new ClientImpl<I, O>(handler, executor, requestClass, replyClass);
        handler.addCloseHandler(new CloseHandler<RequestHandler>(){

            @Override
            public void handleClose(RequestHandler closed) {
                IoUtils.safeClose((Closeable)ci);
            }
        });
        return ci;
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    protected void closeAction() throws IOException {
        this.handler.close();
    }

    @Override
    public O invoke(I request) throws IOException {
        return this.invoke(request, this.replyClass);
    }

    @Override
    public <T extends O> T invoke(I request, Class<T> replyClass) throws IOException, CancellationException {
        if (!this.isOpen()) {
            throw new IOException("Client is not open");
        }
        log.trace("Client.invoke() sending request \"%s\"", request);
        I actualRequest = this.castRequest(request);
        QueueExecutor executor = new QueueExecutor();
        FutureReplyImpl<T> futureReply = new FutureReplyImpl<T>((Executor)((Object)executor), replyClass);
        ReplyHandler replyHandler = futureReply.getReplyHandler();
        Cancellable requestContext = this.handler.receiveRequest(actualRequest, replyHandler);
        futureReply.setRemoteRequestContext(requestContext);
        futureReply.addNotifier(IoUtils.attachmentClosingNotifier(), executor);
        executor.runQueue();
        try {
            Object reply = futureReply.getInterruptibly();
            log.trace("Client.invoke() received reply \"%s\"", reply);
            return (T)reply;
        }
        catch (InterruptedException e) {
            try {
                futureReply.cancel();
                throw new IndeterminateOutcomeException("The current thread was interrupted before the result could be read");
            }
            catch (Throwable throwable) {
                Thread.currentThread().interrupt();
                throw throwable;
            }
        }
    }

    @Override
    public <T extends O> T invokeTyped(TypedRequest<? extends I, T> typedRequest) throws IOException, CancellationException {
        if (!this.isOpen()) {
            throw new IOException("Client is not open");
        }
        log.trace("Client.invoke() sending request \"%s\"", typedRequest);
        I actualRequest = this.castRequest(typedRequest);
        QueueExecutor executor = new QueueExecutor();
        FutureReplyImpl<T> futureReply = new FutureReplyImpl<T>((Executor)((Object)executor), typedRequest);
        ReplyHandler replyHandler = futureReply.getReplyHandler();
        Cancellable requestContext = this.handler.receiveRequest(actualRequest, replyHandler);
        futureReply.setRemoteRequestContext(requestContext);
        futureReply.addNotifier(IoUtils.attachmentClosingNotifier(), executor);
        executor.runQueue();
        try {
            Object reply = futureReply.getInterruptibly();
            log.trace("Client.invoke() received reply \"%s\"", reply);
            return (T)reply;
        }
        catch (InterruptedException e) {
            try {
                futureReply.cancel();
                throw new IndeterminateOutcomeException("The current thread was interrupted before the result could be read");
            }
            catch (Throwable throwable) {
                Thread.currentThread().interrupt();
                throw throwable;
            }
        }
    }

    @Override
    public IoFuture<? extends O> send(I request) throws IOException {
        return this.send(request, this.replyClass);
    }

    @Override
    public <T extends O> IoFuture<? extends T> send(I request, Class<T> replyClass) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Client is not open");
        }
        log.trace("Client.send() sending request \"%s\"", request);
        I actualRequest = this.castRequest(request);
        FutureReplyImpl<T> futureReply = new FutureReplyImpl<T>(this.getExecutor(), replyClass);
        ReplyHandler replyHandler = futureReply.getReplyHandler();
        Cancellable requestContext = this.handler.receiveRequest(actualRequest, replyHandler);
        futureReply.setRemoteRequestContext(requestContext);
        return futureReply;
    }

    @Override
    public <T extends O> IoFuture<? extends T> sendTyped(TypedRequest<? extends I, T> typedRequest) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Client is not open");
        }
        log.trace("Client.send() sending request \"%s\"", typedRequest);
        I actualRequest = this.castRequest(typedRequest);
        FutureReplyImpl<T> futureReply = new FutureReplyImpl<T>(this.getExecutor(), typedRequest);
        ReplyHandler replyHandler = futureReply.getReplyHandler();
        Cancellable requestContext = this.handler.receiveRequest(actualRequest, replyHandler);
        futureReply.setRemoteRequestContext(requestContext);
        return futureReply;
    }

    private I castRequest(Object request) throws RemoteRequestException {
        try {
            return this.requestClass.cast(request);
        }
        catch (ClassCastException e) {
            throw new RemoteRequestException("Invalid request type sent (got <" + request.getClass().getName() + ">, expected <? extends " + this.requestClass.getName() + ">");
        }
    }

    public String toString() {
        return "client instance <" + Integer.toHexString(this.hashCode()) + ">";
    }

    RequestHandler getRequestHandler() {
        return this.handler;
    }

    Class<I> getRequestClass() {
        return this.requestClass;
    }

    Class<O> getReplyClass() {
        return this.replyClass;
    }
}

