/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.net.URI;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.LocalConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalConnectionProvider
implements ConnectionProvider {
    private final ConnectionProviderContext providerContext;

    public LocalConnectionProvider(ConnectionProviderContext providerContext) {
        this.providerContext = providerContext;
    }

    @Override
    public Cancellable connect(URI uri, OptionMap connectOptions, Result<ConnectionHandlerFactory> result, CallbackHandler callbackHandler) throws IllegalArgumentException {
        result.setResult((Object)new ConnectionHandlerFactory(){

            public ConnectionHandler createInstance(final ConnectionHandlerContext outboundContext) {
                final Holder h = new Holder();
                LocalConnectionProvider.this.providerContext.accept(new ConnectionHandlerFactory(){

                    public ConnectionHandler createInstance(ConnectionHandlerContext inboundContext) {
                        LocalConnectionHandler inboundHandler = new LocalConnectionHandler(inboundContext);
                        h.set(inboundHandler);
                        return new LocalConnectionHandler(outboundContext);
                    }
                });
                return h.get();
            }
        });
        return IoUtils.nullCancellable();
    }

    @Override
    public Void getProviderInterface() {
        return null;
    }

    private static final class Holder {
        private ConnectionHandler handler;

        private Holder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConnectionHandler get() {
            boolean intr = false;
            try {
                Holder holder = this;
                synchronized (holder) {
                    ConnectionHandler handler;
                    while ((handler = this.handler) == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            intr = true;
                        }
                    }
                    ConnectionHandler connectionHandler = handler;
                    return connectionHandler;
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(ConnectionHandler handler) {
            Holder holder = this;
            synchronized (holder) {
                this.handler = handler;
                this.notifyAll();
            }
        }
    }
}

