/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.remoting3.ClientContextImpl;
import org.jboss.remoting3.RemoteExecutionException;
import org.jboss.remoting3.RemoteRequestException;
import org.jboss.remoting3.RequestContextImpl;
import org.jboss.remoting3.RequestListener;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ReplyHandler;
import org.jboss.remoting3.spi.RequestHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalRequestHandler<I, O>
extends AbstractHandleableCloseable<RequestHandler>
implements RequestHandler {
    private final RequestListener<I, O> requestListener;
    private final ClientContextImpl clientContext;
    private final Class<I> requestClass;
    private final Class<O> replyClass;
    private final ClassLoader serviceClassLoader;
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting.listener");

    LocalRequestHandler(Executor executor, RequestListener<? super I, ? extends O> requestListener, ClientContextImpl clientContext, Class<I> requestClass, Class<O> replyClass, ClassLoader serviceClassLoader) {
        super(executor);
        this.serviceClassLoader = serviceClassLoader;
        this.requestListener = requestListener;
        this.clientContext = clientContext;
        this.requestClass = requestClass;
        this.replyClass = replyClass;
    }

    @Override
    public Cancellable receiveRequest(Object request, final ReplyHandler replyHandler) {
        final RequestContextImpl<O> context = new RequestContextImpl<O>(replyHandler, this.clientContext, this.replyClass, this.serviceClassLoader);
        try {
            I castRequest;
            try {
                castRequest = this.requestClass.cast(request);
            }
            catch (ClassCastException e) {
                SpiUtils.safeHandleException(replyHandler, new RemoteRequestException("Request is the wrong type; expected " + this.requestClass + " but got " + request.getClass()));
                return IoUtils.nullCancellable();
            }
            context.execute(new Runnable(){

                public void run() {
                    try {
                        LocalRequestHandler.this.requestListener.handleRequest(context, castRequest);
                    }
                    catch (RemoteExecutionException e) {
                        SpiUtils.safeHandleException(replyHandler, e);
                    }
                    catch (Throwable t) {
                        SpiUtils.safeHandleException(replyHandler, new RemoteExecutionException("Request handler threw an exception", t));
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            SpiUtils.safeHandleException(replyHandler, new RemoteRequestException("Execution was rejected (server may be too busy)", e));
            return IoUtils.nullCancellable();
        }
        return new Cancellable(){

            public Cancellable cancel() {
                context.cancel();
                return this;
            }
        };
    }

    @Override
    protected void closeAction() throws IOException {
        try {
            this.requestListener.handleClose();
        }
        catch (Throwable t) {
            log.error(t, "Unexpected exception in request listener handleClose() method", new Object[0]);
        }
    }

    public String toString() {
        return "local request handler <" + Integer.toHexString(this.hashCode()) + "> (request listener = " + String.valueOf(this.requestListener) + ")";
    }
}

