/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.AbstractClientMessageHandler;
import org.jboss.remoting3.remote.ClientAuthenticationHandler;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.SaslUtils;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientGreetingHandler
extends AbstractClientMessageHandler {
    private final RemoteConnection connection;
    private final Result<ConnectionHandlerFactory> factoryResult;
    private final CallbackHandler callbackHandler;

    ClientGreetingHandler(RemoteConnection connection, Result<ConnectionHandlerFactory> factoryResult, CallbackHandler callbackHandler) {
        super(connection, factoryResult);
        this.connection = connection;
        this.factoryResult = factoryResult;
        this.callbackHandler = callbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(ByteBuffer buffer) {
        ArrayList<String> saslMechs = new ArrayList<String>();
        String remoteEndpointName = "endpoint";
        switch (buffer.get()) {
            case 0: {
                SaslClient saslClient;
                block19: while (buffer.hasRemaining()) {
                    byte type = buffer.get();
                    int len = buffer.get() & 0xFF;
                    switch (type) {
                        case 0: {
                            buffer.get();
                            if (len <= 1) continue block19;
                            Buffers.skip((Buffer)buffer, (int)(len - 1));
                            continue block19;
                        }
                        case 1: {
                            saslMechs.add(Buffers.getModifiedUtf8((ByteBuffer)Buffers.slice((ByteBuffer)buffer, (int)len)));
                            continue block19;
                        }
                        case 2: {
                            remoteEndpointName = Buffers.getModifiedUtf8((ByteBuffer)Buffers.slice((ByteBuffer)buffer, (int)len));
                            continue block19;
                        }
                    }
                    Buffers.skip((Buffer)buffer, (int)len);
                }
                OptionMap optionMap = this.connection.getOptionMap();
                String userName = (String)optionMap.get(RemotingOptions.AUTH_USER_NAME);
                Map<String, Object> propertyMap = SaslUtils.createPropertyMap(optionMap);
                try {
                    saslClient = Sasl.createSaslClient(saslMechs.toArray(new String[saslMechs.size()]), userName, "remote", remoteEndpointName, propertyMap, this.callbackHandler);
                }
                catch (SaslException e) {
                    this.factoryResult.setException((IOException)e);
                    RemoteConnectionHandler.log.trace((Throwable)e, "Client connect authentication error", new Object[0]);
                    try {
                        this.remoteConnection.shutdownWritesBlocking();
                    }
                    catch (IOException e1) {
                        RemoteConnectionHandler.log.trace((Throwable)e1, "Failed to shutdown writes on %s", (Object)this.remoteConnection);
                    }
                    return;
                }
                String mechanismName = saslClient.getMechanismName();
                RemoteConnectionHandler.log.trace("Sasl mechanism selected: %s", (Object)mechanismName);
                ByteBuffer outBuf = this.connection.allocate();
                try {
                    outBuf.putInt(0);
                    outBuf.put((byte)12);
                    Buffers.putModifiedUtf8((ByteBuffer)outBuf, (String)mechanismName);
                    outBuf.flip();
                    this.connection.sendBlocking(outBuf);
                    this.connection.flushBlocking();
                }
                catch (IOException e) {
                    RemoteConnectionHandler.log.trace((Throwable)e, "Failed to send auth request on %s", (Object)this.remoteConnection);
                    this.factoryResult.setException(e);
                    return;
                }
                finally {
                    this.connection.free(outBuf);
                }
                this.connection.setMessageHandler(new ClientAuthenticationHandler(this.connection, saslClient, this.factoryResult));
                return;
            }
        }
        RemoteConnectionHandler.log.warn("Received invalid greeting packet on %s", (Object)this.remoteConnection);
        try {
            this.remoteConnection.shutdownWritesBlocking();
        }
        catch (IOException e1) {
            RemoteConnectionHandler.log.trace((Throwable)e1, "Failed to shutdown writes on %s", (Object)this.remoteConnection);
        }
    }
}

