/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.remote.ClientGreetingHandler;
import org.jboss.remoting3.remote.GreetingUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.Result;
import org.jboss.xnio.channels.ConnectedStreamChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientOpenListener
implements ChannelListener<ConnectedStreamChannel<InetSocketAddress>> {
    private final OptionMap optionMap;
    private final ConnectionProviderContext connectionProviderContext;
    private final Result<ConnectionHandlerFactory> factoryResult;
    private final CallbackHandler callbackHandler;

    ClientOpenListener(OptionMap optionMap, ConnectionProviderContext connectionProviderContext, Result<ConnectionHandlerFactory> factoryResult, CallbackHandler callbackHandler) {
        this.optionMap = optionMap;
        this.connectionProviderContext = connectionProviderContext;
        this.factoryResult = factoryResult;
        this.callbackHandler = callbackHandler;
    }

    public void handleEvent(ConnectedStreamChannel<InetSocketAddress> channel) {
        try {
            channel.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
        }
        catch (IOException e) {
            // empty catch block
        }
        final RemoteConnection connection = new RemoteConnection(this.connectionProviderContext.getExecutor(), channel, this.optionMap);
        final ByteBuffer buffer = connection.allocate();
        buffer.putInt(0);
        GreetingUtils.writeByte(buffer, (byte)0, (byte)0);
        buffer.flip();
        buffer.putInt(0, buffer.remaining() - 4);
        channel.getWriteSetter().set((ChannelListener)new ChannelListener<ConnectedStreamChannel<InetSocketAddress>>(){

            public void handleEvent(ConnectedStreamChannel<InetSocketAddress> channel) {
                while (buffer.hasRemaining()) {
                    int res;
                    try {
                        res = channel.write(buffer);
                    }
                    catch (IOException e1) {
                        RemoteConnectionHandler.log.trace((Throwable)e1, "Failed to send client greeting message", new Object[0]);
                        IoUtils.safeClose((Closeable)connection);
                        connection.free(buffer);
                        return;
                    }
                    if (res != 0) continue;
                    channel.resumeWrites();
                    return;
                }
                connection.free(buffer);
                channel.resumeReads();
            }
        });
        connection.setMessageHandler(new ClientGreetingHandler(connection, this.factoryResult, this.callbackHandler));
        channel.resumeWrites();
    }
}

