/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.NioByteOutput;
import org.jboss.marshalling.util.IntKeyMap;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.remote.OutboundClient;
import org.jboss.remoting3.remote.OutboundRequest;
import org.jboss.remoting3.remote.OutboundRequestBufferWriter;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ReplyHandler;
import org.jboss.remoting3.spi.RequestHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OutboundRequestHandler
extends AbstractHandleableCloseable<RequestHandler>
implements RequestHandler {
    private final OutboundClient outboundClient;

    OutboundRequestHandler(OutboundClient outboundClient) {
        super(outboundClient.getRemoteConnectionHandler().getConnectionContext().getConnectionProviderContext().getExecutor());
        this.outboundClient = outboundClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable receiveRequest(Object request, ReplyHandler replyHandler) {
        int rid;
        RemoteConnectionHandler connectionHandler = this.outboundClient.getRemoteConnectionHandler();
        OutboundRequest outboundRequest = new OutboundRequest(connectionHandler, replyHandler, this.outboundClient.getId());
        IntKeyMap<OutboundRequest> outboundRequests = connectionHandler.getOutboundRequests();
        Random random = connectionHandler.getRandom();
        IntKeyMap<OutboundRequest> intKeyMap = outboundRequests;
        synchronized (intKeyMap) {
            while (outboundRequests.containsKey(rid = random.nextInt())) {
            }
            outboundRequests.put(rid, (Object)outboundRequest);
        }
        NioByteOutput byteOutput = new NioByteOutput((NioByteOutput.BufferWriter)new OutboundRequestBufferWriter(outboundRequest, rid));
        try {
            RemoteConnectionHandler.log.trace("Starting sending request %s for %s", request, (Object)rid);
            Marshaller marshaller = connectionHandler.getMarshallerFactory().createMarshaller(connectionHandler.getMarshallingConfiguration());
            marshaller.start((ByteOutput)byteOutput);
            RemoteConnectionHandler old = RemoteConnectionHandler.setCurrent(connectionHandler);
            try {
                marshaller.writeObject(request);
                marshaller.finish();
            }
            finally {
                RemoteConnectionHandler.setCurrent(old);
            }
            RemoteConnectionHandler.log.trace("Finished sending request %s", request);
        }
        catch (IOException e) {
            RemoteConnectionHandler.log.trace((Throwable)e, "Got exception while marshalling request %s", request);
            SpiUtils.safeHandleException(replyHandler, e);
            Object old = outboundRequests;
            synchronized (old) {
                outboundRequests.remove(rid);
            }
            old = outboundRequest;
            synchronized (old) {
                outboundRequest.setState(OutboundRequest.State.CLOSED);
            }
            ByteBuffer buf = (ByteBuffer)connectionHandler.getBufferPool().allocate();
            buf.putInt(0);
            buf.put((byte)6);
            buf.putInt(rid);
            buf.flip();
            try {
                connectionHandler.getRemoteConnection().sendBlocking(buf);
            }
            catch (IOException e1) {
                RemoteConnectionHandler.log.trace("Send failed: %s", (Object)e1);
            }
        }
        return outboundRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        OutboundClient outboundClient = this.outboundClient;
        synchronized (outboundClient) {
            if (this.outboundClient.getState() == OutboundClient.State.CLOSED) {
                return;
            }
            this.outboundClient.setState(OutboundClient.State.CLOSED);
        }
        RemoteConnectionHandler connectionHandler = this.outboundClient.getRemoteConnectionHandler();
        Pool<ByteBuffer> bufferPool = connectionHandler.getBufferPool();
        ByteBuffer buf = (ByteBuffer)bufferPool.allocate();
        try {
            buf.putInt(0);
            buf.put((byte)4);
            buf.putInt(this.outboundClient.getId());
            buf.flip();
            connectionHandler.getRemoteConnection().sendBlocking(buf);
        }
        finally {
            bufferPool.free((Object)buf);
        }
    }

    @Override
    public HandleableCloseable.Key addCloseHandler(CloseHandler<? super RequestHandler> closeHandler) {
        return null;
    }
}

