/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Pool;
import org.jboss.xnio.channels.Channels;
import org.jboss.xnio.channels.ConnectedStreamChannel;
import org.jboss.xnio.channels.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteConnection
extends AbstractHandleableCloseable<RemoteConnection>
implements Closeable {
    private final ConnectedStreamChannel<InetSocketAddress> channel;
    private final Pool<ByteBuffer> bufferPool = Buffers.createHeapByteBufferAllocator((int)4096);
    private final MessageHandler.Setter messageHandlerSetter;
    private final OptionMap optionMap;
    private boolean readDone;
    private final Object writeLock = new Object();

    RemoteConnection(Executor executor, ConnectedStreamChannel<InetSocketAddress> channel, OptionMap optionMap) {
        super(executor);
        this.channel = channel;
        this.messageHandlerSetter = Channels.createMessageReader(channel, (OptionMap)optionMap);
        this.optionMap = optionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                this.shutdownWritesBlocking();
            }
            catch (IOException e) {
                this.readDone = true;
                this.writeLock.notifyAll();
                IoUtils.safeClose(this.channel);
                return;
            }
            while (!this.readDone) {
                try {
                    this.writeLock.wait();
                }
                catch (InterruptedException e) {
                    this.readDone = true;
                    this.writeLock.notifyAll();
                    IoUtils.safeClose(this.channel);
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        this.channel.close();
    }

    OptionMap getOptionMap() {
        return this.optionMap;
    }

    ConnectedStreamChannel<InetSocketAddress> getChannel() {
        return this.channel;
    }

    ByteBuffer allocate() {
        return (ByteBuffer)this.bufferPool.allocate();
    }

    void free(ByteBuffer buffer) {
        this.bufferPool.free((Object)buffer);
    }

    void setMessageHandler(MessageHandler handler) {
        this.messageHandlerSetter.set(handler);
    }

    void sendBlocking(ByteBuffer buffer) throws IOException {
        try {
            this.sendBlockingNoClose(buffer);
        }
        catch (IOException e) {
            IoUtils.safeClose((Closeable)this);
            throw e;
        }
        catch (RuntimeException e) {
            IoUtils.safeClose((Closeable)this);
            throw e;
        }
        catch (Error e) {
            IoUtils.safeClose((Closeable)this);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBlockingNoClose(ByteBuffer buffer) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            buffer.putInt(0, buffer.remaining() - 4);
            boolean intr = false;
            try {
                while (buffer.hasRemaining()) {
                    if (this.channel.write(buffer) != 0) continue;
                    try {
                        this.channel.awaitWritable();
                    }
                    catch (InterruptedIOException e) {
                        intr = Thread.interrupted();
                    }
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBlocking() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                while (!this.channel.flush()) {
                    this.channel.awaitWritable();
                }
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)this);
                throw e;
            }
            catch (RuntimeException e) {
                IoUtils.safeClose((Closeable)this);
                throw e;
            }
            catch (Error e) {
                IoUtils.safeClose((Closeable)this);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownWritesBlocking() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                while (!this.channel.shutdownWrites()) {
                    this.channel.awaitWritable();
                }
            }
            catch (IOException e) {
                IoUtils.safeClose(this.channel);
                throw e;
            }
            catch (RuntimeException e) {
                IoUtils.safeClose(this.channel);
                throw e;
            }
            catch (Error e) {
                IoUtils.safeClose(this.channel);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAuthReject(String msg) throws IOException {
        ByteBuffer buf = this.allocate();
        try {
            buf.putInt(0);
            buf.put((byte)16);
            Buffers.putModifiedUtf8((ByteBuffer)buf, (String)msg);
            buf.flip();
            this.sendBlocking(buf);
            this.flushBlocking();
        }
        finally {
            this.free(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAuthMessage(byte msgType, byte[] message) throws IOException {
        ByteBuffer buf = this.allocate();
        try {
            buf.putInt(0);
            buf.put(msgType);
            if (message != null) {
                buf.put(message);
            }
            buf.flip();
            this.sendBlocking(buf);
            this.flushBlocking();
        }
        finally {
            this.free(buf);
        }
    }

    void shutdownReads() throws IOException {
        this.channel.shutdownReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readDone() {
        Object object = this.writeLock;
        synchronized (object) {
            this.readDone = true;
            this.writeLock.notifyAll();
        }
    }
}

