/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.jboss.remoting3.remote.AbstractMessageHandler;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.ServerInitialAuthenticationHandler;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerGreetingHandler
extends AbstractMessageHandler {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final Set<String> saslMechs;
    private final ServerAuthenticationProvider provider;
    private final Map<String, Object> propertyMap;

    ServerGreetingHandler(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, Set<String> saslMechs, ServerAuthenticationProvider provider, Map<String, Object> propertyMap) {
        super(connection);
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.saslMechs = saslMechs;
        this.provider = provider;
        this.propertyMap = propertyMap;
    }

    public void handleMessage(ByteBuffer buffer) {
        switch (buffer.get()) {
            case 0: {
                block6: while (buffer.hasRemaining()) {
                    byte type = buffer.get();
                    int len = buffer.get() & 0xFF;
                    switch (type) {
                        case 0: {
                            buffer.get();
                            if (len <= 1) continue block6;
                            Buffers.skip((Buffer)buffer, (int)(len - 1));
                            continue block6;
                        }
                    }
                    Buffers.skip((Buffer)buffer, (int)len);
                }
                this.connection.setMessageHandler(new ServerInitialAuthenticationHandler(this.connection, this.propertyMap, this.saslMechs, this.provider, this.connectionProviderContext));
                return;
            }
        }
        RemoteConnectionHandler.log.warn("Server received invalid greeting message");
        IoUtils.safeClose((Closeable)this.connection);
    }
}

