/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.jboss.remoting3.remote.AbstractMessageHandler;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.SaslUtils;
import org.jboss.remoting3.remote.ServerAuthenticationHandler;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerInitialAuthenticationHandler
extends AbstractMessageHandler {
    private final RemoteConnection remoteConnection;
    private final Map<String, ?> saslPropertyMap;
    private final Set<String> allowedMechs;
    private final ServerAuthenticationProvider authenticationProvider;
    private final ConnectionProviderContext connectionProviderContext;

    ServerInitialAuthenticationHandler(RemoteConnection remoteConnection, Map<String, ?> saslPropertyMap, Set<String> allowedMechs, ServerAuthenticationProvider authenticationProvider, ConnectionProviderContext connectionProviderContext) {
        super(remoteConnection);
        this.remoteConnection = remoteConnection;
        this.saslPropertyMap = saslPropertyMap;
        this.allowedMechs = allowedMechs;
        this.authenticationProvider = authenticationProvider;
        this.connectionProviderContext = connectionProviderContext;
    }

    public void handleMessage(ByteBuffer buffer) {
        switch (buffer.get()) {
            case 12: {
                try {
                    String name = Buffers.getModifiedUtf8((ByteBuffer)buffer);
                    if (this.allowedMechs.contains(name)) {
                        RemoteConnectionHandler.log.trace("Selected SASL mechanism %s", (Object)name);
                        String realm = this.connectionProviderContext.getEndpoint().getName();
                        SaslServer server = Sasl.createSaslServer(name, "remote", realm, this.saslPropertyMap, this.authenticationProvider.getCallbackHandler());
                        this.remoteConnection.setMessageHandler(new ServerAuthenticationHandler(this.remoteConnection, server, this.connectionProviderContext));
                        RemoteConnectionHandler.log.trace("Sending initial challenge");
                        this.remoteConnection.sendAuthMessage((byte)13, server.evaluateResponse(SaslUtils.EMPTY));
                        return;
                    }
                    RemoteConnectionHandler.log.trace("Rejected invalid SASL mechanism %s", (Object)name);
                    this.remoteConnection.sendAuthReject("Invalid mechanism name");
                    return;
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)this.remoteConnection);
                    RemoteConnectionHandler.log.trace("Failed to send auth message: %s", (Object)e);
                    return;
                }
            }
        }
        RemoteConnectionHandler.log.warn("Server received invalid auth request message");
        IoUtils.safeClose((Closeable)this.remoteConnection);
    }
}

