/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServerFactory;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.GreetingUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.SaslUtils;
import org.jboss.remoting3.remote.ServerGreetingHandler;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ProtocolServiceType;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.Sequence;
import org.jboss.xnio.channels.ConnectedStreamChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerOpenListener
implements ChannelListener<ConnectedStreamChannel<InetSocketAddress>> {
    private final OptionMap optionMap;
    private final ConnectionProviderContext connectionProviderContext;

    ServerOpenListener(OptionMap optionMap, ConnectionProviderContext connectionProviderContext) {
        this.optionMap = optionMap;
        this.connectionProviderContext = connectionProviderContext;
    }

    public void handleEvent(ConnectedStreamChannel<InetSocketAddress> channel) {
        ServerAuthenticationProvider provider;
        try {
            channel.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
        }
        catch (IOException e) {
            // empty catch block
        }
        final RemoteConnection connection = new RemoteConnection(this.connectionProviderContext.getExecutor(), channel, this.optionMap);
        Sequence mechs = (Sequence)this.optionMap.get(Options.SASL_MECHANISMS);
        HashSet includes = mechs != null ? new HashSet(mechs) : null;
        LinkedHashSet<String> serverMechanisms = new LinkedHashSet<String>();
        Map<String, Object> propertyMap = SaslUtils.createPropertyMap(this.optionMap);
        Enumeration<SaslServerFactory> e = Sasl.getSaslServerFactories();
        while (e.hasMoreElements()) {
            SaslServerFactory saslServerFactory = e.nextElement();
            for (String name : saslServerFactory.getMechanismNames(propertyMap)) {
                if (includes != null && !includes.contains(name)) continue;
                serverMechanisms.add(name);
            }
        }
        final ByteBuffer buffer = connection.allocate();
        buffer.putInt(0);
        GreetingUtils.writeByte(buffer, (byte)0, (byte)0);
        for (String name : serverMechanisms) {
            GreetingUtils.writeString(buffer, (byte)1, name);
            RemoteConnectionHandler.log.trace("Offering SASL mechanism %s", (Object)name);
        }
        GreetingUtils.writeString(buffer, (byte)2, this.connectionProviderContext.getEndpoint().getName());
        buffer.flip();
        buffer.putInt(0, buffer.remaining() - 4);
        channel.getWriteSetter().set((ChannelListener)new ChannelListener<ConnectedStreamChannel<InetSocketAddress>>(){

            public void handleEvent(ConnectedStreamChannel<InetSocketAddress> channel) {
                while (buffer.hasRemaining()) {
                    int res;
                    try {
                        res = channel.write(buffer);
                    }
                    catch (IOException e1) {
                        RemoteConnectionHandler.log.trace((Throwable)e1, "Failed to send server greeting message", new Object[0]);
                        IoUtils.safeClose((Closeable)connection);
                        connection.free(buffer);
                        return;
                    }
                    if (res != 0) continue;
                    channel.resumeWrites();
                    return;
                }
                connection.free(buffer);
                channel.resumeReads();
            }
        });
        String authProvider = (String)this.optionMap.get(RemotingOptions.AUTHENTICATION_PROVIDER);
        if (authProvider == null) {
            IoUtils.safeClose((Closeable)connection);
        }
        if ((provider = this.connectionProviderContext.getProtocolServiceProvider(ProtocolServiceType.SERVER_AUTHENTICATION_PROVIDER, authProvider)) == null) {
            IoUtils.safeClose((Closeable)connection);
        }
        connection.setMessageHandler(new ServerGreetingHandler(connection, this.connectionProviderContext, serverMechanisms, provider, propertyMap));
        channel.resumeWrites();
    }
}

