/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.RemoteReadListener;
import org.jboss.remoting3.security.InetAddressPrincipal;
import org.jboss.remoting3.security.SimpleUserInfo;
import org.jboss.remoting3.security.UserPrincipal;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.sasl.SaslWrapper;

final class ClientConnectionOpenListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final CallbackHandler callbackHandler;
    private final AccessControlContext accessControlContext;
    private final OptionMap optionMap;
    private final Map<String, String> failedMechs = new LinkedHashMap<String, String>();
    private final Set<String> allowedMechs;
    private final Set<String> disallowedMechs;

    ClientConnectionOpenListener(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, CallbackHandler callbackHandler, AccessControlContext accessControlContext, OptionMap optionMap) {
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.callbackHandler = callbackHandler;
        this.accessControlContext = accessControlContext;
        this.optionMap = optionMap;
        Sequence allowedMechs = (Sequence)optionMap.get(Options.SASL_MECHANISMS);
        Sequence disallowedMechs = (Sequence)optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
        this.allowedMechs = allowedMechs == null ? null : new HashSet(allowedMechs);
        this.disallowedMechs = disallowedMechs == null ? Collections.emptySet() : new HashSet(disallowedMechs);
    }

    public void handleEvent(ConnectedMessageChannel channel) {
        this.connection.setReadListener(new Greeting(), true);
    }

    SaslException allMechanismsFailed() {
        StringBuilder b = new StringBuilder();
        b.append("Authentication failed: all available authentication mechanisms failed:");
        for (Map.Entry<String, String> entry : this.failedMechs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            b.append("\n   ").append(key).append(": ").append(value);
        }
        return new SaslException(b.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCapRequest(String remoteServerName) {
        RemoteLogger.client.trace("Client sending capabilities request");
        Pooled<ByteBuffer> pooledSendBuffer = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
            sendBuffer.put((byte)1);
            ProtocolUtils.writeByte(sendBuffer, 0, 1);
            String localEndpointName = this.connectionProviderContext.getEndpoint().getName();
            if (localEndpointName != null) {
                ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
            }
            ProtocolUtils.writeEmpty(sendBuffer, 4);
            ProtocolUtils.writeString(sendBuffer, (byte)5, Version.getVersionString());
            ProtocolUtils.writeInt(sendBuffer, 6, this.optionMap.get(RemotingOptions.MAX_INBOUND_CHANNELS, 40));
            ProtocolUtils.writeInt(sendBuffer, 7, this.optionMap.get(RemotingOptions.MAX_OUTBOUND_CHANNELS, 40));
            sendBuffer.flip();
            this.connection.setReadListener(new Capabilities(remoteServerName), true);
            this.connection.send(pooledSendBuffer);
            ok = true;
            return;
        }
        finally {
            if (!ok) {
                pooledSendBuffer.free();
            }
        }
    }

    private void saslDispose(SaslClient saslClient) {
        if (saslClient != null) {
            try {
                saslClient.dispose();
            }
            catch (SaslException e) {
                RemoteLogger.client.trace("Failure disposing of SaslClient", e);
            }
        }
    }

    static /* synthetic */ Set access$200(ClientConnectionOpenListener x0) {
        return x0.disallowedMechs;
    }

    static /* synthetic */ Set access$300(ClientConnectionOpenListener x0) {
        return x0.allowedMechs;
    }

    static /* synthetic */ OptionMap access$400(ClientConnectionOpenListener x0) {
        return x0.optionMap;
    }

    final class Authentication
    implements ChannelListener<ConnectedMessageChannel> {
        private final SaslClient saslClient;
        private final String serverName;
        private final String authorizationID;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        Authentication(SaslClient saslClient, String serverName, String authorizationID, String remoteEndpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.saslClient = saslClient;
            this.serverName = serverName;
            this.authorizationID = authorizationID;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void handleEvent(final ConnectedMessageChannel channel) {
            int res;
            ByteBuffer buffer;
            boolean free;
            Pooled<ByteBuffer> pooledBuffer;
            block27: {
                pooledBuffer = ClientConnectionOpenListener.this.connection.allocate();
                free = true;
                buffer = (ByteBuffer)pooledBuffer.getResource();
                Object object = ClientConnectionOpenListener.this.connection.getLock();
                // MONITORENTER : object
                try {
                    res = channel.receive(buffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                    // MONITOREXIT : object
                    if (!free) return;
                    pooledBuffer.free();
                    return;
                }
                if (res != 0) break block27;
                if (!free) return;
                pooledBuffer.free();
                return;
            }
            if (res == -1) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                // MONITOREXIT : object
                if (!free) return;
                pooledBuffer.free();
                return;
            }
            try {
                // MONITOREXIT : object
                buffer.flip();
                byte msgType = buffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        return;
                    }
                    case 3: {
                        RemoteLogger.client.trace("Client received authentication challenge");
                        channel.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    byte[] response;
                                    boolean clientComplete = Authentication.this.saslClient.isComplete();
                                    if (clientComplete) {
                                        ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                        return;
                                    }
                                    byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                    try {
                                        response = Authentication.this.saslClient.evaluateChallenge(challenge);
                                    }
                                    catch (Throwable e) {
                                        String mechanismName = Authentication.this.saslClient.getMechanismName();
                                        RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                        ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                        ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                        ClientConnectionOpenListener.this.sendCapRequest(Authentication.this.serverName);
                                        pooledBuffer.free();
                                        return;
                                    }
                                    RemoteLogger.client.trace("Client sending authentication response");
                                    Pooled<ByteBuffer> pooled = ClientConnectionOpenListener.this.connection.allocate();
                                    boolean ok = false;
                                    try {
                                        ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                                        sendBuffer.put((byte)4);
                                        sendBuffer.put(response);
                                        sendBuffer.flip();
                                        ClientConnectionOpenListener.this.connection.send(pooled);
                                        ok = true;
                                        channel.resumeReads();
                                    }
                                    finally {
                                        if (!ok) {
                                            pooled.free();
                                        }
                                    }
                                    return;
                                }
                                finally {
                                    pooledBuffer.free();
                                }
                            }
                        });
                        free = false;
                        return;
                    }
                    case 5: {
                        RemoteLogger.client.trace("Client received authentication complete");
                        channel.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Object qop;
                                    block11: {
                                        boolean clientComplete = Authentication.this.saslClient.isComplete();
                                        byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                        if (!clientComplete) {
                                            try {
                                                byte[] response = Authentication.this.saslClient.evaluateChallenge(challenge);
                                                if (response != null && response.length > 0) {
                                                    ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                                    ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                                    return;
                                                }
                                                if (Authentication.this.saslClient.isComplete()) break block11;
                                                ClientConnectionOpenListener.this.connection.handleException(new SaslException("Client not complete after processing auth complete message"));
                                            }
                                            catch (Throwable e) {
                                                String mechanismName = Authentication.this.saslClient.getMechanismName();
                                                RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                                ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                                ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                                ClientConnectionOpenListener.this.sendCapRequest(Authentication.this.serverName);
                                                return;
                                            }
                                            ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                            return;
                                        }
                                    }
                                    if ("auth-int".equals(qop = Authentication.this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) || "auth-conf".equals(qop)) {
                                        ClientConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create((SaslClient)Authentication.this.saslClient));
                                    }
                                    ConnectionHandlerFactory connectionHandlerFactory = new ConnectionHandlerFactory(){

                                        @Override
                                        public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                            Collection principals = Authentication.this.definePrincipals();
                                            RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ClientConnectionOpenListener.this.connection, principals, new SimpleUserInfo(principals), Authentication.this.maxInboundChannels, Authentication.this.maxOutboundChannels, Authentication.this.remoteEndpointName, Authentication.this.behavior);
                                            ClientConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ClientConnectionOpenListener.this.connection), false);
                                            ClientConnectionOpenListener.this.connection.getRemoteConnectionProvider().addConnectionHandler(connectionHandler);
                                            return connectionHandler;
                                        }
                                    };
                                    ClientConnectionOpenListener.this.connection.getResult().setResult((Object)connectionHandlerFactory);
                                    channel.resumeReads();
                                    return;
                                }
                                finally {
                                    pooledBuffer.free();
                                }
                            }
                        });
                        free = false;
                        return;
                    }
                    case 6: {
                        String mechanismName = this.saslClient.getMechanismName();
                        RemoteLogger.client.debugf("Client received authentication rejected for mechanism %s", mechanismName);
                        ClientConnectionOpenListener.this.failedMechs.put(mechanismName, "Server rejected authentication");
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                return;
            }
            finally {
                if (free) {
                    pooledBuffer.free();
                }
            }
        }

        private Collection<Principal> definePrincipals() {
            ConnectedMessageChannel channel;
            InetSocketAddress address;
            SSLSession session;
            LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
            SslChannel sslChannel = ClientConnectionOpenListener.this.connection.getSslChannel();
            if (sslChannel != null && (session = sslChannel.getSslSession()) != null) {
                try {
                    principals.add(session.getPeerPrincipal());
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
            }
            if (this.authorizationID != null) {
                principals.add(new UserPrincipal(this.authorizationID));
            }
            if ((address = (InetSocketAddress)(channel = ClientConnectionOpenListener.this.connection.getChannel()).getPeerAddress(InetSocketAddress.class)) != null) {
                principals.add(new InetAddressPrincipal(address.getAddress()));
            }
            return principals;
        }
    }

    final class StartTls
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;

        StartTls(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * Exception decompiling
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    final class Capabilities
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;

        Capabilities(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * Exception decompiling
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    final class Greeting
    implements ChannelListener<ConnectedMessageChannel> {
        Greeting() {
        }

        /*
         * Exception decompiling
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

