/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.SSLEngine;
import javax.security.sasl.SaslClientFactory;
import org.jboss.remoting3.remote.ClientConnectionOpenListener;
import org.jboss.remoting3.remote.DebuggingBufferPool;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteConnectionProviderMXBean;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.ServerConnectionOpenListener;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.NetworkServerProvider;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.xnio.AbstractConvertingIoFuture;
import org.xnio.BufferAllocator;
import org.xnio.Buffers;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Result;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.FramedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.JsseSslConnection;

class RemoteConnectionProvider
extends AbstractHandleableCloseable<ConnectionProvider>
implements ConnectionProvider {
    static final boolean USE_POOLING;
    static final boolean LEAK_DEBUGGING;
    static final Pool<ByteBuffer> GLOBAL_POOL;
    private final ProviderInterface providerInterface = new ProviderInterface();
    private final Xnio xnio;
    private final XnioWorker xnioWorker;
    private final ConnectionProviderContext connectionProviderContext;
    private final boolean sslRequired;
    private final boolean sslEnabled;
    private final Collection<Cancellable> pendingInboundConnections = Collections.synchronizedSet(new HashSet());
    private final Set<RemoteConnectionHandler> handlers = Collections.synchronizedSet(new HashSet());
    private final MBeanServer server;
    private final ObjectName objectName;

    RemoteConnectionProvider(OptionMap optionMap, ConnectionProviderContext connectionProviderContext) throws IOException {
        super(connectionProviderContext.getExecutor());
        this.xnio = connectionProviderContext.getXnio();
        this.sslRequired = optionMap.get(Options.SECURE, false);
        this.sslEnabled = optionMap.get(Options.SSL_ENABLED, true);
        this.xnioWorker = connectionProviderContext.getXnioWorker();
        this.connectionProviderContext = connectionProviderContext;
        MBeanServer server = null;
        ObjectName objectName = null;
        try {
            server = ManagementFactory.getPlatformMBeanServer();
            objectName = new ObjectName("jboss.remoting.handler", "name", connectionProviderContext.getEndpoint().getName() + "-" + this.hashCode());
            server.registerMBean(new RemoteConnectionProviderMXBean(){

                @Override
                public void dumpConnectionState() {
                    RemoteConnectionProvider.this.doDumpConnectionState();
                }

                @Override
                public String dumpConnectionStateToString() {
                    return RemoteConnectionProvider.this.doGetConnectionState();
                }
            }, objectName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = server;
        this.objectName = objectName;
    }

    private void doDumpConnectionState() {
        StringBuilder b = new StringBuilder();
        this.doGetConnectionState(b);
        RemoteLogger.log.info(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetConnectionState(StringBuilder b) {
        b.append("Connection state for ").append(this).append(':').append('\n');
        Set<RemoteConnectionHandler> set = this.handlers;
        synchronized (set) {
            for (RemoteConnectionHandler handler : this.handlers) {
                handler.dumpState(b);
            }
        }
    }

    private String doGetConnectionState() {
        StringBuilder b = new StringBuilder();
        this.doGetConnectionState(b);
        return b.toString();
    }

    @Override
    public Cancellable connect(final URI destination, final OptionMap connectOptions, Result<ConnectionHandlerFactory> result, final AuthenticationContext authenticationContext, final SaslClientFactory saslClientFactory) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Connection provider is closed");
        }
        Assert.checkNotNullParam((String)"destination", (Object)destination);
        Assert.checkNotNullParam((String)"connectOptions", (Object)connectOptions);
        Assert.checkNotNullParam((String)"result", result);
        Assert.checkNotNullParam((String)"authenticationContext", (Object)authenticationContext);
        Assert.checkNotNullParam((String)"saslClientFactory", (Object)saslClientFactory);
        RemoteLogger.log.tracef("Attempting to connect to \"%s\" with options %s", destination, connectOptions);
        final FutureResult cancellableResult = new FutureResult();
        cancellableResult.addCancelHandler(new Cancellable(){

            public Cancellable cancel() {
                cancellableResult.setCancelled();
                return this;
            }
        });
        IoFuture returnedFuture = cancellableResult.getIoFuture();
        returnedFuture.addNotifier(IoUtils.resultNotifier(), result);
        boolean sslCapable = this.sslEnabled;
        boolean useSsl = this.sslRequired || sslCapable && connectOptions.get(Options.SSL_ENABLED, true) && !connectOptions.get(Options.SECURE, false);
        ChannelListener<ConnectedStreamChannel> openListener = new ChannelListener<ConnectedStreamChannel>(){

            public void handleEvent(ConnectedStreamChannel channel) {
                Pool messageBufferPool;
                try {
                    channel.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Pool pool = messageBufferPool = USE_POOLING ? GLOBAL_POOL : Buffers.allocatedBufferPool((BufferAllocator)BufferAllocator.BYTE_BUFFER_ALLOCATOR, (int)8192);
                if (LEAK_DEBUGGING) {
                    messageBufferPool = new DebuggingBufferPool((Pool<ByteBuffer>)messageBufferPool);
                }
                FramedMessageChannel messageChannel = new FramedMessageChannel(channel, ByteBuffer.allocate(8196), ByteBuffer.allocate(8196));
                final RemoteConnection remoteConnection = new RemoteConnection((Pool<ByteBuffer>)messageBufferPool, channel, (ConnectedMessageChannel)messageChannel, connectOptions, RemoteConnectionProvider.this);
                cancellableResult.addCancelHandler(new Cancellable(){

                    public Cancellable cancel() {
                        RemoteConnectionHandler.sendCloseRequestBody(remoteConnection);
                        remoteConnection.handlePreAuthCloseRequest();
                        return this;
                    }
                });
                if (messageChannel.isOpen()) {
                    remoteConnection.setResult((Result<ConnectionHandlerFactory>)cancellableResult);
                    messageChannel.getWriteSetter().set(remoteConnection.getWriteListener());
                    ClientConnectionOpenListener openListener = new ClientConnectionOpenListener(destination, remoteConnection, RemoteConnectionProvider.this.connectionProviderContext, authenticationContext, saslClientFactory, connectOptions);
                    openListener.handleEvent((ConnectedMessageChannel)messageChannel);
                }
            }
        };
        AuthenticationContextConfigurationClient configurationClient = ClientConnectionOpenListener.AUTH_CONFIGURATION_CLIENT;
        AuthenticationConfiguration authenticationConfiguration = configurationClient.getAuthenticationConfiguration(destination, authenticationContext);
        InetSocketAddress address = configurationClient.getDestinationInetSocketAddress(destination, authenticationConfiguration, 0);
        final Object future = useSsl ? this.createSslConnection(destination, address, connectOptions, authenticationContext, openListener) : this.createConnection(destination, address, connectOptions, openListener);
        this.pendingInboundConnections.add((Cancellable)returnedFuture);
        future.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<ConnectedStreamChannel, FutureResult<ConnectionHandlerFactory>>(){

            public void handleFailed(IOException exception, FutureResult<ConnectionHandlerFactory> attachment) {
                attachment.setException(exception);
            }

            public void handleCancelled(FutureResult<ConnectionHandlerFactory> attachment) {
                attachment.setCancelled();
            }
        }, (Object)cancellableResult);
        returnedFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<ConnectionHandlerFactory, IoFuture<ConnectionHandlerFactory>>(){

            public void handleCancelled(IoFuture<ConnectionHandlerFactory> attachment) {
                RemoteConnectionProvider.this.pendingInboundConnections.remove(attachment);
                future.cancel();
            }

            public void handleFailed(IOException exception, IoFuture<ConnectionHandlerFactory> attachment) {
                RemoteConnectionProvider.this.pendingInboundConnections.remove(attachment);
            }

            public void handleDone(ConnectionHandlerFactory data, IoFuture<ConnectionHandlerFactory> attachment) {
                RemoteConnectionProvider.this.pendingInboundConnections.remove(attachment);
            }
        }, (Object)returnedFuture);
        return returnedFuture;
    }

    protected IoFuture<ConnectedStreamChannel> createConnection(URI uri, InetSocketAddress destination, OptionMap connectOptions, final ChannelListener<ConnectedStreamChannel> openListener) {
        AbstractConvertingIoFuture<ConnectedStreamChannel, StreamConnection> future = new AbstractConvertingIoFuture<ConnectedStreamChannel, StreamConnection>(this.xnioWorker.openStreamConnection((SocketAddress)destination, null, connectOptions)){

            protected ConnectedStreamChannel convert(StreamConnection streamConnection) throws IOException {
                return new AssembledConnectedStreamChannel((ConnectedChannel)streamConnection, (StreamSourceChannel)streamConnection.getSourceChannel(), (StreamSinkChannel)streamConnection.getSinkChannel());
            }
        };
        future.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<ConnectedStreamChannel, Void>(){

            public void handleDone(ConnectedStreamChannel data, Void attachment) {
                openListener.handleEvent((Channel)data);
            }
        }, null);
        return future;
    }

    protected IoFuture<ConnectedSslStreamChannel> createSslConnection(final URI uri, InetSocketAddress destination, OptionMap connectOptions, final AuthenticationContext authenticationContext, final ChannelListener<ConnectedStreamChannel> openListener) {
        AbstractConvertingIoFuture<ConnectedSslStreamChannel, StreamConnection> future = new AbstractConvertingIoFuture<ConnectedSslStreamChannel, StreamConnection>(this.xnioWorker.openStreamConnection((SocketAddress)destination, null, connectOptions)){

            protected ConnectedSslStreamChannel convert(StreamConnection streamConnection) throws IOException {
                SSLEngine engine;
                AuthenticationContextConfigurationClient configurationClient = ClientConnectionOpenListener.AUTH_CONFIGURATION_CLIENT;
                AuthenticationConfiguration configuration = configurationClient.getAuthenticationConfiguration(uri, authenticationContext);
                String realHost = configurationClient.getRealHost(uri, configuration);
                int realPort = configurationClient.getRealPort(uri, configuration);
                try {
                    engine = configurationClient.getSslContext(configuration).createSSLEngine(realHost, realPort);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
                JsseSslConnection sslConnection = new JsseSslConnection(streamConnection, engine);
                return new AssembledConnectedSslStreamChannel((SslChannel)sslConnection, (StreamSourceChannel)sslConnection.getSourceChannel(), (StreamSinkChannel)sslConnection.getSinkChannel());
            }
        };
        future.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<ConnectedSslStreamChannel, Void>(){

            public void handleDone(ConnectedSslStreamChannel data, Void attachment) {
                openListener.handleEvent((Channel)data);
            }
        }, null);
        return future;
    }

    @Override
    public Object getProviderInterface() {
        return this.providerInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() {
        try {
            Cancellable[] cancellableArray = this.pendingInboundConnections;
            synchronized (this.pendingInboundConnections) {
                Cancellable[] cancellables = this.pendingInboundConnections.toArray(new Cancellable[this.pendingInboundConnections.size()]);
                this.pendingInboundConnections.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (Cancellable pendingConnection : cancellables) {
                    pendingConnection.cancel();
                }
                this.closeComplete();
            }
        }
        finally {
            if (this.server != null && this.objectName != null) {
                try {
                    this.server.unregisterMBean(this.objectName);
                }
                catch (Throwable throwable) {}
            }
        }
        {
            return;
        }
    }

    void addConnectionHandler(RemoteConnectionHandler connectionHandler) {
        this.handlers.add(connectionHandler);
    }

    void removeConnectionHandler(RemoteConnectionHandler connectionHandler) {
        this.handlers.remove(connectionHandler);
    }

    @Override
    protected Executor getExecutor() {
        return super.getExecutor();
    }

    public String toString() {
        return String.format("Remoting remote connection provider %x for %s", this.hashCode(), this.connectionProviderContext.getEndpoint());
    }

    protected XnioWorker getXnioWorker() {
        return this.xnioWorker;
    }

    public ConnectionProviderContext getConnectionProviderContext() {
        return this.connectionProviderContext;
    }

    static {
        boolean usePooling = true;
        boolean leakDebugging = false;
        try {
            usePooling = Boolean.parseBoolean(System.getProperty("jboss.remoting.pooled-buffers", "true"));
            leakDebugging = Boolean.parseBoolean(System.getProperty("jboss.remoting.debug-buffer-leaks", "false"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        USE_POOLING = usePooling;
        LEAK_DEBUGGING = leakDebugging;
        GLOBAL_POOL = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 0x200000);
    }

    private final class AcceptListener
    implements ChannelListener<AcceptingChannel<? extends ConnectedStreamChannel>> {
        private final OptionMap serverOptionMap;
        private final SaslAuthenticationFactory saslAuthenticationFactory;
        private final Pool<ByteBuffer> messageBufferPool;

        AcceptListener(OptionMap serverOptionMap, SaslAuthenticationFactory saslAuthenticationFactory) {
            this.serverOptionMap = serverOptionMap;
            this.saslAuthenticationFactory = saslAuthenticationFactory;
            Pool pool = USE_POOLING ? GLOBAL_POOL : Buffers.allocatedBufferPool((BufferAllocator)BufferAllocator.BYTE_BUFFER_ALLOCATOR, (int)8192);
            this.messageBufferPool = LEAK_DEBUGGING ? new DebuggingBufferPool((Pool<ByteBuffer>)pool) : pool;
        }

        public void handleEvent(AcceptingChannel<? extends ConnectedStreamChannel> channel) {
            ConnectedStreamChannel accepted;
            try {
                accepted = (ConnectedStreamChannel)channel.accept();
                if (accepted == null) {
                    return;
                }
            }
            catch (IOException e) {
                RemoteLogger.log.failedToAccept(e);
                return;
            }
            try {
                accepted.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
            }
            catch (IOException e) {
                // empty catch block
            }
            FramedMessageChannel messageChannel = new FramedMessageChannel(accepted, ByteBuffer.allocate(8196), ByteBuffer.allocate(8196));
            RemoteConnection connection = new RemoteConnection(this.messageBufferPool, accepted, (ConnectedMessageChannel)messageChannel, this.serverOptionMap, RemoteConnectionProvider.this);
            ServerConnectionOpenListener openListener = new ServerConnectionOpenListener(connection, RemoteConnectionProvider.this.connectionProviderContext, this.saslAuthenticationFactory, this.serverOptionMap);
            messageChannel.getWriteSetter().set(connection.getWriteListener());
            RemoteLogger.log.tracef("Accepted connection from %s to %s", accepted.getPeerAddress(), accepted.getLocalAddress());
            openListener.handleEvent((ConnectedMessageChannel)messageChannel);
        }
    }

    final class ProviderInterface
    implements NetworkServerProvider {
        ProviderInterface() {
        }

        @Override
        public AcceptingChannel<? extends ConnectedStreamChannel> createServer(SocketAddress bindAddress, OptionMap optionMap, SaslAuthenticationFactory saslAuthenticationFactory) throws IOException {
            boolean sslCapable = RemoteConnectionProvider.this.sslEnabled;
            AcceptListener acceptListener = new AcceptListener(optionMap, saslAuthenticationFactory);
            AcceptingChannel result = sslCapable && optionMap.get(Options.SSL_ENABLED, true) ? RemoteConnectionProvider.this.xnioWorker.createStreamServer(bindAddress, (ChannelListener)acceptListener, optionMap) : RemoteConnectionProvider.this.xnioWorker.createStreamServer(bindAddress, (ChannelListener)acceptListener, optionMap);
            RemoteConnectionProvider.this.addCloseHandler((closed, exception) -> IoUtils.safeClose((Closeable)result));
            result.resumeAccepts();
            return result;
        }
    }
}

