/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

final class ConnectionKey {
    private final String protocol;
    private final String abstractType;
    private final String abstractTypeAuthority;
    private final AuthenticationConfiguration configuration;
    private final SecurityFactory<SSLContext> sslContextFactory;
    private final int hashCode;

    ConnectionKey(String protocol, String abstractType, String abstractTypeAuthority, AuthenticationConfiguration configuration, SecurityFactory<SSLContext> sslContextFactory) {
        this.protocol = protocol;
        this.abstractType = abstractType;
        this.abstractTypeAuthority = abstractTypeAuthority;
        this.configuration = configuration;
        this.sslContextFactory = sslContextFactory;
        this.hashCode = Objects.hash(protocol, abstractType, abstractTypeAuthority, configuration, sslContextFactory);
    }

    String getProtocol() {
        return this.protocol;
    }

    String getAbstractType() {
        return this.abstractType;
    }

    String getAbstractTypeAuthority() {
        return this.abstractTypeAuthority;
    }

    AuthenticationConfiguration getConfiguration() {
        return this.configuration;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof ConnectionKey && this.equals((ConnectionKey)obj);
    }

    boolean equals(ConnectionKey other) {
        return other != null && this.hashCode == other.hashCode && this.protocol.equals(other.protocol) && Objects.equals(this.abstractType, other.abstractType) && Objects.equals(this.abstractTypeAuthority, other.abstractTypeAuthority) && this.configuration.equals(other.configuration);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Connection key for \"").append(this.protocol).append('\"');
        if (this.abstractType != null) {
            b.append(" (abstract type \"").append(this.abstractType);
            if (this.abstractTypeAuthority != null) {
                b.append('.').append(this.abstractTypeAuthority);
            }
            b.append('\"');
        }
        b.append(" config=").append(this.configuration).append(" ssl=").append(this.sslContextFactory);
        return b.toString();
    }
}

