/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.ConnectionImpl;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.PeerIdentity;
import org.wildfly.security.auth.client.PeerIdentityContext;
import org.wildfly.security.auth.principal.AnonymousPrincipal;

public final class ConnectionPeerIdentityContext
extends PeerIdentityContext {
    private static final byte[] NO_BYTES = new byte[0];
    private final ConnectionImpl connection;
    private final Collection<String> offeredMechanisms;
    private final ConnectionPeerIdentity anonymousIdentity;
    private final ConnectionPeerIdentity connectionIdentity;
    private final IntIndexHashMap<Authentication> authMap = new IntIndexHashMap<Authentication>(Authentication::getId);
    private static final AuthenticationContextConfigurationClient CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);
    private static final int WAITING = 0;
    private static final int CHALLENGE = 1;
    private static final int SUCCESS = 2;
    private static final int REJECT = 3;
    private static final int DELETE = 4;
    private static final int CLOSED = 5;

    ConnectionPeerIdentityContext(ConnectionImpl connection, Collection<String> offeredMechanisms) {
        this.connection = connection;
        this.offeredMechanisms = offeredMechanisms;
        this.anonymousIdentity = (ConnectionPeerIdentity)((Object)this.constructIdentity(conf -> new ConnectionPeerIdentity((PeerIdentity.Configuration)conf, (Principal)AnonymousPrincipal.getInstance(), 0, connection)));
        this.connectionIdentity = (ConnectionPeerIdentity)((Object)this.constructIdentity(conf -> new ConnectionPeerIdentity((PeerIdentity.Configuration)conf, connection.getPrincipal(), 1, connection)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPeerIdentity authenticate(AuthenticationConfiguration configuration) throws AuthenticationException {
        Authentication authentication;
        int id;
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        ConnectionImpl connection = this.connection;
        if (configuration.equals(connection.getAuthenticationConfiguration())) {
            return this.connectionIdentity;
        }
        if (!connection.supportsRemoteAuth()) {
            throw Messages.log.authenticationNotSupported();
        }
        AuthenticationContextConfigurationClient client = CLIENT;
        IntIndexHashMap<Authentication> authMap = this.authMap;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((id = random.nextInt()) == 0 || id == 1 || authMap.containsKey(id) || authMap.putIfAbsent(authentication = new Authentication(id)) != null) {
        }
        int finalId = id;
        boolean intr = Thread.currentThread().isInterrupted();
        if (intr) {
            throw Messages.log.authenticationInterrupted();
        }
        try {
            String triedStr;
            Principal principal = client.getPrincipal(configuration);
            ConnectionHandler connectionHandler = connection.getConnectionHandler();
            LinkedHashSet<String> mechanisms = new LinkedHashSet<String>(this.offeredMechanisms);
            block24: while (!mechanisms.isEmpty()) {
                byte[] challenge;
                int status;
                byte[] response;
                SaslClient saslClient;
                try {
                    saslClient = client.createSaslClient(connection.getPeerURI(), configuration, mechanisms);
                }
                catch (SaslException e) {
                    throw Messages.log.authenticationNoSaslClient(e);
                }
                if (saslClient == null) break;
                try {
                    response = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(NO_BYTES) : null;
                    connectionHandler.sendAuthRequest(id, saslClient.getMechanismName(), response);
                }
                catch (IOException e) {
                    authMap.remove(authentication);
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    throw Messages.log.authenticationExceptionIo(e);
                }
                while (true) {
                    Authentication authentication2 = authentication;
                    synchronized (authentication2) {
                        status = authentication.getStatus();
                        while (status == 0) {
                            try {
                                authentication.wait();
                            }
                            catch (InterruptedException e) {
                                intr = true;
                            }
                            status = authentication.getStatus();
                        }
                        challenge = authentication.getSaslBytes();
                        authentication.setStatus(0);
                        authentication.setSaslBytes(null);
                    }
                    if (status != 1) break;
                    try {
                        response = saslClient.evaluateChallenge(challenge);
                    }
                    catch (SaslException e) {
                        Messages.log.tracef(e, "Mechanism failed (client): \"%s\"", saslClient.getMechanismName());
                        mechanisms.remove(saslClient.getMechanismName());
                        ConnectionPeerIdentityContext.safeDispose(saslClient);
                        continue block24;
                    }
                    try {
                        connectionHandler.sendAuthResponse(id, response);
                    }
                    catch (IOException e) {
                        throw Messages.log.authenticationExceptionIo(e);
                    }
                }
                if (status == 2) {
                    if (challenge != null) {
                        try {
                            response = saslClient.evaluateChallenge(challenge);
                        }
                        catch (SaslException e) {
                            Messages.log.tracef(e, "Mechanism failed (client, possibly failed to verify server): \"%s\"", saslClient.getMechanismName());
                            mechanisms.remove(saslClient.getMechanismName());
                            ConnectionPeerIdentityContext.safeDispose(saslClient);
                            continue;
                        }
                        if (response != null) {
                            try {
                                connectionHandler.sendAuthDelete(id);
                            }
                            catch (IOException ignored) {
                                Messages.log.trace("Send failed", ignored);
                            }
                            ConnectionPeerIdentityContext.safeDispose(saslClient);
                            throw Messages.log.authenticationExtraResponse();
                        }
                    }
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    ConnectionPeerIdentity ignored = (ConnectionPeerIdentity)((Object)this.constructIdentity(conf -> new ConnectionPeerIdentity((PeerIdentity.Configuration)conf, principal, finalId, connection)));
                    return ignored;
                }
                if (status == 3) {
                    try {
                        connectionHandler.sendAuthDelete(id);
                    }
                    catch (IOException ignored) {
                        Messages.log.trace("Send failed", ignored);
                    }
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    throw Messages.log.serverRejectedAuthentication();
                }
                if (status == 5) {
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    throw Messages.log.authenticationExceptionClosed();
                }
                if (status == 4) {
                    ConnectionPeerIdentityContext.safeDispose(saslClient);
                    throw Messages.log.serverRejectedAuthentication();
                }
                throw Assert.unreachableCode();
            }
            HashSet<String> triedMechs = new HashSet<String>(this.offeredMechanisms);
            triedMechs.removeAll(mechanisms);
            Iterator iterator = triedMechs.iterator();
            if (iterator.hasNext()) {
                StringBuilder b = new StringBuilder();
                b.append((String)iterator.next());
                while (iterator.hasNext()) {
                    b.append(',').append((String)iterator.next());
                }
                triedStr = b.toString();
            } else {
                triedStr = "(none)";
            }
            throw Messages.log.noAuthMechanismsLeft(triedStr);
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void safeDispose(SaslClient saslClient) {
        try {
            saslClient.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveChallenge(int id, byte[] challenge) {
        Authentication authentication = this.authMap.get(id);
        if (authentication != null) {
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setSaslBytes(challenge);
                authentication.setStatus(1);
                authentication.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveSuccess(int id, byte[] challenge) {
        Authentication authentication = this.authMap.get(id);
        if (authentication != null) {
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setSaslBytes(challenge);
                authentication.setStatus(2);
                authentication.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveReject(int id) {
        Authentication authentication = this.authMap.get(id);
        if (authentication != null) {
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setStatus(3);
                authentication.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveDeleteAck(int id) {
        Authentication authentication = this.authMap.removeKey(id);
        if (authentication != null) {
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setStatus(4);
                authentication.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed() {
        Iterator<Authentication> iterator = this.authMap.iterator();
        while (iterator.hasNext()) {
            Authentication authentication = iterator.next();
            iterator.remove();
            Authentication authentication2 = authentication;
            synchronized (authentication2) {
                authentication.setStatus(5);
                authentication.notify();
            }
        }
    }

    public ConnectionPeerIdentity getAnonymousIdentity() {
        return this.anonymousIdentity;
    }

    ConnectionPeerIdentity getConnectionIdentity() {
        return this.connectionIdentity;
    }

    public ConnectionPeerIdentity getCurrentIdentity() {
        return (ConnectionPeerIdentity)super.getCurrentIdentity();
    }

    static final class Authentication {
        private final int id;
        private byte[] saslBytes;
        private int status;

        Authentication(int id) {
            this.id = id;
        }

        int getId() {
            return this.id;
        }

        byte[] getSaslBytes() {
            return this.saslBytes;
        }

        void setSaslBytes(byte[] saslBytes) {
            this.saslBytes = saslBytes;
        }

        int getStatus() {
            return this.status;
        }

        void setStatus(int status) {
            this.status = status;
        }
    }
}

