/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.URI;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.Version;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.remote.MessageReader;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteReadListener;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.sasl.util.ServerNameSaslClientFactory;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;
import org.xnio.ssl.SslConnection;

final class ClientConnectionOpenListener
implements ChannelListener<ConduitStreamSourceChannel> {
    private final URI uri;
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final AuthenticationConfiguration configuration;
    private final UnaryOperator<SaslClientFactory> saslClientFactoryOperator;
    private final Collection<String> serverMechs;
    private final OptionMap optionMap;
    private final Map<String, String> failedMechs = new LinkedHashMap<String, String>();
    private final Set<String> allowedMechs;
    private final Set<String> disallowedMechs;
    static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    ClientConnectionOpenListener(URI uri, RemoteConnection connection, ConnectionProviderContext connectionProviderContext, AuthenticationConfiguration configuration, UnaryOperator<SaslClientFactory> saslClientFactoryOperator, Collection<String> serverMechs, OptionMap optionMap) {
        this.uri = uri;
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.configuration = configuration;
        this.saslClientFactoryOperator = saslClientFactoryOperator;
        this.serverMechs = serverMechs;
        this.optionMap = optionMap;
        Sequence allowedMechs = (Sequence)optionMap.get(Options.SASL_MECHANISMS);
        Sequence disallowedMechs = (Sequence)optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
        this.allowedMechs = allowedMechs == null ? null : new HashSet(allowedMechs);
        this.disallowedMechs = disallowedMechs == null ? Collections.emptySet() : new HashSet(disallowedMechs);
    }

    public void handleEvent(ConduitStreamSourceChannel channel) {
        this.connection.setReadListener(new Greeting(), true);
    }

    SaslException allMechanismsFailed() {
        StringBuilder b = new StringBuilder();
        b.append("Authentication failed: all available authentication mechanisms failed:");
        for (Map.Entry<String, String> entry : this.failedMechs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            b.append("\n   ").append(key).append(": ").append(value);
        }
        return new SaslException(b.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCapRequest(String remoteServerName) {
        Messages.client.trace("Client sending capabilities request");
        Pooled<ByteBuffer> pooledSendBuffer = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
            sendBuffer.put((byte)1);
            ProtocolUtils.writeByte(sendBuffer, 0, 1);
            String localEndpointName = this.connectionProviderContext.getEndpoint().getName();
            if (localEndpointName != null) {
                ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
            }
            ProtocolUtils.writeEmpty(sendBuffer, 4);
            ProtocolUtils.writeString(sendBuffer, (byte)5, Version.getVersionString());
            ProtocolUtils.writeInt(sendBuffer, 6, this.optionMap.get(RemotingOptions.MAX_INBOUND_CHANNELS, 40));
            ProtocolUtils.writeInt(sendBuffer, 7, this.optionMap.get(RemotingOptions.MAX_OUTBOUND_CHANNELS, 40));
            ProtocolUtils.writeEmpty(sendBuffer, 8);
            Collection<String> serverMechs = this.serverMechs;
            if (serverMechs != null) {
                for (String name : serverMechs) {
                    ProtocolUtils.writeString(sendBuffer, (byte)1, name);
                }
            }
            sendBuffer.flip();
            this.connection.setReadListener(new Capabilities(remoteServerName, this.uri), true);
            this.connection.send(pooledSendBuffer);
            ok = true;
            return;
        }
        finally {
            if (!ok) {
                pooledSendBuffer.free();
            }
        }
    }

    private void saslDispose(SaslClient saslClient) {
        if (saslClient != null) {
            try {
                saslClient.dispose();
            }
            catch (SaslException e) {
                Messages.client.trace("Failure disposing of SaslClient", e);
            }
        }
    }

    private static <T> UnaryOperator<T> and(UnaryOperator<T> first, UnaryOperator<T> second) {
        return t -> second.apply(first.apply(t));
    }

    final class Authentication
    implements ChannelListener<ConduitStreamSourceChannel> {
        private final SaslClient saslClient;
        private final String serverName;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;
        private final boolean authCap;

        Authentication(SaslClient saslClient, String serverName, String endpointName, int behavior, int maxInboundChannels, int maxOutboundChannels, boolean authCap) {
            this.saslClient = saslClient;
            this.serverName = serverName;
            this.behavior = behavior;
            this.remoteEndpointName = endpointName;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
            this.authCap = authCap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConduitStreamSourceChannel channel) {
            Pooled<ByteBuffer> message;
            MessageReader messageReader = ClientConnectionOpenListener.this.connection.getMessageReader();
            try {
                message = messageReader.getMessage();
            }
            catch (IOException e) {
                ClientConnectionOpenListener.this.connection.handleException(e);
                return;
            }
            if (message == MessageReader.EOF_MARKER) {
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.abruptClose(ClientConnectionOpenListener.this.connection));
                ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                return;
            }
            if (message == null) {
                return;
            }
            boolean free = true;
            try {
                ByteBuffer buffer = (ByteBuffer)message.getResource();
                byte msgType = buffer.get();
                switch (msgType) {
                    case -16: {
                        Messages.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        Messages.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        Messages.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        return;
                    }
                    case 3: {
                        Messages.client.trace("Client received authentication challenge");
                        messageReader.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(() -> {
                            try {
                                byte[] response;
                                boolean clientComplete = this.saslClient.isComplete();
                                if (clientComplete) {
                                    ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                    return;
                                }
                                byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                try {
                                    response = this.saslClient.evaluateChallenge(challenge);
                                }
                                catch (Throwable e) {
                                    String mechanismName = this.saslClient.getMechanismName();
                                    Messages.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                    ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                    ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                                    ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                                    message.free();
                                    return;
                                }
                                Messages.client.trace("Client sending authentication response");
                                Pooled<ByteBuffer> pooled = ClientConnectionOpenListener.this.connection.allocate();
                                boolean ok = false;
                                try {
                                    ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                                    sendBuffer.put((byte)4);
                                    sendBuffer.put(response);
                                    sendBuffer.flip();
                                    ClientConnectionOpenListener.this.connection.send(pooled);
                                    ok = true;
                                    messageReader.resumeReads();
                                }
                                finally {
                                    if (!ok) {
                                        pooled.free();
                                    }
                                }
                                return;
                            }
                            finally {
                                message.free();
                            }
                        });
                        free = false;
                        return;
                    }
                    case 5: {
                        Messages.client.trace("Client received authentication complete");
                        messageReader.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(() -> {
                            try {
                                Object qop;
                                block11: {
                                    boolean clientComplete = this.saslClient.isComplete();
                                    byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                    if (!clientComplete) {
                                        try {
                                            byte[] response = this.saslClient.evaluateChallenge(challenge);
                                            if (response != null && response.length > 0) {
                                                ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                                ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                                                return;
                                            }
                                            if (this.saslClient.isComplete()) break block11;
                                            ClientConnectionOpenListener.this.connection.handleException(new SaslException("Client not complete after processing auth complete message"));
                                        }
                                        catch (Throwable e) {
                                            String mechanismName = this.saslClient.getMechanismName();
                                            Messages.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                            ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                            ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                                            ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                                            return;
                                        }
                                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                                        return;
                                    }
                                }
                                if ("auth-int".equals(qop = this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) || "auth-conf".equals(qop)) {
                                    ClientConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create((SaslClient)this.saslClient));
                                }
                                ConnectionHandlerFactory connectionHandlerFactory = connectionContext -> {
                                    RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ClientConnectionOpenListener.this.connection, this.maxInboundChannels, this.maxOutboundChannels, this.remoteEndpointName, this.behavior, this.authCap);
                                    ClientConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ClientConnectionOpenListener.this.connection), false);
                                    ClientConnectionOpenListener.this.connection.getRemoteConnectionProvider().addConnectionHandler(connectionHandler);
                                    return connectionHandler;
                                };
                                ClientConnectionOpenListener.this.connection.getResult().setResult((Object)connectionHandlerFactory);
                                messageReader.resumeReads();
                                return;
                            }
                            finally {
                                message.free();
                            }
                        });
                        free = false;
                        return;
                    }
                    case 6: {
                        String mechanismName = this.saslClient.getMechanismName();
                        Messages.client.debugf("Client received authentication rejected for mechanism %s", mechanismName);
                        ClientConnectionOpenListener.this.failedMechs.put(mechanismName, "Server rejected authentication");
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                        return;
                    }
                }
                Messages.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                return;
            }
            finally {
                if (free) {
                    message.free();
                }
            }
        }
    }

    final class StartTls
    implements ChannelListener<ConduitStreamSourceChannel> {
        private final String remoteServerName;

        StartTls(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConduitStreamSourceChannel channel) {
            Pooled<ByteBuffer> message;
            try {
                message = ClientConnectionOpenListener.this.connection.getMessageReader().getMessage();
            }
            catch (IOException e) {
                ClientConnectionOpenListener.this.connection.handleException(e);
                return;
            }
            if (message == MessageReader.EOF_MARKER) {
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.abruptClose(ClientConnectionOpenListener.this.connection));
                return;
            }
            if (message == null) {
                return;
            }
            try {
                ByteBuffer receiveBuffer = (ByteBuffer)message.getResource();
                Messages.client.tracef("Received %s", receiveBuffer);
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        Messages.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        Messages.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        Messages.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 7: {
                        Messages.client.trace("Client received STARTTLS response");
                        if (ClientConnectionOpenListener.this.connection.getConnection() instanceof SslConnection) {
                            ClientConnectionOpenListener.this.connection.send(RemoteConnection.STARTTLS_SENTINEL);
                            ClientConnectionOpenListener.this.sendCapRequest(this.remoteServerName);
                            return;
                        }
                        ClientConnectionOpenListener.this.connection.handleException(new IOException("Client starting STARTTLS but channel doesn't support SSL"));
                        return;
                    }
                }
                Messages.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                message.free();
            }
        }
    }

    final class Capabilities
    implements ChannelListener<ConduitStreamSourceChannel> {
        private final String remoteServerName;
        private final URI uri;

        Capabilities(String remoteServerName, URI uri) {
            this.remoteServerName = remoteServerName;
            this.uri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleEvent(ConduitStreamSourceChannel channel) {
            Pooled<ByteBuffer> message;
            try {
                message = ClientConnectionOpenListener.this.connection.getMessageReader().getMessage();
            }
            catch (IOException e) {
                ClientConnectionOpenListener.this.connection.handleException(e);
                return;
            }
            if (message == MessageReader.EOF_MARKER) {
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.abruptClose(ClientConnectionOpenListener.this.connection));
                return;
            }
            if (message == null) {
                return;
            }
            try {
                ByteBuffer receiveBuffer = (ByteBuffer)message.getResource();
                boolean starttls = false;
                LinkedHashSet<String> serverSaslMechs = new LinkedHashSet<String>();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        Messages.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        Messages.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        Messages.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 1: {
                        SaslClient saslClient;
                        Messages.client.trace("Client received capabilities response");
                        String remoteEndpointName = null;
                        int version = 1;
                        int behavior = 2;
                        boolean useDefaultChannels = true;
                        int channelsIn = 40;
                        int channelsOut = 40;
                        boolean authCap = false;
                        block37: while (receiveBuffer.hasRemaining()) {
                            byte type = receiveBuffer.get();
                            int len = receiveBuffer.get() & 0xFF;
                            ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                            switch (type) {
                                case 0: {
                                    version = data.get() & 0xFF;
                                    Messages.client.tracef("Client received capability: version %d", version & 0xFF);
                                    continue block37;
                                }
                                case 1: {
                                    String mechName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    Messages.client.tracef("Client received capability: SASL mechanism %s", mechName);
                                    if (ClientConnectionOpenListener.this.failedMechs.containsKey(mechName) || ClientConnectionOpenListener.this.disallowedMechs.contains(mechName) || ClientConnectionOpenListener.this.allowedMechs != null && !ClientConnectionOpenListener.this.allowedMechs.contains(mechName)) continue block37;
                                    Messages.client.tracef("SASL mechanism %s added to allowed set", mechName);
                                    serverSaslMechs.add(mechName);
                                    continue block37;
                                }
                                case 2: {
                                    Messages.client.trace("Client received capability: STARTTLS");
                                    starttls = true;
                                    continue block37;
                                }
                                case 3: {
                                    remoteEndpointName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    Messages.client.tracef("Client received capability: remote endpoint name \"%s\"", remoteEndpointName);
                                    continue block37;
                                }
                                case 4: {
                                    behavior |= 1;
                                    behavior &= 0xFFFFFFFD;
                                    Messages.client.tracef("Client received capability: message close protocol supported", new Object[0]);
                                    continue block37;
                                }
                                case 5: {
                                    behavior &= 0xFFFFFFFD;
                                    String remoteVersionString = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    Messages.client.tracef("Client received capability: remote version is \"%s\"", remoteVersionString);
                                    continue block37;
                                }
                                case 6: {
                                    useDefaultChannels = false;
                                    channelsOut = ProtocolUtils.readIntData(data, len);
                                    Messages.client.tracef("Client received capability: remote channels in is \"%d\"", channelsOut);
                                    continue block37;
                                }
                                case 7: {
                                    useDefaultChannels = false;
                                    channelsIn = ProtocolUtils.readIntData(data, len);
                                    Messages.client.tracef("Client received capability: remote channels out is \"%d\"", channelsIn);
                                    continue block37;
                                }
                                case 8: {
                                    authCap = true;
                                    Messages.client.trace("Client received capability: authentication service");
                                    continue block37;
                                }
                            }
                            Messages.client.tracef("Client received unknown capability %02x", type & 0xFF);
                        }
                        if (useDefaultChannels) {
                            channelsIn = 40;
                            channelsOut = 40;
                        }
                        if (starttls && ClientConnectionOpenListener.this.optionMap.get(Options.SSL_STARTTLS, true)) {
                            Pooled<ByteBuffer> pooledSendBuffer = ClientConnectionOpenListener.this.connection.allocate();
                            boolean ok = false;
                            try {
                                ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
                                sendBuffer.put((byte)7);
                                sendBuffer.flip();
                                ClientConnectionOpenListener.this.connection.setReadListener(new StartTls(this.remoteServerName), true);
                                ClientConnectionOpenListener.this.connection.send(pooledSendBuffer);
                                ok = true;
                                return;
                            }
                            finally {
                                if (!ok) {
                                    pooledSendBuffer.free();
                                }
                            }
                        }
                        if (serverSaslMechs.isEmpty()) break;
                        AuthenticationContextConfigurationClient configurationClient = AUTH_CONFIGURATION_CLIENT;
                        UnaryOperator factoryOperator = factory -> new ServerNameSaslClientFactory(factory, this.remoteServerName);
                        factoryOperator = ClientConnectionOpenListener.and(ClientConnectionOpenListener.this.saslClientFactoryOperator, factoryOperator);
                        try {
                            saslClient = configurationClient.createSaslClient(this.uri, ClientConnectionOpenListener.this.configuration, serverSaslMechs, factoryOperator);
                        }
                        catch (SaslException e) {
                            ClientConnectionOpenListener.this.connection.handleException(e);
                            message.free();
                            return;
                        }
                        if (saslClient != null) {
                            String mechanismName = saslClient.getMechanismName();
                            Messages.client.tracef("Client initiating authentication using mechanism %s", mechanismName);
                            ClientConnectionOpenListener.this.connection.getMessageReader().suspendReads();
                            int negotiatedVersion = version;
                            SaslClient usedSaslClient = saslClient;
                            Authentication authentication = new Authentication(usedSaslClient, this.remoteServerName, remoteEndpointName, behavior, channelsIn, channelsOut, authCap);
                            ClientConnectionOpenListener.this.connection.getExecutor().execute(() -> {
                                byte[] response;
                                try {
                                    response = usedSaslClient.hasInitialResponse() ? usedSaslClient.evaluateChallenge(SaslUtils.EMPTY_BYTES) : null;
                                }
                                catch (SaslException e) {
                                    Messages.client.tracef("Client authentication failed: %s", e);
                                    ClientConnectionOpenListener.this.saslDispose(usedSaslClient);
                                    ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                    ClientConnectionOpenListener.this.sendCapRequest(this.remoteServerName);
                                    return;
                                }
                                Pooled<ByteBuffer> pooledSendBuffer = ClientConnectionOpenListener.this.connection.allocate();
                                boolean ok = false;
                                try {
                                    ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
                                    sendBuffer.put((byte)2);
                                    if (negotiatedVersion < 1) {
                                        sendBuffer.put(mechanismName.getBytes(StandardCharsets.UTF_8));
                                    } else {
                                        ProtocolUtils.writeString(sendBuffer, mechanismName);
                                        if (response != null) {
                                            sendBuffer.put(response);
                                        }
                                    }
                                    sendBuffer.flip();
                                    ClientConnectionOpenListener.this.connection.send(pooledSendBuffer);
                                    ok = true;
                                    ClientConnectionOpenListener.this.connection.setReadListener(authentication, true);
                                    return;
                                }
                                finally {
                                    if (!ok) {
                                        pooledSendBuffer.free();
                                    }
                                }
                            });
                            return;
                        }
                        if (ClientConnectionOpenListener.this.failedMechs.isEmpty()) {
                            ClientConnectionOpenListener.this.connection.handleException(new SaslException("Authentication failed: none of the mechanisms presented by the server are supported"));
                            return;
                        }
                        ClientConnectionOpenListener.this.connection.handleException(ClientConnectionOpenListener.this.allMechanismsFailed());
                        return;
                    }
                    default: {
                        Messages.client.unknownProtocolId(msgType);
                        ClientConnectionOpenListener.this.connection.handleException(Messages.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                        return;
                    }
                }
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            if (ClientConnectionOpenListener.this.failedMechs.isEmpty()) {
                ClientConnectionOpenListener.this.connection.handleException(new SaslException("Authentication failed: the server presented no authentication mechanisms"));
                return;
            }
            ClientConnectionOpenListener.this.connection.handleException(ClientConnectionOpenListener.this.allMechanismsFailed());
            return;
            finally {
                message.free();
            }
        }
    }

    final class Greeting
    implements ChannelListener<ConduitStreamSourceChannel> {
        Greeting() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConduitStreamSourceChannel channel) {
            Pooled<ByteBuffer> message;
            try {
                message = ClientConnectionOpenListener.this.connection.getMessageReader().getMessage();
            }
            catch (IOException e) {
                ClientConnectionOpenListener.this.connection.handleException(e);
                return;
            }
            if (message == MessageReader.EOF_MARKER) {
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.abruptClose(ClientConnectionOpenListener.this.connection));
                return;
            }
            if (message == null) {
                return;
            }
            try {
                ByteBuffer receiveBuffer = (ByteBuffer)message.getResource();
                Messages.client.tracef("Received %s", receiveBuffer);
                String remoteServerName = null;
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        Messages.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        Messages.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        Messages.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 0: {
                        Messages.client.trace("Client received greeting");
                        block20: while (receiveBuffer.hasRemaining()) {
                            byte type = receiveBuffer.get();
                            int len = receiveBuffer.get() & 0xFF;
                            ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                            switch (type) {
                                case 0: {
                                    remoteServerName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    Messages.client.tracef("Client received server name: %s", remoteServerName);
                                    continue block20;
                                }
                            }
                            Messages.client.tracef("Client received unknown greeting message %02x", type & 0xFF);
                        }
                        if (remoteServerName == null) {
                            remoteServerName = ClientConnectionOpenListener.this.connection.getPeerAddress().getHostName();
                        }
                        ClientConnectionOpenListener.this.sendCapRequest(remoteServerName);
                        return;
                    }
                }
                Messages.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(Messages.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                message.free();
            }
        }
    }
}

