package org.jboss.remoting3._private;

import org.jboss.remoting3.ChannelBusyException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.wildfly.security.auth.AuthenticationException;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.security.sasl.SaslException;
import java.lang.Exception;
import org.jboss.remoting3.NotOpenException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.net.SocketAddress;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-04-20T11:21:55-0500")
public class Messages_$logger extends DelegatingBasicLogger implements Messages,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    public Messages_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void connectionError(final IOException cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, connectionError$str(), cause);
    }
    private static final String connectionError = "JBREM000200: Remote connection failed: %s";
    protected String connectionError$str() {
        return connectionError;
    }
    private static final String invalidMessage = "JBREM000201: Received invalid message on %s";
    protected String invalidMessage$str() {
        return invalidMessage;
    }
    @Override
    public final IOException invalidMessage(final Object connection) {
        final IOException result = new IOException(String.format(invalidMessage$str(), connection));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String abruptClose = "JBREM000202: Abrupt close on %s";
    protected String abruptClose$str() {
        return abruptClose;
    }
    @Override
    public final IOException abruptClose(final Object connection) {
        final IOException result = new IOException(String.format(abruptClose$str(), connection));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void bufferUnderflowRaw() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, bufferUnderflowRaw$str());
    }
    private static final String bufferUnderflowRaw = "JBREM000203: Message missing protocol byte";
    protected String bufferUnderflowRaw$str() {
        return bufferUnderflowRaw;
    }
    @Override
    public final void bufferUnderflow(final int id) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, bufferUnderflow$str(), id);
    }
    private static final String bufferUnderflow = "JBREM000204: Buffer underflow parsing message with protocol ID %02x";
    protected String bufferUnderflow$str() {
        return bufferUnderflow;
    }
    @Override
    public final void failedToAccept(final Exception e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, failedToAccept$str(), e);
    }
    private static final String failedToAccept = "JBREM000205: Failed to accept a connection: %s";
    protected String failedToAccept$str() {
        return failedToAccept;
    }
    private static final String channelNotOpen = "JBREM000206: Channel is not open";
    protected String channelNotOpen$str() {
        return channelNotOpen;
    }
    @Override
    public final NotOpenException channelNotOpen() {
        final NotOpenException result = new NotOpenException(String.format(channelNotOpen$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String channelBusy = "JBREM000207: Failed to send a message (channel is busy)";
    protected String channelBusy$str() {
        return channelBusy;
    }
    @Override
    public final ChannelBusyException channelBusy() {
        final ChannelBusyException result = new ChannelBusyException(String.format(channelBusy$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String writeInterrupted = "JBREM000208: Write operation interrupted";
    protected String writeInterrupted$str() {
        return writeInterrupted;
    }
    @Override
    public final InterruptedIOException writeInterrupted() {
        final InterruptedIOException result = new InterruptedIOException(String.format(writeInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void exceptionInUserHandler(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, throwable, exceptionInUserHandler$str());
    }
    private static final String exceptionInUserHandler = "JBREM000209: An exception occurred in a message handler";
    protected String exceptionInUserHandler$str() {
        return exceptionInUserHandler;
    }
    @Override
    public final void duplicateMessageId(final short messageId, final SocketAddress peerAddress) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.FATAL, null, duplicateMessageId$str(), messageId, peerAddress);
    }
    private static final String duplicateMessageId = "JBREM000210: Internal Error: received a message with duplicate ID %d from %s";
    protected String duplicateMessageId$str() {
        return duplicateMessageId;
    }
    private static final String duplicateMessageIdException = "Internal Error: received a message with a duplicate ID";
    protected String duplicateMessageIdException$str() {
        return duplicateMessageIdException;
    }
    @Override
    public final IOException duplicateMessageIdException() {
        final IOException result = new IOException(String.format(duplicateMessageIdException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidWorker = "JBREM000211: Invalid XNIO worker; the worker must match the Remoting Endpoint worker";
    protected String invalidWorker$str() {
        return invalidWorker;
    }
    @Override
    public final IllegalArgumentException invalidWorker() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidWorker$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToConfigureSslContext = "JBREM000212: Failed to configure SSL context";
    protected String failedToConfigureSslContext$str() {
        return failedToConfigureSslContext;
    }
    @Override
    public final IOException failedToConfigureSslContext(final Throwable cause) {
        final IOException result = new IOException(String.format(failedToConfigureSslContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unknownProtocolId(final int id) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, null, unknownProtocolId$str(), id);
    }
    private static final String unknownProtocolId = "Message with unknown protocol ID %d received";
    protected String unknownProtocolId$str() {
        return unknownProtocolId;
    }
    @Override
    public final void rejectedInvalidMechanism(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, null, rejectedInvalidMechanism$str(), name);
    }
    private static final String rejectedInvalidMechanism = "Rejected invalid SASL mechanism %s";
    protected String rejectedInvalidMechanism$str() {
        return rejectedInvalidMechanism;
    }
    private static final String authenticationExceptionIo = "JBREM000300: Authentication failed due to I/O error";
    protected String authenticationExceptionIo$str() {
        return authenticationExceptionIo;
    }
    @Override
    public final AuthenticationException authenticationExceptionIo(final IOException e) {
        final AuthenticationException result = new AuthenticationException(String.format(authenticationExceptionIo$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechanismNameTooLong = "JBREM000301: Mechanism name \"%s\" is too long";
    protected String mechanismNameTooLong$str() {
        return mechanismNameTooLong;
    }
    @Override
    public final IOException mechanismNameTooLong(final String mechName) {
        final IOException result = new IOException(String.format(mechanismNameTooLong$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationMessageTooLarge = "JBREM000302: Authentication message too large";
    protected String authenticationMessageTooLarge$str() {
        return authenticationMessageTooLarge;
    }
    @Override
    public final IOException authenticationMessageTooLarge() {
        final IOException result = new IOException(String.format(authenticationMessageTooLarge$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationExtraResponse = "JBREM000303: Authentication protocol failed (extra response)";
    protected String authenticationExtraResponse$str() {
        return authenticationExtraResponse;
    }
    @Override
    public final AuthenticationException authenticationExtraResponse() {
        final AuthenticationException result = new AuthenticationException(String.format(authenticationExtraResponse$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverRejectedAuthentication = "JBREM000304: Server rejected authentication";
    protected String serverRejectedAuthentication$str() {
        return serverRejectedAuthentication;
    }
    @Override
    public final AuthenticationException serverRejectedAuthentication() {
        final AuthenticationException result = new AuthenticationException(String.format(serverRejectedAuthentication$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationExceptionClosed = "JBREM000305: Authentication failed (connection closed)";
    protected String authenticationExceptionClosed$str() {
        return authenticationExceptionClosed;
    }
    @Override
    public final AuthenticationException authenticationExceptionClosed() {
        final AuthenticationException result = new AuthenticationException(String.format(authenticationExceptionClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationNoSaslClient = "JBREM000306: Authentication failed (SASL client construction failure)";
    protected String authenticationNoSaslClient$str() {
        return authenticationNoSaslClient;
    }
    @Override
    public final AuthenticationException authenticationNoSaslClient(final SaslException e) {
        final AuthenticationException result = new AuthenticationException(String.format(authenticationNoSaslClient$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationInterrupted = "JBREM000307: Authentication interrupted";
    protected String authenticationInterrupted$str() {
        return authenticationInterrupted;
    }
    @Override
    public final AuthenticationException authenticationInterrupted() {
        final AuthenticationException result = new AuthenticationException(String.format(authenticationInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAuthMechanismsLeft = "JBREM000308: Authentication failed (no mechanisms left), tried: %s";
    protected String noAuthMechanismsLeft$str() {
        return noAuthMechanismsLeft;
    }
    @Override
    public final AuthenticationException noAuthMechanismsLeft(final String triedStr) {
        final AuthenticationException result = new AuthenticationException(String.format(noAuthMechanismsLeft$str(), triedStr));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationNotSupported = "JBREM000309: Authentication not supported for this peer";
    protected String authenticationNotSupported$str() {
        return authenticationNotSupported;
    }
    @Override
    public final AuthenticationException authenticationNotSupported() {
        final AuthenticationException result = new AuthenticationException(String.format(authenticationNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
