package org.jboss.remoting3.remote;

import org.jboss.remoting3.ChannelBusyException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.remoting3.NotOpenException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.jboss.remoting3.remote.RemoteConnection;
import java.util.Arrays;
import java.net.SocketAddress;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2016-06-16T14:30:30-0500")
public class RemoteLogger_$logger extends DelegatingBasicLogger implements RemoteLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = RemoteLogger_$logger.class.getName();
    public RemoteLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void connectionError(final IOException cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, connectionError$str(), cause);
    }
    private static final String connectionError = "JBREM000200: Remote connection failed: %s";
    protected String connectionError$str() {
        return connectionError;
    }
    private static final String invalidMessage = "JBREM000201: Received invalid message on %s";
    protected String invalidMessage$str() {
        return invalidMessage;
    }
    @Override
    public final IOException invalidMessage(final org.jboss.remoting3.remote.RemoteConnection connection) {
        final IOException result = new IOException(String.format(invalidMessage$str(), connection));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String abruptClose = "JBREM000202: Abrupt close on %s";
    protected String abruptClose$str() {
        return abruptClose;
    }
    @Override
    public final IOException abruptClose(final org.jboss.remoting3.remote.RemoteConnection connection) {
        final IOException result = new IOException(String.format(abruptClose$str(), connection));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void bufferUnderflowRaw() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, bufferUnderflowRaw$str());
    }
    private static final String bufferUnderflowRaw = "JBREM000203: Message missing protocol byte";
    protected String bufferUnderflowRaw$str() {
        return bufferUnderflowRaw;
    }
    @Override
    public final void bufferUnderflow(final int id) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, bufferUnderflow$str(), id);
    }
    private static final String bufferUnderflow = "JBREM000204: Buffer underflow parsing message with protocol ID %02x";
    protected String bufferUnderflow$str() {
        return bufferUnderflow;
    }
    @Override
    public final void failedToAccept(final IOException e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, failedToAccept$str(), e);
    }
    private static final String failedToAccept = "JBREM000205: Failed to accept a connection: %s";
    protected String failedToAccept$str() {
        return failedToAccept;
    }
    private static final String channelNotOpen = "JBREM000206: Channel is not open";
    protected String channelNotOpen$str() {
        return channelNotOpen;
    }
    @Override
    public final NotOpenException channelNotOpen() {
        final NotOpenException result = new NotOpenException(String.format(channelNotOpen$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String channelBusy = "JBREM000207: Failed to send a message (channel is busy)";
    protected String channelBusy$str() {
        return channelBusy;
    }
    @Override
    public final ChannelBusyException channelBusy() {
        final ChannelBusyException result = new ChannelBusyException(String.format(channelBusy$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String writeInterrupted = "JBREM000208: Write operation interrupted";
    protected String writeInterrupted$str() {
        return writeInterrupted;
    }
    @Override
    public final InterruptedIOException writeInterrupted() {
        final InterruptedIOException result = new InterruptedIOException(String.format(writeInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void exceptionInUserHandler(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, throwable, exceptionInUserHandler$str());
    }
    private static final String exceptionInUserHandler = "JBREM000209: An exception occurred in a message handler";
    protected String exceptionInUserHandler$str() {
        return exceptionInUserHandler;
    }
    @Override
    public final void duplicateMessageId(final short messageId, final SocketAddress peerAddress) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.FATAL, null, duplicateMessageId$str(), messageId, peerAddress);
    }
    private static final String duplicateMessageId = "JBREM000210: Internal Error: received a message with duplicate ID %d from %s";
    protected String duplicateMessageId$str() {
        return duplicateMessageId;
    }
    private static final String duplicateMessageIdException = "Internal Error: received a message with a duplicate ID";
    protected String duplicateMessageIdException$str() {
        return duplicateMessageIdException;
    }
    @Override
    public final IOException duplicateMessageIdException() {
        final IOException result = new IOException(String.format(duplicateMessageIdException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unknownProtocolId(final int id) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, null, unknownProtocolId$str(), id);
    }
    private static final String unknownProtocolId = "Message with unknown protocol ID %d received";
    protected String unknownProtocolId$str() {
        return unknownProtocolId;
    }
    private static final String invalidWorker = "JBREM000211: Invalid XNIO worker; the worker must match the Remoting Endpoint worker";
    protected String invalidWorker$str() {
        return invalidWorker;
    }
    @Override
    public final IllegalArgumentException invalidWorker() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidWorker$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
